/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal;

import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Object;
import rs.petcom.master.dal.Settings;

public class DPUList {
    private int DPUListID;
    private Date date;
    private int ObjectID;

    public int getDPUListID() {
        return this.DPUListID;
    }

    public void setDPUListID(int dPUListID) {
        this.DPUListID = dPUListID;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public int getObjectID() {
        return this.ObjectID;
    }

    public void setObjectID(int objectID) {
        this.ObjectID = objectID;
    }

    public String toString() {
        return Settings.getDateFromatter().format(this.date);
    }

    public int insert(Connection connection) {
        int result = -1;
        String query = "insert into dpulist(`Date`,ObjectID) values(?,?)";
        try {
            PreparedStatement ps = connection.prepareStatement(query, 1);
            ps.setDate(1, new java.sql.Date(this.date.getTime()));
            ps.setInt(2, this.ObjectID);
            ps.executeUpdate();
            ResultSet rs = ps.getGeneratedKeys();
            rs.next();
            this.DPUListID = rs.getInt(1);
            rs.close();
            ps.close();
            return this.DPUListID;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return result;
        }
    }

    public void update(Connection connection) {
        String query = "update dpulist set \t`Date` = ?, ObjectID = ? where DPUListID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setDate(1, new java.sql.Date(this.date.getTime()));
            ps.setInt(2, this.ObjectID);
            ps.setInt(3, this.DPUListID);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void delete(Connection connection) {
        String query = "delete from dpulist where DPUListID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, this.DPUListID);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static ObservableList<DPUList> getList(int objectId, Date dateFrom, Date dateTo, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "select * from dpulist  where ObjectID = ? and Date >= ? and Date <= ? order by `Date` desc";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, objectId);
            ps.setDate(2, new java.sql.Date(dateFrom.getTime()));
            ps.setDate(3, new java.sql.Date(dateTo.getTime()));
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                DPUList dl = new DPUList();
                dl.setDPUListID(rs.getInt("DPUListID"));
                dl.setObjectID(rs.getInt("ObjectID"));
                dl.setDate(new Date(rs.getDate("Date").getTime()));
                list.add((java.lang.Object)dl);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public void exportToXml(String fileName, ScreensController controller) throws SQLException, FileNotFoundException, UnsupportedEncodingException {
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy");
        NumberFormat nf2 = Settings.getNumberFormat(2, false);
        NumberFormat nf4 = Settings.getNumberFormat(4, false);
        Object o = Object.getById(this.ObjectID, controller);
        PreparedStatement ps = controller.getSettings().getConnection().prepareStatement("CALL dpu_lista_v2(?,?)");
        ps.setInt(1, this.ObjectID);
        ps.setDate(2, new java.sql.Date(this.date.getTime()));
        ResultSet rs = ps.executeQuery();
        PrintWriter writer = new PrintWriter(fileName, "UTF-8");
        writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>");
        writer.println("<DpuListExport>");
        writer.println("\t<DpuListData>");
        writer.println("\t\t<ObjectCode>" + o.getCode() + "</ObjectCode>");
        writer.println("\t\t<DpuListDate>" + sdf.format(this.getDate()) + "</DpuListDate>");
        writer.println("\t</DpuListData>");
        writer.println("\t<DpuListItems>");
        while (rs.next()) {
            writer.println("\t\t<DpuListItem>");
            writer.println("\t\t\t<ProductCode>" + rs.getString("Code") + "</ProductCode>");
            writer.println("\t\t\t<ProductName>" + rs.getString("Name").replace("&", "&amp;") + "</ProductName>");
            writer.println("\t\t\t<Vat>" + nf2.format(rs.getDouble("Vat")) + "</Vat>");
            writer.println("\t\t\t<JM>" + rs.getString("JM") + "</JM>");
            writer.println("\t\t\t<PocetnoStanje>" + nf4.format(rs.getDouble("PocetnoStanje")) + "</PocetnoStanje>");
            writer.println("\t\t\t<Ulaz>" + nf4.format(rs.getDouble("Ulaz")) + "</Ulaz>");
            writer.println("\t\t\t<Utroseno>" + nf4.format(rs.getDouble("Utroseno")) + "</Utroseno>");
            writer.println("\t\t\t<Utroseno_davanja>" + nf4.format(rs.getDouble("Utroseno_davanja")) + "</Utroseno_davanja>");
            writer.println("\t\t\t<Utroseno_rashod>" + nf4.format(rs.getDouble("Utroseno_rashod")) + "</Utroseno_rashod>");
            writer.println("\t\t\t<KrajnjeStanje>" + nf4.format(rs.getDouble("KrajnjeStanje")) + "</KrajnjeStanje>");
            writer.println("\t\t\t<Cena>" + nf4.format(rs.getDouble("Cena")) + "</Cena>");
            writer.println("\t\t\t<Pice>" + nf4.format(rs.getDouble("Pice")) + "</Pice>");
            writer.println("\t\t\t<Jelo>" + nf4.format(rs.getDouble("Jelo")) + "</Jelo>");
            writer.println("\t\t</DpuListItem>");
        }
        writer.println("\t</DpuListItems>");
        writer.println("\t<DnevniIzvestaji>");
        ps = controller.getSettings().getConnection().prepareStatement("CALL dpu_specifikacija_di(?)");
        ps.setInt(1, this.DPUListID);
        rs = ps.executeQuery();
        while (rs.next()) {
            writer.println("\t\t<DnevniIzvestaj>");
            writer.println("\t\t\t<Broj>" + rs.getString("Number") + "</Broj>");
            writer.println("\t\t\t<Gotovina>" + nf2.format(rs.getDouble("Cash")) + "</Gotovina>");
            writer.println("\t\t\t<Kartica>" + nf2.format(rs.getDouble("Card")) + "</Kartica>");
            writer.println("\t\t\t<Cek>" + nf2.format(rs.getDouble("NonFiscal")) + "</Cek>");
            writer.println("\t\t</DnevniIzvestaj>");
        }
        writer.println("\t</DnevniIzvestaji>");
        writer.println("\t<NaloziZaIspravku>");
        ps = controller.getSettings().getConnection().prepareStatement("CALL dpu_specifikacija_ni(?,?)");
        ps.setDate(1, new java.sql.Date(this.date.getTime()));
        ps.setInt(2, this.ObjectID);
        rs = ps.executeQuery();
        while (rs.next()) {
            if (rs.getString("Number").equals("")) continue;
            writer.println("\t\t<NalogZaIspravku>");
            writer.println("\t\t\t<Broj>" + rs.getString("Number") + "</Broj>");
            writer.println("\t\t\t<Gotovina>" + nf2.format(rs.getDouble("Cash")) + "</Gotovina>");
            writer.println("\t\t\t<Kartica>" + nf2.format(rs.getDouble("Card")) + "</Kartica>");
            writer.println("\t\t\t<Cek>" + nf2.format(rs.getDouble("NonFiscal")) + "</Cek>");
            writer.println("\t\t</NalogZaIspravku>");
        }
        writer.println("\t</NaloziZaIspravku>");
        writer.println("\t<RucnoPisaniRacuni>");
        ps = controller.getSettings().getConnection().prepareStatement("CALL dpu_specifikacija_rpr(?,?)");
        ps.setDate(1, new java.sql.Date(this.date.getTime()));
        ps.setInt(2, this.ObjectID);
        rs = ps.executeQuery();
        while (rs.next()) {
            if (rs.getString("Number").equals("")) continue;
            writer.println("\t\t<RucnoPisaniRacun>");
            writer.println("\t\t\t<Broj>" + rs.getString("Number") + "</Broj>");
            writer.println("\t\t\t<Gotovina>" + nf2.format(rs.getDouble("Cash")) + "</Gotovina>");
            writer.println("\t\t\t<Kartica>" + nf2.format(rs.getDouble("Card")) + "</Kartica>");
            writer.println("\t\t\t<Cek>" + nf2.format(rs.getDouble("NonFiscal")) + "</Cek>");
            writer.println("\t\t</RucnoPisaniRacun>");
        }
        writer.println("\t</RucnoPisaniRacuni>");
        writer.println("</DpuListExport>");
        writer.close();
        rs.close();
        ps.close();
    }
}

