/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.dal.Controll;
import rs.petcom.master.dal.product.Product;

public class ControllProduct {
    private int ControllProductID;
    private int ControllID;
    private long ProductID;
    private String Code;
    private String Name;

    public int getControllProductID() {
        return this.ControllProductID;
    }

    public void setControllProductID(int controllProductID) {
        this.ControllProductID = controllProductID;
    }

    public int getControllID() {
        return this.ControllID;
    }

    public void setControllID(int controllID) {
        this.ControllID = controllID;
    }

    public long getProductID() {
        return this.ProductID;
    }

    public void setProductID(long productID) {
        this.ProductID = productID;
    }

    public String getCode() {
        return this.Code;
    }

    public void setCode(String code) {
        this.Code = code;
    }

    public String getName() {
        return this.Name;
    }

    public void setName(String name) {
        this.Name = name;
    }

    public String toString() {
        return this.Name;
    }

    public static ObservableList<ControllProduct> getList(Controll controll, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "select \tcp.*,\tp.Code,\tp.Name  from controllproduct cp  left join product p on p.ProductID = cp.ProductID where cp.ControllID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, controll.getControllID());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ControllProduct cp = new ControllProduct();
                cp.setControllProductID(rs.getInt("ControllProductID"));
                cp.setControllID(rs.getInt("ControllID"));
                cp.setProductID(rs.getLong("ProductID"));
                cp.setCode(rs.getString("Code"));
                cp.setName(rs.getString("Name"));
                list.add((Object)cp);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public void delete(Connection connection) {
        String query = "delete from controllproduct  where ControllProductID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, this.ControllProductID);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void insert(Controll controll, Product prodcut, Connection connection) {
        String query = "insert into controllproduct(`ControllID`,\t`ProductID`) values(?,?)";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, controll.getControllID());
            ps.setLong(2, prodcut.getProductID());
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

