/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.Object;
import rs.petcom.master.dal.PointOfSale;
import rs.petcom.master.dal.WorkDay;
import rs.petcom.master.dal.product.Product;
import rs.petcom.master.dal.product.ProductComponent;

public class ControllData {
    private int ControllDataID;
    private int ControllID;
    private int Group;
    private String Name;
    private Date ControllTime;
    private double CalculatedValue = 0.0;
    private double EnteredValue = 0.0;
    private double Difference = 0.0;
    private String Comment;
    private long ProductID;
    private int UnitID;
    private int VatID;

    public int getControllDataID() {
        return this.ControllDataID;
    }

    public void setControllDataID(int controllDataID) {
        this.ControllDataID = controllDataID;
    }

    public int getControllID() {
        return this.ControllID;
    }

    public void setControllID(int controllID) {
        this.ControllID = controllID;
    }

    public Date getControllTime() {
        return this.ControllTime;
    }

    public void setControllTime(Date controllTime) {
        this.ControllTime = controllTime;
    }

    public double getCalculatedValue() {
        return this.CalculatedValue;
    }

    public void setCalculatedValue(double calculatedValue) {
        this.CalculatedValue = calculatedValue;
    }

    public double getEnteredValue() {
        return this.EnteredValue;
    }

    public void setEnteredValue(double enteredValue) {
        this.EnteredValue = enteredValue;
        this.Difference = this.CalculatedValue - enteredValue;
    }

    public String getName() {
        return this.Name;
    }

    public void setName(String name) {
        this.Name = name;
    }

    public int getGroup() {
        return this.Group;
    }

    public void setGroup(int group) {
        this.Group = group;
    }

    public double getDifference() {
        return this.Difference;
    }

    public void setDifference(double difference) {
        this.Difference = difference;
    }

    public String getComment() {
        return this.Comment;
    }

    public void setComment(String comment) {
        this.Comment = comment;
    }

    public long getProductID() {
        return this.ProductID;
    }

    public void setProductID(long productID) {
        this.ProductID = productID;
    }

    public int getUnitID() {
        return this.UnitID;
    }

    public void setUnitID(int unitID) {
        this.UnitID = unitID;
    }

    public int getVatID() {
        return this.VatID;
    }

    public void setVatID(int vatID) {
        this.VatID = vatID;
    }

    public static ObservableList<ControllData> getControllList(LocalDate dateFrom, LocalDate dateTo, int objectId, Connection connection) throws SQLException {
        ObservableList list = FXCollections.observableArrayList();
        String query = "select distinct cd.ControllTime from controlldata cd   where cd.ControllTime >= ? and cd.ControllTime <= ?   and cd.ObjectID = ?  order by cd.ControllTime desc";
        PreparedStatement ps = connection.prepareStatement(query);
        ps.setDate(1, java.sql.Date.valueOf(dateFrom));
        ps.setDate(2, java.sql.Date.valueOf(dateTo.plusDays(1L)));
        ps.setInt(3, objectId);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            ControllData cd = new ControllData();
            cd.setControllTime(rs.getTimestamp("ControllTime"));
            list.add((java.lang.Object)cd);
        }
        rs.close();
        ps.close();
        return list;
    }

    public static Timestamp getLastControllTime(Connection connection) {
        String query = "select coalesce(max(cd.ControllTime),\t\t\t    (select min(Date)\t\t   \t\t   from document))  from controlldata cd";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            rs.next();
            return rs.getTimestamp(1);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ObservableList<ControllData> createNewControll(Timestamp time, Department department, Object object, ScreensController controller) throws SQLException {
        LocalDate currentDate = LocalDate.now();
        for (WorkDay wd : WorkDay.getList(currentDate, currentDate, object.getObjectID(), controller.getSettings().getConnection())) {
            wd.saveRecap(controller);
        }
        String query = "select \tc.ControllID, \tc.`Group`,\tp.ProductID, \tp.Name,\tc.ProductID,\tproduct_initial_stock(p.ProductID,now(),?) -     product_output(p.ProductID,now(),now(),?) +     product_input(p.ProductID,now(),now(),?) as stanje   from controll c   left join product p on p.ProductID = c.ProductID where c.Active = true and c.ObjectID = ? order by sort";
        ObservableList controllList = FXCollections.observableArrayList();
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.setInt(1, department.getDepartmentID());
            ps.setInt(2, department.getDepartmentID());
            ps.setInt(3, department.getDepartmentID());
            ps.setInt(4, object.getObjectID());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ControllData cd = new ControllData();
                cd.setControllID(rs.getInt("ControllID"));
                cd.setGroup(rs.getInt("Group"));
                cd.setProductID(rs.getLong("ProductID"));
                cd.setName(rs.getString("Name"));
                cd.setCalculatedValue(rs.getDouble("stanje"));
                cd.setEnteredValue(0.0);
                cd.setDifference(0.0);
                controllList.add((java.lang.Object)cd);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return controllList;
    }

    public void insert(Timestamp time, Connection connection, Object object) {
        String query = "insert into controlldata (ControllID,ControllTime,CalculatedValue,EnteredValue,Comment,ObjectId)  values(?,?,round(?,2),?,?,?)";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, this.getControllID());
            ps.setTimestamp(2, time);
            ps.setDouble(3, this.getCalculatedValue());
            ps.setDouble(4, this.getEnteredValue());
            ps.setString(5, this.getComment());
            ps.setObject(6, object.getObjectID());
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static ObservableList<ControllData> getList(Timestamp time, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "select cd.ControllDataID, \t   cd.ControllID,\t   c.Group,\t   p.Name,       cd.ControllTime,       cd.CalculatedValue,       cd.EnteredValue,       cd.CalculatedValue - COALESCE(cd.EnteredValue,0) as Difference,       cd.Comment  from controlldata cd  left join controll c on c.ControllID = cd.ControllID  left join product p on p.ProductID = c.ProductID where cd.ControllTime = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setTimestamp(1, time);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ControllData cd = new ControllData();
                cd.setControllDataID(rs.getInt("ControllDataID"));
                cd.setControllID(rs.getInt("ControllID"));
                cd.setGroup(rs.getInt("Group"));
                cd.setName(rs.getString("Name"));
                cd.setControllTime(rs.getTimestamp("ControllTime"));
                cd.setCalculatedValue(rs.getDouble("CalculatedValue"));
                cd.setEnteredValue(rs.getDouble("EnteredValue"));
                cd.setDifference(rs.getDouble("Difference"));
                cd.setComment(rs.getString("Comment"));
                list.add((java.lang.Object)cd);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ArrayList<ProductComponent> prepareComponentList(Department department, Connection connection) {
        ArrayList<ProductComponent> mainList = new ArrayList<ProductComponent>();
        String query = "select \tdd.Quantity * dt.Stock as quantity,\tp.ProductID,\tp.Name from documentdetails dd left join document d on d.DocumentID = dd.DocumentID left join documenttype dt on dt.DocumentTypeID = d.DocumentTypeID left join productdepartment pd on pd.ProductID = dd.ProductID and pd.DepartmentID = ? left join product p on p.ProductID = pd.ProductID   where d.DocumentID not in (select DocumentParentID from documentrelationship dr where RelationshipTypeID = 2)";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, department.getDepartmentID());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ProductComponent pc = new ProductComponent();
                Product p = new Product();
                p.setProductID(rs.getLong("ProductID"));
                p.setName(rs.getString("Name"));
                pc.setProduct(p);
                pc.setNormative(rs.getDouble("quantity"));
                mainList.add(pc);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return mainList;
    }

    public static ArrayList<ProductComponent> prepareComponentList(PointOfSale pos, Date date, Connection connection) {
        ArrayList<ProductComponent> mainList = new ArrayList<ProductComponent>();
        String query = "select \tdd.Quantity * dt.Stock as quantity,\tp.ProductID,    p.ProductTypeID,    p.Code, \tp.Name,    p.UnitID,    p.VatID   from documentdetails dd  left join document d on d.DocumentID = dd.DocumentID  inner join WorkDay w on w.WorkDayID = d.WorkDayID and w.Date = ?  inner join productdepartment pd on pd.ProductID = dd.ProductID and pd.DepartmentID in (select psd.DepartmentID\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   from pointofsaledepartment psd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t  where psd.PointOfSaleID = ?)  left join documenttype dt on dt.DocumentTypeID = d.DocumentTypeID  left join product p on p.ProductID = pd.ProductID where d.DocumentID not in (select dr.DocumentParentID from documentrelationship dr where dr.RelationshipTypeID = 2) ";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setDate(1, new java.sql.Date(date.getTime()));
            ps.setInt(2, pos.getPointOfSaleID());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ProductComponent pc = new ProductComponent();
                Product p = new Product();
                p.setProductID(rs.getLong("ProductID"));
                p.setName(rs.getString("Name"));
                p.setCode(rs.getString("Code"));
                p.setProductTypeID(rs.getInt("ProductTypeID"));
                p.setUnitID(rs.getInt("UnitID"));
                p.setVatID(rs.getInt("VatID"));
                pc.setProduct(p);
                pc.setNormative(rs.getDouble("quantity"));
                mainList.add(pc);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return mainList;
    }
}

