/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.BuyerOfferPrice;
import rs.petcom.master.dal.product.Product;

public class BuyerOfferPriceDetailes {
    private long BuyerOfferPriceDetailsID;
    private long BuyerOfferPriceID;
    private long ProductID;
    private double Price;
    private Product product;

    public long getBuyerOfferPriceDetailsID() {
        return this.BuyerOfferPriceDetailsID;
    }

    public void setBuyerOfferPriceDetailsID(long buyerOfferPriceDetailsID) {
        this.BuyerOfferPriceDetailsID = buyerOfferPriceDetailsID;
    }

    public long getBuyerOfferPriceID() {
        return this.BuyerOfferPriceID;
    }

    public void setBuyerOfferPriceID(long buyerOfferPriceID) {
        this.BuyerOfferPriceID = buyerOfferPriceID;
    }

    public long getProductID() {
        return this.ProductID;
    }

    public void setProductID(long productID) {
        this.ProductID = productID;
    }

    public double getPrice() {
        return this.Price;
    }

    public void setPrice(double price) {
        this.Price = price;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public static ObservableList<BuyerOfferPriceDetailes> getByProduct(long productID, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String upit = "select opd.*, op.Quantity AS Kolicina from buyerofferpricedetails opd join offerprice op on op.BuyerOfferPriceID = opd.BuyerOfferPriceID \t\t\t\t\tand op.Active = true \t\t\t\t\tand op.DateFrom < now() \t\t\t\t\tand op.DateTo > now() where opd.ProductID = ? ";
        try {
            PreparedStatement ps = connection.prepareStatement(upit);
            ps.setLong(1, productID);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                BuyerOfferPriceDetailes opd = new BuyerOfferPriceDetailes();
                opd.setBuyerOfferPriceDetailsID(rs.getLong("BuyerOfferPriceDetailsID"));
                opd.setProductID(rs.getLong("ProductID"));
                opd.setPrice(rs.getDouble("Price"));
                opd.setBuyerOfferPriceID(rs.getLong("OfferPriceID"));
                list.add((Object)opd);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<BuyerOfferPriceDetailes> getByOfferPriceID(long offerPriceID, ScreensController controller) {
        ObservableList list = FXCollections.observableArrayList();
        String upit = "SELECT opd.*  FROM buyerofferpricedetails opd JOIN buyerofferprice op ON op.BuyerOfferPriceID = opd.BuyerOfferPriceID WHERE opd.BuyerOfferPriceID = ?";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(upit);
            ps.setLong(1, offerPriceID);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                BuyerOfferPriceDetailes opd = new BuyerOfferPriceDetailes();
                opd.setBuyerOfferPriceDetailsID(rs.getLong("BuyerOfferPriceDetailsID"));
                opd.setProductID(rs.getLong("ProductID"));
                opd.setPrice(rs.getDouble("Price"));
                opd.setBuyerOfferPriceID(rs.getLong("BuyerOfferPriceID"));
                opd.setProduct(Product.getByID(opd.getProductID(), controller));
                list.add((Object)opd);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static BuyerOfferPriceDetailes getRoundActive(long productId, long buyerofferpriceId, Connection connection) {
        String upit = "SELECT opd.*, p.Code, p.ShortName, bc.BarCode FROM buyerofferpricedetails opd LEFT JOIN product p On p.ProductID = opd.ProductID LEFT JOIN barcode bc ON bc.ProductID = p.ProductID WHERE opd.ProductID = ? AND opd.BuyerOfferPriceID = ?";
        BuyerOfferPriceDetailes opd = new BuyerOfferPriceDetailes();
        try {
            PreparedStatement ps = connection.prepareStatement(upit);
            ps.setLong(1, productId);
            ps.setLong(2, buyerofferpriceId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                opd.setBuyerOfferPriceDetailsID(rs.getLong("BuyerOfferPriceDetailsID"));
                opd.setProductID(rs.getLong("ProductID"));
                opd.setPrice(rs.getDouble("Price"));
                opd.setBuyerOfferPriceID(rs.getLong("BuyerOfferPriceID"));
                Product product = new Product();
                product.setCode(rs.getString("Code"));
                product.setShortName(rs.getString("ShortName"));
                product.setBarcode(rs.getString("BarCode"));
                opd.setProduct(product);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            return null;
        }
        return opd;
    }

    public static ObservableList<BuyerOfferPriceDetailes> getListByOfferPriceID(long offerPriceID, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String upit = "SELECT opd.*, p.Code, p.ShortName, bc.BarCode FROM buyerofferpricedetails opd LEFT JOIN product p On p.ProductID = opd.ProductID LEFT JOIN barcode bc ON bc.ProductID = p.ProductID WHERE opd.BuyerOfferPriceID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(upit);
            ps.setLong(1, offerPriceID);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                BuyerOfferPriceDetailes opd = new BuyerOfferPriceDetailes();
                opd.setBuyerOfferPriceDetailsID(rs.getLong("BuyerOfferPriceDetailsID"));
                opd.setProductID(rs.getLong("ProductID"));
                opd.setPrice(rs.getDouble("Price"));
                opd.setBuyerOfferPriceID(rs.getLong("BuyerOfferPriceID"));
                Product product = new Product();
                product.setCode(rs.getString("Code"));
                product.setShortName(rs.getString("ShortName"));
                product.setBarcode(rs.getString("BarCode"));
                opd.setProduct(product);
                list.add((Object)opd);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public Long insert(Connection connection) {
        long result = 0L;
        String query = "INSERT INTO `buyerofferpricedetails` (`ProductID`, `Price`, `BuyerOfferPriceID`) VALUES (?, ?, ?)";
        try {
            PreparedStatement ps = connection.prepareStatement(query, 1);
            ps.setLong(1, this.ProductID);
            ps.setDouble(2, this.Price);
            ps.setLong(3, this.BuyerOfferPriceID);
            ps.executeUpdate();
            ResultSet rs = ps.getGeneratedKeys();
            rs.next();
            result = rs.getLong(1);
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public void delete(ScreensController controller) {
        String query = "DELETE FROM `buyerofferpricedetails` WHERE  `BuyerOfferPriceDetailsID` = ?";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query, 1);
            ps.setLong(1, this.getBuyerOfferPriceDetailsID());
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void update(ScreensController controller) {
        String query = "UPDATE `buyerofferpricedetails` SET `Price` = ? WHERE `BuyerOfferPriceDetailsID` = ? AND `BuyerOfferPriceID` = ?;";
        try {
            PreparedStatement statement = controller.getSettings().getConnection().prepareStatement(query);
            statement.setDouble(1, this.Price);
            statement.setLong(2, this.BuyerOfferPriceDetailsID);
            statement.setLong(3, this.BuyerOfferPriceID);
            statement.executeUpdate();
            statement.close();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    public static BuyerOfferPriceDetailes getByBuyerOfferPriceDetailsID(long priceListDetailsId, ScreensController controller) {
        String upit = "SELECT opd.* FROM buyerofferpricedetails opd WHERE opd.BuyerOfferPriceDetailsID = ?";
        BuyerOfferPriceDetailes opd = new BuyerOfferPriceDetailes();
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(upit);
            ps.setLong(1, priceListDetailsId);
            ResultSet rs = ps.executeQuery();
            rs.next();
            opd.setBuyerOfferPriceDetailsID(rs.getLong("BuyerOfferPriceDetailsID"));
            opd.setProductID(rs.getLong("ProductID"));
            opd.setPrice(rs.getDouble("Price"));
            opd.setBuyerOfferPriceID(rs.getLong("BuyerOfferPriceID"));
            opd.setProduct(Product.getByID(opd.getProductID(), controller));
            rs.close();
            ps.close();
            return opd;
        }
        catch (SQLException e) {
            return null;
        }
    }

    public static void delete(Product product, BuyerOfferPrice buyerOfferPrice, ScreensController controller) {
        String query = "DELETE FROM buyerofferpricedetails WHERE buyerofferpricedetails.BuyerOfferPriceDetailsID = ? AND buyerofferpricedetails.BuyerOfferPriceID = ?";
        try {
            PreparedStatement statement = controller.getSettings().getConnection().prepareStatement(query);
            statement.setLong(1, product.getPriceListDetailsId());
            statement.setLong(2, buyerOfferPrice.getBuyerOfferPriceID());
            statement.executeUpdate();
            statement.close();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }
}

