/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Year;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Log;
import rs.petcom.master.dal.OfferPriceDetailes;
import rs.petcom.master.dal.PaymentMethod;
import rs.petcom.master.dal.PointOfSale;
import rs.petcom.master.dal.RelationshipType;
import rs.petcom.master.dal.Round;
import rs.petcom.master.dal.RoundItem;
import rs.petcom.master.dal.RoundItemDescription;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.User;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.document.DocumentDetails;
import rs.petcom.master.dal.document.DocumentRelationship;
import rs.petcom.master.dal.document.DocumentType;
import rs.petcom.master.dal.person.Address;
import rs.petcom.master.dal.person.CashBuyer;
import rs.petcom.master.dal.person.GiftCard;
import rs.petcom.master.dal.person.Person;
import rs.petcom.master.dal.product.Description;
import rs.petcom.master.fical.FiscalPrinter;
import rs.petcom.master.newFiscalization.invoice.InvoiceBody;
import rs.petcom.master.newFiscalization.invoice.InvoiceResponse;

public class Bill {
    private static final Logger LOGGER = Logger.getLogger("global");
    private User user;
    private Person person;
    private int PaymetnMethodID;
    private long LoyalityID;
    private String napomena;
    private String napomena2;
    private Date dateCreatedLastBill;
    private double sumWithDiscountLastBill;
    private double paidLastBill;
    private double paid;
    private PaymentMethod paymentMethod;
    private CashBuyer cashBuyer;
    private GiftCard giftCard;
    private double discount;
    private boolean usingPoints;
    private Long invoiceId;
    private Long salesInvoiceId;
    private Long purchaseInvoiceId;
    private ArrayList<Round> roundList = new ArrayList();

    public Bill(Date dateCreated, double sumWithDiscount, double paid) {
        this.dateCreatedLastBill = dateCreated;
        this.sumWithDiscountLastBill = sumWithDiscount;
        this.paidLastBill = paid;
    }

    public Long getInvoiceId() {
        return this.invoiceId;
    }

    public void setInvoiceId(Long invoiceId) {
        this.invoiceId = invoiceId;
    }

    public Long getSalesInvoiceId() {
        return this.salesInvoiceId;
    }

    public void setSalesInvoiceId(Long salesInvoiceId) {
        this.salesInvoiceId = salesInvoiceId;
    }

    public Long getPurchaseInvoiceId() {
        return this.purchaseInvoiceId;
    }

    public void setPurchaseInvoiceId(Long purchaseInvoiceId) {
        this.purchaseInvoiceId = purchaseInvoiceId;
    }

    public Bill(User user) {
        this.user = user;
    }

    public static void deleteDocument(long documentId, ScreensController controller) {
        String sqldocument = "delete from document  where DocumentID = ?";
        String sqldocumentdetailsdescription = "delete from documentdetailsdescription where DocumentID =? ";
        String sqldocumentdetails = "delete from documentdetails where DocumentID =? ";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(sqldocumentdetails);
            ps.setLong(1, documentId);
            ps.execute();
            ps = controller.getSettings().getConnection().prepareStatement(sqldocument);
            ps.setLong(1, documentId);
            ps.execute();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static String getBillBuyer(long documentId, ScreensController controller) {
        String query = "select d.BuyerIdentification as BuyerIdentification from document d  where d.DocumentID  = ?";
        String BuyerIdentification2 = "";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.setLong(1, documentId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                BuyerIdentification2 = rs.getString("BuyerIdentification") == null ? "" : rs.getString("BuyerIdentification");
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return BuyerIdentification2;
    }

    public static String getBillNote(long documentId, ScreensController controller) {
        String query = "select d.Note as note from document d  where d.DocumentID  = ?";
        String note = "";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.setLong(1, documentId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                note = rs.getString("note") == null ? "" : rs.getString("note");
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return note;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Person getPerson() {
        return this.person;
    }

    public void setPerson(Person person) {
        this.person = person;
    }

    public GiftCard getGiftCard() {
        return this.giftCard;
    }

    public void setGiftCard(GiftCard giftCard) {
        this.giftCard = giftCard;
    }

    public int getPaymetnMethodID() {
        return this.PaymetnMethodID;
    }

    public void setPaymetnMethodID(int paymetnMethodID) {
        this.PaymetnMethodID = paymetnMethodID;
    }

    public long getLoyalityID() {
        return this.LoyalityID;
    }

    public void setLoyalityID(long loyalityID) {
        this.LoyalityID = loyalityID;
    }

    public ArrayList<Round> getRoundList() {
        return this.roundList;
    }

    public void setRoundList(ArrayList<Round> roundList) {
        this.roundList = roundList;
    }

    public PaymentMethod getPaymentMethod() {
        return this.paymentMethod;
    }

    public String getNapomena() {
        return this.napomena;
    }

    public void setNapomena(String napomena) {
        this.napomena = napomena;
    }

    public Date getDateCreatedLastBill() {
        return this.dateCreatedLastBill;
    }

    public double getSumWithDiscountLastBill() {
        return this.sumWithDiscountLastBill;
    }

    public double getPaidLastBill() {
        return this.paidLastBill;
    }

    public double getPaid() {
        return this.paid;
    }

    public void setPaid(double paid) {
        this.paid = paid;
    }

    public double getDiscount() {
        return this.discount;
    }

    public CashBuyer getCashBuyer() {
        return this.cashBuyer;
    }

    public void setCashBuyer(CashBuyer cashBuyer) {
        this.cashBuyer = cashBuyer;
    }

    public void setPaymentMethod(PaymentMethod paymentMethod) {
        this.paymentMethod = paymentMethod;
        this.PaymetnMethodID = paymentMethod.getPaymentMethodID();
    }

    public double getSumWithDiscout() {
        double sum = 0.0;
        for (Round r : this.roundList) {
            sum += r.getSumWithDiscount();
        }
        return sum;
    }

    public boolean isUsingPoints() {
        return this.usingPoints;
    }

    public void setUsingPoints(boolean usingPoints) {
        this.usingPoints = usingPoints;
    }

    public String getNapomena2() {
        return this.napomena2;
    }

    public void setNapomena2(String napomena2) {
        this.napomena2 = napomena2;
    }

    public double getDiscountBillPercent() {
        ArrayList<RoundItem> ri = this.getRoundList().get(0).getItemList();
        double discountBill = 0.0;
        for (int i = 0; i < ri.size(); ++i) {
            double pPrice = ri.get(i).getProductDepartment().getProduct().getPrice();
            double pDiscount = ri.get(i).getProductDepartment().getProduct().getDiscount() / 100.0;
            double pQuantity = ri.get(i).getQuantity();
            if (pDiscount == 0.0) continue;
            discountBill += pPrice * pDiscount * pQuantity;
        }
        return Settings.round(discountBill / this.getSumWithDiscout() * 100.0, 2);
    }

    public void setDiscountIfNotInOffer(double discount) {
        for (Round round : this.roundList) {
            round.setDiscountIfNotInOffer(discount);
        }
    }

    public void setDiscount(double discount) {
        for (Round round : this.roundList) {
            round.setDiscount(discount);
        }
    }

    public void setDiscountIfNotZero(double discount) {
        for (Round round : this.roundList) {
            round.setDiscountIfNotZero(discount);
        }
    }

    public void recalculateOfferPrices(ScreensController controller) {
        for (Round round : this.roundList) {
            round.recalculateOfferPricesNew(controller);
        }
    }

    public void recalculateOfferPricesRoundActive(ScreensController controller) {
        for (Round round : this.roundList) {
            round.recalculateOfferPricewNewRountActive(controller);
        }
    }

    public static Bill getLastInsertedBill(int pointOfSaleID, Connection connection) {
        String query = "select d.Date, d.SumWithDiscount, d.Paid, d.DocumentID from document d  where d.DocumentTypeID in (3, 18) and d.PointOfSaleID = ? order by d.DocumentID desc limit 1";
        Bill bill = null;
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, pointOfSaleID);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                bill = new Bill(rs.getTimestamp(1), rs.getDouble(2), rs.getDouble(3));
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return bill;
    }

    public static void updateDocument(String refNumber, String avanstin, String code, String bayerId, String buyerCostCenterId, Long documentId, String invoiceNumber, String invoiceDateTIme, ScreensController controller) {
        String query = "UPDATE `document` SET `ReferentNumber` = ?, ReferentDateTime=?, BuyerIdentification = ?,buyerCostCenterId = ?,  DocumentStatusID = 1 WHERE  `DocumentID` = ?;";
        String queryCode = "UPDATE `document` SET `ReferentNumber` = ?,DocumentTypeID =?, ReferentDateTime=?, BuyerIdentification = ?, DocumentStatusID = 1 WHERE  `DocumentID` = ?;";
        String queryAvans = "UPDATE `document` SET `ReferentNumber` = ?, ReferentDateTime=?, BuyerIdentification = ?,buyerCostCenterId = ?,FullNumber1 = ?,  DocumentStatusID = 1 WHERE  `DocumentID` = ?;";
        try {
            if (documentId == null) {
                Log.writeLog(controller.getUser(), "Document nije updatovan ReferentNumber." + documentId, controller.getSettings().getConnection());
            }
            if ("PROF".equals(code)) {
                PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(queryCode);
                pStatement.setString(1, invoiceNumber);
                pStatement.setInt(2, 20);
                pStatement.setString(3, invoiceDateTIme);
                pStatement.setString(4, bayerId);
                pStatement.setLong(5, documentId);
                pStatement.executeUpdate();
                pStatement.close();
            } else if (avanstin == null) {
                System.out.println("ovo nije avans " + avanstin);
                PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
                pStatement.setString(1, invoiceNumber);
                pStatement.setString(2, invoiceDateTIme);
                pStatement.setString(3, bayerId);
                pStatement.setString(4, buyerCostCenterId);
                pStatement.setLong(5, documentId);
                pStatement.executeUpdate();
                pStatement.close();
            } else {
                System.out.println("ovo je avans " + avanstin);
                String fullNumber = invoiceNumber;
                if (("avanstin".equals(avanstin) || "refundacija".equals(avanstin)) && refNumber != null && !refNumber.isEmpty()) {
                    fullNumber = Document.findByfullNumber(avanstin, refNumber, controller);
                } else if ("konacniracun".equals(avanstin)) {
                    fullNumber = Document.findByfullNumber(avanstin, refNumber, controller);
                }
                System.out.println("Full Number " + fullNumber);
                PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(queryAvans);
                pStatement.setString(1, invoiceNumber);
                pStatement.setString(2, invoiceDateTIme);
                pStatement.setString(3, bayerId);
                pStatement.setString(4, buyerCostCenterId);
                pStatement.setString(5, fullNumber);
                pStatement.setLong(6, documentId);
                pStatement.executeUpdate();
                System.out.println(pStatement.toString());
                pStatement.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            Log.writeLog(controller.getUser(), "Document: " + documentId + ", nije updatovan ReferentNumber: " + invoiceNumber + " , datum je: " + invoiceDateTIme, controller.getSettings().getConnection());
        }
    }

    public static void updateDocumentRef(String RefExternalNumber, Long documentId, ScreensController controller) {
        String query = "UPDATE `document` SET `RefExternalNumber` = ?,  DocumentStatusID = 1 WHERE  `DocumentID` = ?;";
        try {
            if (documentId == null) {
                Log.writeLog(controller.getUser(), "Document nije updatovan ReferentNumber." + documentId, controller.getSettings().getConnection());
            }
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setString(1, RefExternalNumber);
            pStatement.setLong(2, documentId);
            pStatement.executeUpdate();
            pStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void updateDocumentNumber(Long documentId, ScreensController controller) {
        String query = "select d.Number  from document d   WHERE  `DocumentID` = ?;";
        String queryCode = "UPDATE `document` SET  Number = ?, ReferentNumber = ?, ReferentDateTime = ?  WHERE  `DocumentID` = ?;";
        try {
            PreparedStatement preparedStatement = controller.getSettings().getConnection().prepareStatement(query);
            preparedStatement.setLong(1, documentId);
            ResultSet resultSet = preparedStatement.executeQuery();
            int number = 0;
            if (!resultSet.first()) {
                return;
            }
            number = resultSet.getInt("Number") - 1;
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(queryCode);
            pStatement.setInt(1, number);
            pStatement.setString(2, null);
            pStatement.setString(3, null);
            pStatement.setLong(4, documentId);
            pStatement.executeUpdate();
            pStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            Log.writeLog(controller.getUser(), "Document: " + documentId + ", nije updatovan ReferentNumber: ", controller.getSettings().getConnection());
        }
    }

    public static long writeBill(Bill bill, PointOfSale pos, boolean rucnoPisani, String bi, Double personDiscount, ScreensController controller) throws SQLException {
        String query = "insert into document( \t`DocumentTypeID`,\t`DocumentStatusID`,\t`PointOfSaleID`,\t`Number`, \t`FullNumber`, \t`AlternativeFullNumber`, \t`Year`, \t`Date`, \t`DeliveryDate`, \t`CurrencyDate`, \t`PersonID`, \t`PaymentMethodID`, \t`LoyalityID`, \t`Discount`, \t`Sum`, \t`SumWithDiscount`, \t`Paid`, \t`FromCashBox`, \t`WorkDayID`, \t`sysUserAddID`,   `Place`,   Note) values(?,?,?,?,?,?,?, \t    now(),now(),now(),        ?,?,?,?,?,?,?,?,\t\t(select max(WorkDayID) from workday          where PointOfSaleID = ?            and DateTo is null),\t\t?,?,?)";
        PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query, 1);
        if (!rucnoPisani) {
            ps.setInt(1, DocumentType.getByCode("R", controller.getSettings().getConnection()).getDocumentTypeID());
        } else {
            ps.setInt(1, DocumentType.getByCode("RPR", controller.getSettings().getConnection()).getDocumentTypeID());
        }
        ps.setInt(2, 1);
        ps.setLong(3, pos.getPointOfSaleID());
        if (!rucnoPisani) {
            ps.setInt(4, Document.getNextNumber(DocumentType.getByCode("R", controller.getSettings().getConnection()).getDocumentTypeID(), pos.getPointOfSaleID(), controller));
        } else {
            ps.setInt(4, Document.getNextNumber(DocumentType.getByCode("RPR", controller.getSettings().getConnection()).getDocumentTypeID(), pos.getPointOfSaleID(), controller));
        }
        ps.setString(5, bi);
        ps.setString(6, FiscalPrinter.getIBFM(controller.getSettings().getFiscalFolder()));
        ps.setInt(7, Year.now().getValue());
        try {
            ps.setLong(8, bill.getPerson().getPersonID());
        }
        catch (NullPointerException e) {
            ps.setNull(8, -5);
        }
        ps.setInt(9, bill.getPaymetnMethodID());
        if (bill.LoyalityID != 0L) {
            ps.setLong(10, bill.LoyalityID);
        } else {
            ps.setNull(10, -5);
        }
        if (personDiscount == 0.0) {
            ps.setDouble(11, bill.getDiscount());
        } else {
            ps.setDouble(11, personDiscount);
        }
        ps.setDouble(11, bill.getDiscount());
        ps.setDouble(12, bill.getSumWithDiscout() + bill.getDiscount());
        ps.setDouble(13, bill.getSumWithDiscout());
        ps.setDouble(14, bill.getSumWithDiscout());
        ps.setBoolean(15, false);
        ps.setLong(16, pos.getPointOfSaleID());
        ps.setLong(17, controller.getUser().getUserID());
        ps.setString(18, Address.getByID(controller.getObject().getAddressID(), controller.getSettings().getConnection()).getCity());
        ps.setString(19, bill.getNapomena());
        ps.executeUpdate();
        LOGGER.info(ps.toString());
        ResultSet rs = ps.getGeneratedKeys();
        rs.next();
        Long documnetId = rs.getLong(1);
        String query2 = "insert into documentdetails( \t`DocumentID`, \t`ProductID`, \t`ParentProductID`, \t`Quantity`, \t`VatID`, \t`UnitID`, \t`Price`,\t`Discount`,\t`PriceWithDiscount`,\t`sysUserAddID`,\t`SaleTableID`,\t`OrderNumber`,\t`SubTotal`,\t`Closed`)\tvalues(?,?,?,?,?,?,?,?,?,?,null,1,false,true)";
        ps = controller.getSettings().getConnection().prepareStatement(query2, 1);
        for (int i = 0; i < bill.getRoundList().size(); ++i) {
            Round round = bill.getRoundList().get(i);
            for (RoundItem roundItem : round.getItemList()) {
                ps.setLong(1, documnetId);
                ps.setLong(2, roundItem.getProductDepartment().getProduct().getProductID());
                ps.setNull(3, -5);
                ps.setDouble(4, roundItem.getQuantity());
                ps.setInt(5, roundItem.getProductDepartment().getProduct().getVatID());
                ps.setInt(6, roundItem.getProductDepartment().getProduct().getUnitID());
                ps.setDouble(7, roundItem.getProductDepartment().getProduct().getPrice());
                if (personDiscount != 0.0) {
                    ps.setDouble(8, personDiscount);
                } else {
                    ps.setDouble(8, roundItem.getProductDepartment().getProduct().getDiscount());
                }
                if (personDiscount != 0.0) {
                    ps.setDouble(9, roundItem.getProductDepartment().getProduct().getPrice() - roundItem.getProductDepartment().getProduct().getPrice() / personDiscount);
                } else {
                    ps.setDouble(9, roundItem.getProductDepartment().getProduct().getPrice());
                }
                ps.setLong(10, controller.getUser().getUserID());
                ps.executeUpdate();
                rs = ps.getGeneratedKeys();
                rs.next();
                Long itemIndex = rs.getLong(1);
                for (RoundItem rio : roundItem.getAdditionalList()) {
                    DocumentDetails da = new DocumentDetails();
                    da.setDocumentID(documnetId);
                    da.setProductID(rio.getProductDepartment().getProduct().getProductID());
                    da.setParentDocumentDetailsID(itemIndex);
                    da.setQuantity(rio.getQuantity());
                    da.setVatID(rio.getProductDepartment().getProduct().getVatID());
                    da.setUnitID(rio.getProductDepartment().getProduct().getUnitID());
                    if (personDiscount != 0.0) {
                        da.setPriceWithDiscount(rio.getProductDepartment().getProduct().getPrice() * (1.0 - personDiscount / 100.0));
                    } else {
                        da.setPriceWithDiscount(rio.getProductDepartment().getProduct().getPrice() * (1.0 - rio.getProductDepartment().getProduct().getDiscount() / 100.0));
                    }
                    if (personDiscount != 0.0) {
                        da.setDiscount(personDiscount);
                    } else {
                        da.setDiscount(rio.getProductDepartment().getProduct().getDiscount());
                    }
                    da.setPrice(rio.getProductDepartment().getProduct().getPrice());
                    da.setSysUserAddID(controller.getUser().getUserID());
                    da.insert(controller.getSettings().getConnection());
                }
                String upitD = "insert into documentdetailsdescription (DocumentDetailsID,DescritptionID) values(?,?)";
                PreparedStatement psd = controller.getSettings().getConnection().prepareStatement(upitD);
                for (RoundItemDescription rid : roundItem.getDescriptionalList()) {
                    psd.setLong(1, itemIndex);
                    psd.setLong(2, rid.getDescription().getDescriptionID());
                    psd.executeUpdate();
                }
            }
        }
        ps.setLong(1, documnetId);
        rs.close();
        ps.close();
        return documnetId;
    }

    public static long writeBill(String avanstin, Bill bill, PointOfSale pos, boolean rucnoPisani, String bi, boolean stampaGotovinskog, ScreensController controller, InvoiceResponse response, InvoiceBody body) throws SQLException {
        Logger LOGGER = Logger.getLogger("global");
        String query = "insert into document( \t`DocumentTypeID`,\t`DocumentStatusID`,\t`PointOfSaleID`,\t`Number`, \t`FullNumber`, `ReferentNumber`,\t`PayCardSlipNumber`, \t`AlternativeFullNumber`, \t`Year`, \t`Date`, \t`DeliveryDate`, \t`CurrencyDate`, \t`PersonID`, \t`CashBuyersID`, \t`PaymentMethodID`, \t`LoyalityID`, \t`Discount`, \t`Sum`, \t`SumWithDiscount`, \t`Paid`, \t`FromCashBox`, \t`WorkDayID`, \t`sysUserAddID`,   `Place`,   Note, Note2, ReferentDateTime, BuyerIdentification, invoiceId, salesInvoiceId, purchaseInvoiceId) values(?,?,?,?,?,?,?,?,?, \t    now(),now(),now(),        ?,?,?,?,?,?,?,?,?,\t\t(select max(WorkDayID) from workday          where PointOfSaleID = ?            and DateTo is null),\t\t?,?,?,?,?,?,?,?,?)";
        PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query, 1);
        try {
            if (controller.getSettings().isTrainingMode()) {
                ps.setInt(1, 32);
            } else if (bill.getPaymentMethod().getCode().equals("PROF")) {
                ps.setInt(1, 20);
            } else if ("refundacija".equals(avanstin)) {
                ps.setInt(1, 37);
            } else if ("konacniracun".equals(avanstin)) {
                ps.setInt(1, 3);
            } else if (bill.getPaymentMethod().getCode().equals("AVANS")) {
                ps.setInt(1, 36);
            } else if (controller.getCurrentBill().getPaymentMethod().getCode().equals("OTP")) {
                ps.setInt(1, DocumentType.getByCode("OT", controller.getSettings().getConnection()).getDocumentTypeID());
            } else {
                ps.setInt(1, rucnoPisani ? DocumentType.getByCode("RPR", controller.getSettings().getConnection()).getDocumentTypeID() : (controller.getCurrentBill().getPaymentMethod().getCode().equals("PROF") ? DocumentType.getByCode("PROF", controller.getSettings().getConnection()).getDocumentTypeID() : DocumentType.getByCode("R", controller.getSettings().getConnection()).getDocumentTypeID()));
            }
            ps.setInt(2, 2);
            ps.setLong(3, pos.getPointOfSaleID());
            System.out.println("Avanstin in bill " + avanstin);
            if (controller.getSettings().isTrainingMode()) {
                ps.setInt(4, Document.getNextNumber(32, pos.getPointOfSaleID(), controller));
            } else if ("konacniracun".equals(avanstin)) {
                int broj = Document.getNextNumber(3, pos.getPointOfSaleID(), controller);
                ps.setInt(4, broj);
            } else if (controller.getCurrentBill().getPaymentMethod().getCode().equals("OTP")) {
                long broj = DocumentType.getByCode("OT", controller.getSettings().getConnection()).getDocumentTypeID();
                ps.setInt(4, Document.getNextNumber((int)broj, pos.getPointOfSaleID(), controller));
            } else if (bill.getPaymentMethod().getCode().equals("PROF")) {
                ps.setInt(4, Document.getNextNumber(20, pos.getPointOfSaleID(), controller));
            } else if (bill.getPaymentMethod().getCode().equals("AVANS") && bill.getPaymentMethod().getRefBrojAvans() != null && bill.getPaymentMethod().getRefBrojAvans().booleanValue() && !"konacniracun".equals(avanstin)) {
                int broj = Document.getNextNumber(36, pos.getPointOfSaleID(), controller);
                System.out.println("Ref broj avansa number true" + broj + " ," + bill.getPaymentMethod().getRefBrojAvans());
                ps.setInt(4, broj - 1);
                bill.getPaymentMethod().setRefBrojAvans(null);
            } else if (bill.getPaymentMethod().getCode().equals("AVANS") && !"konacniracun".equals(avanstin)) {
                int broj = Document.getNextNumber(36, pos.getPointOfSaleID(), controller);
                System.out.println("Ref broj avansa number false" + broj + " ," + bill.getPaymentMethod().getRefBrojAvans());
                ps.setInt(4, broj);
                bill.getPaymentMethod().setRefBrojAvans(null);
            } else {
                ps.setInt(4, rucnoPisani ? Document.getNextNumber(18, pos.getPointOfSaleID(), controller) : (controller.getCurrentBill().getPaymentMethod().getCode().equals("PROF") ? Document.getNextNumber(20, pos.getPointOfSaleID(), controller) : Document.getNextNumber(3, pos.getPointOfSaleID(), controller)));
            }
            bill.getPaymentMethod().setRefBrojAvans(null);
        }
        catch (IndexOutOfBoundsException e) {
            LOGGER.severe(e.getMessage());
            if (controller.getBillList().get(0).getPaymentMethod().getCode().equals("OTP")) {
                ps.setInt(1, DocumentType.getByCode("OT", controller.getSettings().getConnection()).getDocumentTypeID());
            } else {
                ps.setInt(1, rucnoPisani ? DocumentType.getByCode("RPR", controller.getSettings().getConnection()).getDocumentTypeID() : (controller.getBillList().get(0).getPaymentMethod().getCode().equals("PROF") ? DocumentType.getByCode("PROF", controller.getSettings().getConnection()).getDocumentTypeID() : DocumentType.getByCode("R", controller.getSettings().getConnection()).getDocumentTypeID()));
            }
            ps.setInt(2, 1);
            ps.setLong(3, pos.getPointOfSaleID());
            if (controller.getBillList().get(0).getPaymentMethod().getCode().equals("OTP")) {
                ps.setInt(4, Document.getNextNumber(DocumentType.getByCode("OT", controller.getSettings().getConnection()).getDocumentTypeID(), pos.getPointOfSaleID(), controller));
            }
            ps.setInt(4, rucnoPisani ? Document.getNextNumber(DocumentType.getByCode("RPR", controller.getSettings().getConnection()).getDocumentTypeID(), pos.getPointOfSaleID(), controller) : (controller.getBillList().get(0).getPaymentMethod().getCode().equals("PROF") ? (Document.getNextNumber(DocumentType.getByCode("PROF", controller.getSettings().getConnection()).getDocumentTypeID(), pos.getPointOfSaleID(), controller) == 1 ? DocumentType.getByCode(controller.getBillList().get(0).getPaymentMethod().getCode(), controller.getSettings().getConnection()).getFirstNumber() : Document.getNextNumber(DocumentType.getByCode("PROF", controller.getSettings().getConnection()).getDocumentTypeID(), pos.getPointOfSaleID(), controller)) : Document.getNextNumber(DocumentType.getByCode("R", controller.getSettings().getConnection()).getDocumentTypeID(), pos.getPointOfSaleID(), controller)));
        }
        ps.setString(5, bi);
        ps.setString(6, response != null ? response.getInvoiceNumber() : null);
        if (bill.getCashBuyer() != null) {
            ps.setNull(7, 1);
        } else {
            ps.setNull(7, 1);
        }
        ps.setString(8, FiscalPrinter.getIBFM(controller.getSettings().getFiscalFolder()));
        ps.setInt(9, Year.now().getValue());
        try {
            ps.setLong(10, bill.getPerson().getPersonID());
        }
        catch (NullPointerException e) {
            LOGGER.severe(e.getMessage());
            ps.setNull(10, -5);
        }
        try {
            ps.setLong(11, bill.getCashBuyer().getCashBuyerID());
        }
        catch (NullPointerException e) {
            LOGGER.severe(e.getMessage());
            ps.setNull(11, -5);
        }
        ps.setInt(12, bill.getPaymetnMethodID());
        if (bill.LoyalityID != 0L) {
            ps.setLong(13, bill.LoyalityID);
        } else {
            ps.setNull(13, -5);
        }
        ps.setDouble(14, bill.getDiscountBillPercent());
        ps.setDouble(15, bill.getSumWithDiscout());
        ps.setDouble(16, bill.getFinalSumWithDiscout());
        if (bill.getPaid() < bill.getSumWithDiscout() - bill.getDiscountBillPercent() / 100.0 * bill.getSumWithDiscout()) {
            ps.setDouble(17, bill.getFinalSumWithDiscout());
        } else {
            ps.setDouble(17, bill.getPaymentMethod().getCode().equals("F") || bill.getPaymentMethod().getCode().equals("PROF") || bill.getPaymentMethod().getCode().equals("CARD") || bill.getPaymentMethod().getCode().equals("CHECK") || stampaGotovinskog ? Settings.round(bill.getSumWithDiscout() - bill.getDiscountBillPercent() / 100.0 * bill.getSumWithDiscout(), 4) : bill.getPaid());
        }
        ps.setBoolean(18, false);
        ps.setLong(19, pos.getPointOfSaleID());
        ps.setLong(20, controller.getUser().getUserID());
        ps.setString(21, Address.getByID(controller.getObject().getAddressID(), controller.getSettings().getConnection()).getCity());
        ps.setString(22, bill.getNapomena());
        if (bill.getNapomena2() != null) {
            ps.setString(23, bill.getNapomena2());
        } else {
            ps.setString(23, "");
        }
        if (response == null) {
            ps.setString(24, "");
        } else {
            ps.setString(24, response.getSdcDateTime());
        }
        if (body == null) {
            ps.setString(25, "");
        } else {
            String buyerId = body.getBuyerId() == null ? "" : body.getBuyerId();
            ps.setString(25, buyerId);
        }
        if (bill.invoiceId != null && bill.salesInvoiceId != null && bill.purchaseInvoiceId != null) {
            ps.setLong(26, bill.invoiceId);
            ps.setLong(27, bill.salesInvoiceId);
            ps.setLong(28, bill.purchaseInvoiceId);
        } else {
            ps.setLong(26, 0L);
            ps.setLong(27, 0L);
            ps.setLong(28, 0L);
        }
        ps.executeUpdate();
        LOGGER.info(ps.toString());
        ResultSet rs = ps.getGeneratedKeys();
        rs.next();
        Long documnetId = rs.getLong(1);
        String query2 = "insert into documentdetails( \t`DocumentID`, \t`ProductID`, `ProductName`, \t`ParentProductID`, \t`Quantity`, \t`VatID`, \t`UnitID`, \t`Price`,\t`Discount`,\t`PriceWithDiscount`,\t`sysUserAddID`,\t`SaleTableID`,\t`OrderNumber`,\t`SubTotal`,\t`Closed`,\t`DescriptionID`)\tvalues(?,?,?,?,?,?,?,?,?,?,?, null, 1, false, false,?)";
        ps = controller.getSettings().getConnection().prepareStatement(query2, 1);
        for (int i = 0; i < bill.getRoundList().size(); ++i) {
            Round round = bill.getRoundList().get(i);
            for (RoundItem roundItem : round.getItemList()) {
                ps.setLong(1, documnetId);
                ps.setLong(2, roundItem.getProductDepartment().getProduct().getProductID());
                ps.setString(3, roundItem.getProductDepartment().getProduct().getName());
                ps.setNull(4, -5);
                ps.setDouble(5, roundItem.getQuantity());
                ps.setInt(6, roundItem.getProductDepartment().getProduct().getVatID());
                ps.setInt(7, roundItem.getProductDepartment().getProduct().getUnitID());
                ps.setDouble(8, roundItem.getProductDepartment().getProduct().getPrice());
                ps.setDouble(9, roundItem.getProductDepartment().getProduct().getDiscount());
                ps.setDouble(10, Bill.roundOnTwo(roundItem.getProductDepartment().getProduct().getPrice() - roundItem.getProductDepartment().getProduct().getPrice() * roundItem.getProductDepartment().getProduct().getDiscount() / 100.0));
                ps.setLong(11, controller.getUser().getUserID());
                Description description = roundItem.getDescription();
                if (description != null) {
                    int dscriptionId = description.insertDescriptionIntoDB();
                    ps.setInt(12, dscriptionId);
                } else {
                    ps.setObject(12, null);
                }
                ps.executeUpdate();
                rs = ps.getGeneratedKeys();
                rs.next();
                Long itemIndex = rs.getLong(1);
                for (RoundItem rio : roundItem.getAdditionalList()) {
                    DocumentDetails da = new DocumentDetails();
                    da.setDocumentID(documnetId);
                    da.setProductID(rio.getProductDepartment().getProduct().getProductID());
                    da.setParentDocumentDetailsID(itemIndex);
                    da.setQuantity(rio.getQuantity());
                    da.setVatID(rio.getProductDepartment().getProduct().getVatID());
                    da.setUnitID(rio.getProductDepartment().getProduct().getUnitID());
                    da.setPriceWithDiscount(rio.getProductDepartment().getProduct().getPrice() * (1.0 - rio.getProductDepartment().getProduct().getDiscount() / 100.0));
                    da.setDiscount(rio.getProductDepartment().getProduct().getDiscount());
                    da.setPrice(rio.getProductDepartment().getProduct().getPrice());
                    da.setSysUserAddID(controller.getUser().getUserID());
                    da.insert(controller.getSettings().getConnection());
                }
                String upitD = "insert into documentdetailsdescription (DocumentDetailsID,DescritptionID) values(?,?)";
                PreparedStatement psd = controller.getSettings().getConnection().prepareStatement(upitD);
                for (RoundItemDescription rid : roundItem.getDescriptionalList()) {
                    psd.setLong(1, itemIndex);
                    psd.setLong(2, rid.getDescription().getDescriptionID());
                    psd.executeUpdate();
                }
            }
            Document reservationDocument = controller.getReservationDocument();
            if (reservationDocument == null) continue;
            DocumentRelationship drs = new DocumentRelationship();
            drs.setRelationshipTypeID(RelationshipType.getByName(controller, "Racun - Rezervacija").getRelationshipTypeID());
            drs.setDocumentParentID(reservationDocument.getDocumentID());
            drs.setDocumentChildID(documnetId);
            drs.setActive(true);
            drs.setSysDTCreated(new Date());
            drs.setSysUserAddID(controller.getUser().getUserID());
            drs.insert(controller.getSettings().getConnection());
        }
        ps.setLong(1, documnetId);
        rs.close();
        ps.close();
        return documnetId;
    }

    public static void billcancellation(List<OfferPriceDetailes> offerPriceDetaileses, Connection connection) {
        String query = "INSERT INTO billcancellation \n (nameProduct, code, quantity, discount, price, datetimesys) \n VALUES( ?, ?, ?, ?, ?, ?);";
        try {
            Date utilDate = new Date();
            Time sqlTime = new Time(utilDate.getTime());
            PreparedStatement ps = connection.prepareStatement(query);
            for (OfferPriceDetailes opd : offerPriceDetaileses) {
                ps.setString(1, opd.getProduct().getName());
                ps.setString(2, opd.getProduct().getCode());
                ps.setDouble(3, opd.getQuantity());
                ps.setDouble(4, opd.getDiscount());
                ps.setDouble(5, opd.getPrice());
                Timestamp sqlTS = new Timestamp(utilDate.getTime());
                ps.setTimestamp(6, sqlTS);
                ps.executeUpdate();
            }
            ps.close();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    public Round getLastRound() {
        return this.roundList.get(this.roundList.size() - 1);
    }

    public double getFinalSumWithDiscout() {
        double sum = 0.0;
        for (Round r : this.roundList) {
            sum += r.getFinalSumWithDiscount();
        }
        return sum;
    }

    private static double roundOnTwo(double sum1) {
        double sum = (double)Math.round(sum1 * 1000.0) / 1000.0;
        sum = (double)Math.round(sum * 100.0) / 100.0;
        return sum;
    }
}

