/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice.fiscal;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.util.Callback;
import javafx.util.StringConverter;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.OfferPriceDetailes;
import rs.petcom.master.dal.PointOfSale;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.newFiscalization.print.JasperStarter;

public class PregledStornoController
implements ControlledScreen {
    ScreensController controller;
    @FXML
    private BorderPane rootPane;
    @FXML
    private DatePicker dateFrom;
    @FXML
    private DatePicker dateTo;
    @FXML
    private ComboBox<PointOfSale> cbPos;
    @FXML
    private BorderPane reportPane;
    @FXML
    private Button idPrint;
    @FXML
    private Button idDelete;
    @FXML
    private Label lblValue;
    @FXML
    TableView<OfferPriceDetailes> reciptTable;
    @FXML
    TableColumn<OfferPriceDetailes, String> colName;
    @FXML
    TableColumn<OfferPriceDetailes, String> colCode;
    @FXML
    TableColumn<OfferPriceDetailes, Double> colQuantity;
    @FXML
    TableColumn<OfferPriceDetailes, Double> colPrice;
    @FXML
    TableColumn<OfferPriceDetailes, String> colVreme;
    StringConverter<LocalDate> converter = new StringConverter<LocalDate>(){
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("dd.MM.yyyy");

        public String toString(LocalDate date) {
            if (date != null) {
                return this.dateFormatter.format(date);
            }
            return "";
        }

        public LocalDate fromString(String string) {
            if (string != null && !string.isEmpty()) {
                return LocalDate.parse(string, this.dateFormatter);
            }
            return null;
        }
    };

    @Override
    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    @Override
    public void setParameter(Object parameter) {
    }

    @Override
    public Object getParameter() {
        return null;
    }

    @Override
    public void init() {
        if (this.controller.getVrstaPrograma() == 4) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/master/css/trgovina/tableTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/master/css/trgovina/backofficeTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/master/css/trgovina/tabpaneTrgovina.css");
        }
        this.dateFrom.setConverter(this.converter);
        this.dateFrom.setValue((Object)LocalDate.now());
        this.colName.setCellValueFactory((Callback)new PropertyValueFactory("nameProduct"));
        this.colCode.setCellValueFactory((Callback)new PropertyValueFactory("code"));
        this.colVreme.setCellValueFactory((Callback)new PropertyValueFactory("vreme"));
        this.colQuantity.setCellValueFactory((Callback)new PropertyValueFactory("quantity"));
        this.colPrice.setCellValueFactory((Callback)new PropertyValueFactory("Price"));
        this.colPrice.setCellFactory(column -> new TableCell<OfferPriceDetailes, Double>(){

            protected void updateItem(Double item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Settings.getNumberFormat(2, true).format(item));
                }
            }
        });
        this.popuniOfferPriceDetailes();
    }

    @FXML
    private void dateFromChange() {
        this.popuniOfferPriceDetailes();
    }

    private void popuniOfferPriceDetailes() {
        ObservableList<OfferPriceDetailes> offerPriceDetailes = OfferPriceDetailes.getObeservableList(Settings.fromLocalDate((LocalDate)this.dateFrom.getValue()), this.controller.getSettings().getConnection(), false);
        this.reciptTable.setItems(offerPriceDetailes);
        if (!offerPriceDetailes.isEmpty() && offerPriceDetailes.size() != 0) {
            this.lblValue.setText("Ukupno :" + ((OfferPriceDetailes)offerPriceDetailes.get(0)).getSum());
        }
    }

    @FXML
    public void onPrint(ActionEvent actionEvent) {
        String reportFileName = "rs/petcom/backoffice/jasper/PregeledStorna.jasper";
        try {
            HashMap<String, Object> reportResources = new HashMap<String, Object>();
            ObservableList<OfferPriceDetailes> billPrints = OfferPriceDetailes.getObeservableList(Settings.fromLocalDate((LocalDate)this.dateFrom.getValue()), this.controller.getSettings().getConnection(), false);
            reportResources.put("datas", billPrints);
            reportResources.put("controller", this.controller);
            JasperStarter starter = new JasperStarter(reportResources, reportFileName, this.rootPane);
            starter.createReportCollectionDataSource(this.rootPane.getScene().getWindow());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @FXML
    public void onDelete(ActionEvent actionEvent) {
        this.lblValue.setText("Ukupno : 0.0");
        OfferPriceDetailes.deleteBiillCancilation(this.controller);
        this.reciptTable.getItems().clear();
        this.controller.alert("Obrisane stavke!", "Pregled storniranih artikala obrisan. \n", this.rootPane.getScene().getWindow());
    }

    public void onCheck(ActionEvent actionEvent) {
        ObservableList<OfferPriceDetailes> offerPriceDetailes = OfferPriceDetailes.getObeservableList(Settings.fromLocalDate((LocalDate)this.dateFrom.getValue()), this.controller.getSettings().getConnection(), true);
        this.reciptTable.setItems(offerPriceDetailes);
        if (!offerPriceDetailes.isEmpty() && offerPriceDetailes.size() != 0) {
            this.lblValue.setText("Ukupno :" + ((OfferPriceDetailes)offerPriceDetailes.get(0)).getSum());
        }
    }
}

