/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice;

import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.util.Callback;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Vat;
import rs.petcom.master.newFiscalization.status.LPFRStatus;
import rs.petcom.master.newFiscalization.tax.TaxRateSynchronization;
import rs.petcom.renameconnection.ChangeConnection;

public class VatConfigController
implements ControlledScreen {
    private ScreensController controller;
    private Vat selectedVat;
    private CheckBox checkBox;
    private ObservableList<Vat> selectedVatList = FXCollections.observableArrayList();
    @FXML
    private BorderPane rootPane;
    @FXML
    private Label title;
    @FXML
    private TableView<Vat> tblVatTable;
    @FXML
    private TableColumn<Vat, String> tcName;
    @FXML
    private TableColumn<Vat, String> tcValue1;
    @FXML
    private TableColumn<Vat, String> tcValue2;
    @FXML
    private TableColumn<Vat, String> tcValue3;
    @FXML
    private TableColumn<Vat, String> tcCode;
    @FXML
    private TableColumn<Vat, CheckBox> tcActive;
    private List<Vat> vats = new ArrayList<Vat>();

    @Override
    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    @Override
    public void init() {
        this.loadTable();
        if (this.controller.getVrstaPrograma() == 4) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/master/css/trgovina/tableTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/master/css/trgovina/backofficeTrgovina.css");
        }
    }

    @Override
    public void setParameter(Object parameter) {
    }

    @Override
    public Object getParameter() {
        return null;
    }

    public void initialize() {
        this.tcName.setCellValueFactory((Callback)new PropertyValueFactory("Name"));
        this.tcValue1.setCellValueFactory((Callback)new PropertyValueFactory("Value"));
        this.tcValue2.setCellValueFactory((Callback)new PropertyValueFactory("Value2"));
        this.tcValue3.setCellValueFactory((Callback)new PropertyValueFactory("Value3"));
        this.tcCode.setCellValueFactory((Callback)new PropertyValueFactory("Code"));
        this.tcActive.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<Vat, CheckBox>, ObservableValue<CheckBox>>(){

            public ObservableValue<CheckBox> call(TableColumn.CellDataFeatures<Vat, CheckBox> arg0) {
                VatConfigController.this.checkBox = new CheckBox();
                final Vat object = (Vat)arg0.getValue();
                if (object == null) {
                    return null;
                }
                VatConfigController.this.checkBox.selectedProperty().setValue(Boolean.valueOf(object.isActive()));
                VatConfigController.this.checkBox.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){
                    private ScreensController controller1;
                    {
                        this.controller1 = VatConfigController.this.controller;
                    }

                    public void changed(ObservableValue<? extends Boolean> ov, Boolean old_val, Boolean new_val) {
                        if (new_val.booleanValue()) {
                            VatConfigController.this.selectedVatList.add((Object)object);
                            object.setActive(true);
                            object.updateVat(object.getVatID(), this.controller1.getSettings().getConnection());
                        } else {
                            VatConfigController.this.selectedVatList.remove((Object)object);
                            object.setActive(false);
                            object.updateVat(object.getVatID(), this.controller1.getSettings().getConnection());
                        }
                    }
                });
                return new SimpleObjectProperty((Object)VatConfigController.this.checkBox);
            }
        });
        this.tblVatTable.getSelectionModel().selectedItemProperty().addListener((observableValue, oldValue, newValue) -> {
            this.selectedVat = newValue;
        });
    }

    @FXML
    private void deleteVat() {
        if (this.selectedVat == null) {
            String message = "Izaberite poresku stopu koju \u017eelite da obri\u0161ete";
            this.controller.alert("Upozorenje", message, this.rootPane.getScene().getWindow());
            return;
        }
        this.selectedVat.delete(this.selectedVat.getVatID(), this.controller.getSettings().getConnection());
        this.loadTable();
    }

    private void loadTable() {
        this.tblVatTable.setItems(Vat.getVatList(this.controller.getSettings().getConnection()));
    }

    @FXML
    void VatSynchronization(ActionEvent event) {
        LPFRStatus lpfrStatus = new LPFRStatus(this.controller);
        lpfrStatus.checkStatus(this.rootPane.getScene().getWindow());
        this.controller.getSettings().setConnection(ChangeConnection.getConnectionAdmin(this.controller));
        TaxRateSynchronization synchronization = new TaxRateSynchronization(this.controller, this.controller.getUser());
        synchronization.synchronizeRates(this.rootPane.getScene().getWindow());
        this.controller.getSettings().setConnection(ChangeConnection.getConnectionUser(this.controller));
        this.loadTable();
    }

    @FXML
    public void Update(ActionEvent actionEvent) {
        List<Vat> arrayList = this.vats;
        System.out.println("jfjkfjk");
    }
}

