/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice;

import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.util.Callback;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Unit;

public class UnitImportController
implements ControlledScreen {
    private ScreensController controller;
    private Unit selectedUnit;
    @FXML
    private BorderPane rootPane;
    @FXML
    private TextField tfName;
    @FXML
    private TextField tfCode;
    @FXML
    private TableView<Unit> tableUnit;
    @FXML
    private TableColumn<Unit, String> columnName;
    @FXML
    private TableColumn<Unit, String> columnCode;

    public void initialize() {
        this.tableUnit.getSelectionModel().getSelectedItems().addListener((ListChangeListener)new ListChangeListener<Unit>(){

            public void onChanged(ListChangeListener.Change<? extends Unit> c) {
                UnitImportController.this.selectedUnit = (Unit)UnitImportController.this.tableUnit.getSelectionModel().getSelectedItem();
                UnitImportController.this.fillTextField();
            }
        });
    }

    @Override
    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    @Override
    public void init() {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/master/css/trgovina/backofficeTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/master/css/trgovina/tableTrgovina.css");
        }
    }

    @Override
    public void setParameter(Object parameter) {
        this.fillTableUnit();
    }

    @Override
    public Object getParameter() {
        return null;
    }

    @FXML
    private void addUnit() {
        this.selectedUnit = null;
        if (this.validation()) {
            this.selectedUnit = new Unit();
            this.selectedUnit.setName(this.tfName.getText().trim());
            this.selectedUnit.setCode(this.tfCode.getText().trim());
            this.selectedUnit.insert(this.controller);
            this.fillTableUnit();
            this.clearTextField();
        }
        this.selectedUnit = null;
    }

    @FXML
    private void updateUnit() {
        if (this.selectedUnit != null && this.validation()) {
            this.selectedUnit.setName(this.tfName.getText().trim());
            this.selectedUnit.setCode(this.tfCode.getText().trim());
            this.selectedUnit.update(this.controller);
            this.fillTableUnit();
            this.clearTextField();
        }
        this.selectedUnit = null;
    }

    @FXML
    private void deleteUnit() {
        if (this.selectedUnit != null) {
            this.selectedUnit.delete(this.controller);
            this.fillTableUnit();
            this.clearTextField();
        } else {
            this.controller.alert("Obavestenje", "Sva polja moraju biti popunjena, pre unosa nove jedinice mere", this.rootPane.getScene().getWindow());
        }
        this.selectedUnit = null;
    }

    private void fillTableUnit() {
        ObservableList<Unit> unitList = Unit.getList(this.controller.getSettings().getConnection());
        this.columnName.setCellValueFactory((Callback)new PropertyValueFactory("Name"));
        this.columnCode.setCellValueFactory((Callback)new PropertyValueFactory("Code"));
        this.tableUnit.setItems(unitList);
    }

    private boolean validation() {
        boolean valid = false;
        if (!this.tfName.getText().trim().equals("") && !this.tfCode.getText().trim().equals("")) {
            valid = true;
        } else {
            this.controller.alert("Obavestenje", "Sva polja moraju biti popunjena, pre unosa nove jedinice mere", this.rootPane.getScene().getWindow());
        }
        return valid;
    }

    private void clearTextField() {
        this.tfName.setText("");
        this.tfCode.setText("");
    }

    private void fillTextField() {
        if (this.selectedUnit != null) {
            this.tfName.setText(this.selectedUnit.getName());
            this.tfCode.setText(this.selectedUnit.getCode());
        }
    }
}

