/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.Date;
import java.util.HashMap;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.StackPane;
import javafx.scene.text.TextAlignment;
import javafx.stage.Stage;
import javafx.util.Callback;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.WarehouseCentral;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.product.Product;
import rs.petcom.print.JRPrintPreviewPaneOld;

public class RobnaKarticaWarehouseDetaljiArtiklaController
implements DialogController {
    ScreensController controller;
    HashMap<String, Object> parameter;
    WarehouseCentral selectedWarehouse;
    int modalResult;
    Product product;
    java.util.Date dateOd;
    java.util.Date dateDo;
    @FXML
    BorderPane rootPane;
    @FXML
    private TableView<Document> robnaKarticaTable;
    @FXML
    private TableColumn<Document, String> datumColumnRK;
    @FXML
    private TableColumn<Document, String> nazivDokumentaColumnRK;
    @FXML
    private TableColumn<Document, Double> ulazColumnRK;
    @FXML
    private TableColumn<Document, Double> izlazColumnRK;
    @FXML
    private TableColumn<Document, Double> stanjeColumnRK;
    @FXML
    private TableColumn<Document, Double> nabavnaCenaColumnRK;
    @FXML
    private TableColumn<Document, Double> nabavnaVrednostColumnRK;
    @FXML
    private TableColumn<Document, Double> prodajnaCenaColumnRK;
    @FXML
    private TableColumn<Document, Double> prodajnaVrednostColumnRK;
    @FXML
    private ComboBox<WarehouseCentral> cbWarehouse;

    @FXML
    private void cancel(ActionEvent actionEvent) {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        Node source = (Node)actionEvent.getSource();
        Stage stage = (Stage)source.getScene().getWindow();
        stage.close();
    }

    @FXML
    private void print(ActionEvent actionEvent) {
        this.printJasper();
    }

    @Override
    public void setParameter(HashMap<String, Object> parameter) {
        this.parameter = parameter;
        this.controller = (ScreensController)parameter.get("controller");
        this.product = (Product)parameter.get("product");
        this.cbWarehouse.getItems().clear();
        for (WarehouseCentral warehouseCentral : WarehouseCentral.getList(this.controller)) {
            this.cbWarehouse.getItems().add((Object)warehouseCentral);
            if (this.cbWarehouse.getItems().isEmpty()) continue;
            this.cbWarehouse.getSelectionModel().select(0);
        }
        if (this.cbWarehouse.getItems().size() > 0) {
            this.cbWarehouse.getSelectionModel().selectFirst();
        }
        this.selectedWarehouse = (WarehouseCentral)this.cbWarehouse.getSelectionModel().getSelectedItem();
        if (this.product != null) {
            this.fillTable();
        }
        this.cbWarehouse.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<WarehouseCentral>(){

            public void changed(ObservableValue<? extends WarehouseCentral> observable, WarehouseCentral oldValue, WarehouseCentral newValue) {
                RobnaKarticaWarehouseDetaljiArtiklaController.this.selectedWarehouse = newValue;
                RobnaKarticaWarehouseDetaljiArtiklaController.this.fillTable();
            }
        });
    }

    @Override
    public HashMap<String, Object> getParameter() {
        return null;
    }

    @Override
    public int getModalResult() {
        return 0;
    }

    @Override
    public void setModalResult(int modalResult) {
    }

    private void fillTable() {
        try {
            this.dateOd = Document.Poslednji_popis_department_pre_datuma_v4(1, new java.util.Date(), this.controller.getSettings().getConnection());
            this.dateDo = Settings.fromLocalDate(Settings.fromDate(new java.util.Date()));
            this.robnaKarticaTable.setItems(Document.CALL_productCard_getWarehouse(this.product.getProductID(), new Date(this.dateOd.getTime()), new Date(this.dateDo.getTime()), this.selectedWarehouse.getWarehouseId(), this.controller.getSettings().getConnection()));
            this.datumColumnRK.setCellValueFactory((Callback)new PropertyValueFactory("Date"));
            this.makeHeaderWrappable(this.datumColumnRK);
            this.ulazColumnRK.setCellValueFactory((Callback)new PropertyValueFactory("Ulaz"));
            this.makeHeaderWrappable(this.ulazColumnRK);
            this.izlazColumnRK.setCellValueFactory((Callback)new PropertyValueFactory("Izlaz"));
            this.makeHeaderWrappable(this.izlazColumnRK);
            this.stanjeColumnRK.setCellValueFactory((Callback)new PropertyValueFactory("Stanje"));
            this.makeHeaderWrappable(this.stanjeColumnRK);
            this.nabavnaCenaColumnRK.setCellValueFactory((Callback)new PropertyValueFactory("NabavnaCena"));
            this.makeHeaderWrappable(this.nabavnaCenaColumnRK);
            this.nabavnaVrednostColumnRK.setCellValueFactory((Callback)new PropertyValueFactory("NabavnaVrednost"));
            this.makeHeaderWrappable(this.nabavnaVrednostColumnRK);
            this.prodajnaCenaColumnRK.setCellValueFactory((Callback)new PropertyValueFactory("ProdajnaCena"));
            this.makeHeaderWrappable(this.prodajnaCenaColumnRK);
            this.prodajnaVrednostColumnRK.setCellValueFactory((Callback)new PropertyValueFactory("ProdajnaVrednost"));
            this.makeHeaderWrappable(this.prodajnaVrednostColumnRK);
            this.nazivDokumentaColumnRK.setCellValueFactory((Callback)new PropertyValueFactory("NazivDokumenta"));
            this.makeHeaderWrappable(this.nazivDokumentaColumnRK);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }

    private void printJasper() {
        String reportFileName = "rs/petcom/backoffice/jasper/RobnaKaricaDetaljiArtikla.jasper";
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("productName", this.product.getName());
        hm.put("productID", this.product.getProductID());
        hm.put("warehouse", ((WarehouseCentral)this.cbWarehouse.getSelectionModel().getSelectedItem()).getWarehouseId());
        hm.put("dateOd", new Date(this.dateOd.getTime()));
        hm.put("dateDo", new Date(this.dateDo.getTime()));
        try {
            JasperReport report = (JasperReport)JRLoader.loadObject((InputStream)JRLoader.getResourceInputStream((String)reportFileName));
            JasperPrint jprint = JasperFillManager.fillReport((JasperReport)report, hm, (Connection)this.controller.getSettings().getConnection());
            JRPrintPreviewPaneOld printViewPane = new JRPrintPreviewPaneOld(jprint);
            HashMap<String, Object> hm2 = new HashMap<String, Object>();
            hm2.put("report", (Object)printViewPane);
            this.controller.showModalDialog("Robna kartica artikla", ScreensController.DIALOG_PRINT_PREVIEW, hm2, this.rootPane.getScene().getWindow());
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    private void makeHeaderWrappable(TableColumn<Document, ?> col) {
        Label label = new Label(col.getText());
        label.setWrapText(true);
        label.setAlignment(Pos.TOP_LEFT);
        label.setTextAlignment(TextAlignment.LEFT);
        StackPane stack = new StackPane();
        stack.getChildren().add((Object)label);
        stack.prefWidthProperty().bind((ObservableValue)col.widthProperty().subtract(1));
        label.prefWidthProperty().bind((ObservableValue)stack.prefWidthProperty());
        col.setGraphic((Node)stack);
    }
}

