/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.Date;
import java.util.HashMap;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.StackPane;
import javafx.scene.text.TextAlignment;
import javafx.stage.Stage;
import javafx.util.Callback;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.product.Product;
import rs.petcom.print.JRPrintPreviewPaneOld;

public class RobnaKarticaDetaljiArtiklaController
implements DialogController {
    ScreensController controller;
    HashMap<String, Object> parameter;
    Department selectedDepartment;
    int modalResult;
    Product product;
    java.util.Date dateOd;
    java.util.Date dateDo;
    @FXML
    BorderPane rootPane;
    @FXML
    private TableView<Document> robnaKarticaTable;
    @FXML
    private TableColumn<Document, String> datumColumnRK;
    @FXML
    private TableColumn<Document, String> nazivDokumentaColumnRK;
    @FXML
    private TableColumn<Document, Double> ulazColumnRK;
    @FXML
    private TableColumn<Document, Double> izlazColumnRK;
    @FXML
    private TableColumn<Document, Double> stanjeColumnRK;
    @FXML
    private TableColumn<Document, Double> nabavnaCenaColumnRK;
    @FXML
    private TableColumn<Document, Double> nabavnaVrednostColumnRK;
    @FXML
    private TableColumn<Document, Double> prodajnaCenaColumnRK;
    @FXML
    private TableColumn<Document, Double> prodajnaVrednostColumnRK;
    @FXML
    private ComboBox<Department> cbDepartment;
    @FXML
    private Label lblUlaz;
    @FXML
    private Label lblIzlaz;
    @FXML
    private Label lblStanje;

    @FXML
    private void cancel(ActionEvent actionEvent) {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        Node source = (Node)actionEvent.getSource();
        Stage stage = (Stage)source.getScene().getWindow();
        stage.close();
    }

    @FXML
    private void print(ActionEvent actionEvent) {
        this.printJasper();
    }

    @Override
    public void setParameter(HashMap<String, Object> parameter) {
        this.parameter = parameter;
        this.controller = (ScreensController)parameter.get("controller");
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/tableTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.product = (Product)parameter.get("product");
        this.selectedDepartment = (Department)parameter.get("department");
        this.dateDo = (java.util.Date)parameter.get("dateLagera");
        for (Department department : Department.getList(this.controller.getObject(), this.controller.getSettings().getConnection())) {
            this.cbDepartment.getItems().add((Object)department);
            if (this.selectedDepartment.getDepartmentID() != department.getDepartmentID()) continue;
            this.cbDepartment.getSelectionModel().select((Object)department);
        }
        if (this.product != null) {
            this.fillTable();
        }
        this.cbDepartment.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Department>(){

            public void changed(ObservableValue<? extends Department> observable, Department oldValue, Department newValue) {
                RobnaKarticaDetaljiArtiklaController.this.selectedDepartment = newValue;
                RobnaKarticaDetaljiArtiklaController.this.fillTable();
            }
        });
    }

    @Override
    public HashMap<String, Object> getParameter() {
        return null;
    }

    @Override
    public int getModalResult() {
        return 0;
    }

    @Override
    public void setModalResult(int modalResult) {
    }

    private void fillTable() {
        try {
            this.dateOd = Document.Poslednji_popis_department_pre_datuma_v5(1, new java.util.Date(), this.controller.getSettings().getConnection());
            this.robnaKarticaTable.setItems(Document.CALL_productCard_get(this.product.getProductID(), new Date(this.dateOd.getTime()), this.dateDo, this.selectedDepartment.getDepartmentID(), this.controller.getSettings().getConnection()));
            this.datumColumnRK.setCellValueFactory((Callback)new PropertyValueFactory("Date"));
            this.makeHeaderWrappable(this.datumColumnRK);
            this.ulazColumnRK.setCellValueFactory((Callback)new PropertyValueFactory("Ulaz"));
            this.makeHeaderWrappable(this.ulazColumnRK);
            this.izlazColumnRK.setCellValueFactory((Callback)new PropertyValueFactory("Izlaz"));
            this.makeHeaderWrappable(this.izlazColumnRK);
            this.stanjeColumnRK.setCellValueFactory((Callback)new PropertyValueFactory("Stanje"));
            this.makeHeaderWrappable(this.stanjeColumnRK);
            this.nabavnaCenaColumnRK.setCellValueFactory((Callback)new PropertyValueFactory("NabavnaCena"));
            this.makeHeaderWrappable(this.nabavnaCenaColumnRK);
            this.nabavnaVrednostColumnRK.setCellValueFactory((Callback)new PropertyValueFactory("NabavnaVrednost"));
            this.makeHeaderWrappable(this.nabavnaVrednostColumnRK);
            this.prodajnaCenaColumnRK.setCellValueFactory((Callback)new PropertyValueFactory("ProdajnaCena"));
            this.makeHeaderWrappable(this.prodajnaCenaColumnRK);
            this.prodajnaVrednostColumnRK.setCellValueFactory((Callback)new PropertyValueFactory("ProdajnaVrednost"));
            this.makeHeaderWrappable(this.prodajnaVrednostColumnRK);
            this.nazivDokumentaColumnRK.setCellValueFactory((Callback)new PropertyValueFactory("NazivDokumenta"));
            this.makeHeaderWrappable(this.nazivDokumentaColumnRK);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        this.ulazIzlazStanje();
    }

    private void printJasper() {
        String reportFileName = "rs/petcom/backoffice/jasper/RobnaKaricaDetaljiArtikla.jasper";
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("productName", this.product.getName());
        hm.put("productID", this.product.getProductID());
        hm.put("department", ((Department)this.cbDepartment.getSelectionModel().getSelectedItem()).getDepartmentID());
        hm.put("dateOd", new Date(this.dateOd.getTime()));
        hm.put("dateDo", new Date(this.dateDo.getTime()));
        try {
            JasperReport report = (JasperReport)JRLoader.loadObject((InputStream)JRLoader.getResourceInputStream((String)reportFileName));
            JasperPrint jprint = JasperFillManager.fillReport((JasperReport)report, hm, (Connection)this.controller.getSettings().getConnection());
            JRPrintPreviewPaneOld printViewPane = new JRPrintPreviewPaneOld(jprint);
            HashMap<String, Object> hm2 = new HashMap<String, Object>();
            hm2.put("report", (Object)printViewPane);
            this.controller.showModalDialog("Robna kartica artikla", ScreensController.DIALOG_PRINT_PREVIEW, hm2, this.rootPane.getScene().getWindow());
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    private void makeHeaderWrappable(TableColumn<Document, ?> col) {
        Label label = new Label(col.getText());
        label.setWrapText(true);
        label.setAlignment(Pos.TOP_LEFT);
        label.setTextAlignment(TextAlignment.LEFT);
        StackPane stack = new StackPane();
        stack.getChildren().add((Object)label);
        stack.prefWidthProperty().bind((ObservableValue)col.widthProperty().subtract(1));
        label.prefWidthProperty().bind((ObservableValue)stack.prefWidthProperty());
        col.setGraphic((Node)stack);
    }

    private void ulazIzlazStanje() {
        double ulaz = 0.0;
        double izlaz = 0.0;
        double stanje = 0.0;
        for (Document document : this.robnaKarticaTable.getItems()) {
            ulaz += document.getUlaz();
            izlaz += document.getIzlaz();
        }
        stanje = ulaz - izlaz;
        this.lblUlaz.setText(String.valueOf(ulaz));
        this.lblIzlaz.setText(String.valueOf(izlaz));
        this.lblStanje.setText(String.valueOf(stanje));
    }
}

