/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice;

import java.util.HashMap;
import javafx.beans.property.adapter.JavaBeanStringPropertyBuilder;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;
import javafx.util.Callback;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.controller.trgovina.Barcode;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.product.Product;

public class ProductSelectDialogController
implements DialogController {
    int modalResult = ScreensController.MODAL_RESULT_CANCEL;
    HashMap<String, Object> parameters;
    ScreensController controller;
    @FXML
    BorderPane rootPane;
    @FXML
    private GridPane gpCena;
    @FXML
    TableView<Product> table;
    @FXML
    TableColumn<Product, String> tcCode;
    @FXML
    TableColumn<Product, String> tcBarCode;
    @FXML
    TableColumn<Product, String> tcName;
    @FXML
    TextField tfFilter;
    @FXML
    TextField tfCena;

    public void initialize() {
        this.table.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode().equals((Object)KeyCode.ENTER) && ProductSelectDialogController.this.table.getSelectionModel().getSelectedItem() != null) {
                    ProductSelectDialogController.this.confirm();
                }
            }
        });
        this.tcCode.setCellValueFactory((Callback)new PropertyValueFactory("Code"));
        this.tcName.setCellValueFactory((Callback)new PropertyValueFactory("Name"));
        this.tcBarCode.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<Product, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<Product, String> param) {
                try {
                    return new JavaBeanStringPropertyBuilder().bean((Object)Barcode.getBarCodeObject(((Product)param.getValue()).getProductID(), ProductSelectDialogController.this.controller.getSettings().getConnection())).name("BarCode").build();
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    return null;
                }
            }
        });
        this.tfFilter.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                ProductSelectDialogController.this.populateTable();
            }
        });
    }

    @Override
    public void setParameter(HashMap<String, Object> parameter) {
        this.parameters = parameter;
        this.controller = (ScreensController)parameter.get("controller");
        this.table.requestFocus();
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.tfFilter.setText("");
        if (parameter.get("priceField") != null && ((Boolean)parameter.get("priceField")).booleanValue()) {
            this.gpCena.setVisible(true);
        }
        this.populateTable();
        this.tfFilter.requestFocus();
    }

    public HashMap<String, Object> getParameters() {
        return this.parameters;
    }

    @FXML
    private void cancel(ActionEvent actionEvent) {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    @FXML
    private void confirm() {
        this.modalResult = ScreensController.MODAL_RESULT_OK;
        this.parameters.put("product", this.table.getSelectionModel().getSelectedItem());
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    private void populateTable() {
        String sVrstaDokumenta = "";
        try {
            sVrstaDokumenta = this.parameters.get("vrstaDokumenta").toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!sVrstaDokumenta.equals("")) {
            this.table.setItems(Product.getAddListZaVrstuDokumenta(sVrstaDokumenta, (Department)this.parameters.get("department"), this.tfFilter.getText(), this.controller.getSettings().getConnection()));
        } else {
            this.table.setItems(Product.getAddList((Department)this.parameters.get("department"), this.tfFilter.getText(), this.controller.getSettings().getConnection()));
        }
        if (this.table.getItems().size() > 0) {
            this.table.getSelectionModel().select(0);
        }
    }

    @FXML
    private void mouseClick(MouseEvent event) {
        if (event.getClickCount() == 2) {
            this.modalResult = ScreensController.MODAL_RESULT_OK;
            this.parameters.put("product", this.table.getSelectionModel().getSelectedItem());
            Node source = (Node)event.getSource();
            Stage stage = (Stage)source.getScene().getWindow();
            stage.close();
        }
    }

    @Override
    public HashMap<String, Object> getParameter() {
        return this.parameters;
    }

    @Override
    public int getModalResult() {
        return this.modalResult;
    }

    @Override
    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }
}

