/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice;

import java.util.HashMap;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.util.Callback;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Printer;
import rs.petcom.master.dal.product.Product;

public class PrinterSelectDialogController
implements DialogController {
    ScreensController controller;
    HashMap<String, Object> parameters;
    Product product;
    int modalResult = ScreensController.MODAL_RESULT_CANCEL;
    ObservableList<Product> productList = FXCollections.observableArrayList();
    ObservableList<Printer> printerList = FXCollections.observableArrayList();
    ObservableList<Printer> printerProductList = FXCollections.observableArrayList();
    @FXML
    BorderPane rootPane;
    @FXML
    TableView<Printer> table;
    @FXML
    TableColumn<Printer, Long> tcID;
    @FXML
    TableColumn<Printer, String> tcName;
    @FXML
    TextField tfFilter;

    public void initialize() {
        this.tfFilter.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                PrinterSelectDialogController.this.populateTable();
            }
        });
    }

    @Override
    public void setParameter(HashMap<String, Object> parameters) {
        this.parameters = parameters;
        this.product = (Product)parameters.get("product");
        this.controller = (ScreensController)parameters.get("controller");
        this.tfFilter.setText("");
        this.tfFilter.requestFocus();
        this.populateTable();
    }

    @Override
    public HashMap<String, Object> getParameter() {
        return this.parameters;
    }

    private void populateTable() {
        this.printerList = Printer.getAllActivePrinter(this.controller.getSettings().getConnection());
        this.printerProductList = Printer.getProductToPrinter(this.product.getProductID(), this.controller.getSettings().getConnection());
        this.tcID.setCellValueFactory((Callback)new PropertyValueFactory("PrinterID"));
        this.tcName.setCellValueFactory((Callback)new PropertyValueFactory("Name"));
        this.table.setItems(this.printerList);
        if (this.table.getItems().size() > 0) {
            this.table.getSelectionModel().select(0);
        }
    }

    @FXML
    private void cancel(ActionEvent actionEvent) {
        this.setModalResult(ScreensController.MODAL_RESULT_CANCEL);
        Node source = (Node)actionEvent.getSource();
        Stage stage = (Stage)source.getScene().getWindow();
        stage.close();
    }

    @FXML
    private void confirm(ActionEvent actionEvent) {
        if (!this.printerProductList.isEmpty()) {
            for (int i = 0; i < this.printerProductList.size(); ++i) {
                if (((Printer)this.table.getSelectionModel().getSelectedItem()).getPrinterID() != ((Printer)this.printerProductList.get(i)).getPrinterID()) {
                    this.parameters.put("printer", this.table.getSelectionModel().getSelectedItem());
                    ((Stage)((Node)actionEvent.getSource()).getScene().getWindow()).close();
                    continue;
                }
                this.controller.alert("Obavestenje", "Odabrani \u0160TAMPA\u010c vec postoji za taj artikal", this.rootPane.getScene().getWindow());
            }
        } else {
            this.parameters.put("printer", this.table.getSelectionModel().getSelectedItem());
            ((Stage)((Node)actionEvent.getSource()).getScene().getWindow()).close();
        }
    }

    @FXML
    private void mouseClick(MouseEvent event) {
        if (event.getClickCount() == 2) {
            this.setModalResult(0);
            if (!this.printerProductList.isEmpty()) {
                for (int i = 0; i < this.printerProductList.size(); ++i) {
                    if (((Printer)this.table.getSelectionModel().getSelectedItem()).getPrinterID() != ((Printer)this.printerProductList.get(i)).getPrinterID()) {
                        this.parameters.put("printer", this.table.getSelectionModel().getSelectedItem());
                        ((Stage)((Node)event.getSource()).getScene().getWindow()).close();
                        continue;
                    }
                    this.controller.alert("Obavestenje", "Odabrani \u0160TAMPA\u010c vec postoji za taj artikal", this.rootPane.getScene().getWindow());
                }
            } else {
                this.parameters.put("printer", this.table.getSelectionModel().getSelectedItem());
                ((Stage)((Node)event.getSource()).getScene().getWindow()).close();
            }
        }
    }

    @Override
    public int getModalResult() {
        return this.modalResult;
    }

    @Override
    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }
}

