/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice;

import java.util.HashMap;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.util.Callback;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.PriceList;

public class PricelistSelectDialogController
implements DialogController {
    int modalResult = ScreensController.MODAL_RESULT_CANCEL;
    HashMap<String, Object> parameters;
    ScreensController controller;
    PriceList pricelist;
    @FXML
    BorderPane rootPane;
    @FXML
    TableView<PriceList> table;
    @FXML
    TableColumn<PriceList, Long> tcId;
    @FXML
    TableColumn<PriceList, String> tcName;
    @FXML
    TextField tfFilter;

    public void initialize() {
        this.tcId.setCellValueFactory((Callback)new PropertyValueFactory("PriceListID"));
        this.tcName.setCellValueFactory((Callback)new PropertyValueFactory("Title"));
    }

    @Override
    public void setParameter(HashMap<String, Object> parameter) {
        this.parameters = parameter;
        this.controller = (ScreensController)parameter.get("controller");
        this.tfFilter.setText("");
        this.pricelist = (PriceList)parameter.get("pricelist");
        this.populateTable();
        this.tfFilter.requestFocus();
    }

    public HashMap<String, Object> getParameters() {
        return this.parameters;
    }

    @FXML
    private void cancel(ActionEvent actionEvent) {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        Node source = (Node)actionEvent.getSource();
        Stage stage = (Stage)source.getScene().getWindow();
        stage.close();
    }

    @FXML
    private void confirm(ActionEvent actionEvent) {
        this.modalResult = ScreensController.MODAL_RESULT_OK;
        this.parameters.put("pricelistID", this.table.getSelectionModel().getSelectedItem());
        Node source = (Node)actionEvent.getSource();
        Stage stage = (Stage)source.getScene().getWindow();
        stage.close();
    }

    private void populateTable() {
        for (PriceList pl : PriceList.getList(null, true, this.controller.getSettings().getConnection())) {
            if (pl.getPriceListID() == this.pricelist.getPriceListID()) continue;
            this.table.getItems().add((Object)pl);
        }
        if (this.table.getItems().size() > 0) {
            this.table.getSelectionModel().select(0);
        }
    }

    @FXML
    private void mouseClick(MouseEvent event) {
        if (event.getClickCount() == 2) {
            this.modalResult = ScreensController.MODAL_RESULT_OK;
            this.parameters.put("pricelistID", this.table.getSelectionModel().getSelectedItem());
            Node source = (Node)event.getSource();
            Stage stage = (Stage)source.getScene().getWindow();
            stage.close();
        }
    }

    @Override
    public HashMap<String, Object> getParameter() {
        return this.parameters;
    }

    @Override
    public int getModalResult() {
        return this.modalResult;
    }

    @Override
    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }
}

