/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice;

import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.fxml.FXML;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.stage.FileChooser;
import javafx.util.Callback;
import javax.swing.filechooser.FileSystemView;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.util.JRLoader;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.PriceList;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.Vat;
import rs.petcom.master.dal.product.Product;
import rs.petcom.master.dal.product.ProductCategory;
import rs.petcom.print.JRPrintPreviewPane;

public class PriceListPrintController
implements ControlledScreen {
    private ScreensController controller;
    String pathWithoutName = null;
    @FXML
    private BorderPane rootPane;
    @FXML
    private TextField tfFilter;
    @FXML
    private Label lblPriceList;
    @FXML
    private ComboBox<ProductCategory> cbProductCategory;
    @FXML
    private ComboBox<Vat> cbVat;
    @FXML
    private TableView<Product> tableProduct;
    @FXML
    private TableColumn<Product, String> columnProduct;
    @FXML
    private TableColumn<Product, String> columnPdv;
    @FXML
    private TableColumn<Product, String> columnCode;
    @FXML
    private TableColumn<Product, String> columnBarCode;
    @FXML
    private TableColumn<Product, String> columnType;
    @FXML
    private TableColumn<Product, Double> columnPrice;

    @Override
    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    @Override
    public void init() {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/tableTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
    }

    @Override
    public void setParameter(Object parameter) {
        this.lblPriceList.setText(PriceList.getActive(Settings.LocalDateTimefromDate(new Date()), this.controller.getObject().getObjectID(), this.controller.getSettings().getConnection()).getTitle());
        this.loadProductTypeComboBox();
        this.loadVatComboBox();
    }

    @Override
    public Object getParameter() {
        return null;
    }

    @FXML
    private void initialize() {
        this.tfFilter.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                PriceListPrintController.this.filter();
            }
        });
    }

    @FXML
    private void showAction() {
        this.loadProductTable();
    }

    @FXML
    private void printAction() {
        String reportFileName = "rs/petcom/backoffice/jasper/blagajna/PriceListPrint.jasper";
        ObservableList printingList = FXCollections.observableArrayList();
        for (Product product : this.tableProduct.getItems()) {
            if (product.getBarcode() == null) {
                product.setBarcode("Nema barkod");
            }
            printingList.add((Object)product);
        }
        JRBeanCollectionDataSource beanColDataSource = new JRBeanCollectionDataSource((Collection)printingList);
        HashMap<String, String> hm = new HashMap<String, String>();
        File file = new File(this.controller.getSettings().getSetting("company.memorandum", this.controller.getPointOfSale()));
        if (file.exists() && file.isFile()) {
            hm.put("memorandum", this.controller.getSettings().getSetting("company.memorandum", this.controller.getPointOfSale()));
        } else {
            hm.put("memorandum", "");
        }
        try {
            JasperReport report = (JasperReport)JRLoader.loadObject((InputStream)JRLoader.getResourceInputStream((String)reportFileName));
            JasperPrint jprint = JasperFillManager.fillReport((JasperReport)report, hm, (JRDataSource)beanColDataSource);
            JRPrintPreviewPane printViewPane = new JRPrintPreviewPane(jprint);
            HashMap<String, Object> hm2 = new HashMap<String, Object>();
            hm2.put("report", (Object)printViewPane);
            this.controller.showModalDialog("Povrat", ScreensController.DIALOG_PRINT_PREVIEW, hm2, this.rootPane.getScene().getWindow());
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    @FXML
    private void excelAction() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setInitialDirectory(FileSystemView.getFileSystemView().getHomeDirectory().getAbsoluteFile());
        fileChooser.setTitle(this.controller.getBundle().getString("selectFileForExport"));
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("XLS files (*.xls)", new String[]{"*.xlsx"}));
        File file = fileChooser.showSaveDialog(this.controller.getRoot().getScene().getWindow());
        if (fileChooser.getSelectedExtensionFilter() != null && fileChooser.getSelectedExtensionFilter().getExtensions() != null) {
            String filePath;
            List selectedExtension = fileChooser.getSelectedExtensionFilter().getExtensions();
            int extensionLength = 0;
            if (selectedExtension.contains("*.PDF") || selectedExtension.contains("*.CSV")) {
                extensionLength = 4;
            }
            if (selectedExtension.contains("*.XLSX") || selectedExtension.contains("*.DOCX")) {
                extensionLength = 5;
            }
            String nameWithoutExt = file.getName().substring(0, file.getName().length() - extensionLength);
            String pathWithoutExt = file.getAbsolutePath().substring(0, file.getAbsolutePath().length() - extensionLength);
            this.pathWithoutName = pathWithoutExt.substring(0, pathWithoutExt.lastIndexOf(nameWithoutExt) - 1);
            if (file != null && !(filePath = file.getAbsolutePath()).toUpperCase().endsWith(".CSV")) {
                filePath = filePath + ".xml";
            }
            Product.getPriceListToExcel(this.controller, (ObservableList<Product>)this.tableProduct.getItems(), this.pathWithoutName, file.getName());
            this.controller.printFileFromPDF(file);
        }
    }

    private void loadProductTypeComboBox() {
        ProductCategory productCategory = new ProductCategory();
        productCategory.setProductCategoryID(-1);
        productCategory.setName("Sve kategorije");
        this.cbProductCategory.getItems().add((Object)productCategory);
        this.cbProductCategory.getSelectionModel().select(0);
        for (ProductCategory pc : ProductCategory.getObeservableList(this.controller.getSettings().getConnection())) {
            this.cbProductCategory.getItems().add((Object)pc);
        }
    }

    private void loadVatComboBox() {
        Vat vat = new Vat();
        vat.setVatID(-1);
        vat.setName("Svi porezi");
        this.cbVat.getItems().add((Object)vat);
        this.cbVat.getSelectionModel().select(0);
        for (Vat v : Vat.getObeservableList(this.controller.getSettings().getConnection())) {
            this.cbVat.getItems().add((Object)v);
        }
    }

    private void loadProductTable() {
        this.tableProduct.getSelectionModel().clearSelection();
        this.tableProduct.getItems().clear();
        this.columnProduct.setCellValueFactory((Callback)new PropertyValueFactory("Name"));
        this.columnPrice.setCellValueFactory((Callback)new PropertyValueFactory("price"));
        this.columnPdv.setCellValueFactory((Callback)new PropertyValueFactory("VatName"));
        this.columnCode.setCellValueFactory((Callback)new PropertyValueFactory("Code"));
        this.columnBarCode.setCellValueFactory((Callback)new PropertyValueFactory("barcode"));
        this.columnType.setCellValueFactory((Callback)new PropertyValueFactory("categoryName"));
        this.tableProduct.setItems(Product.getProductPriceList(this.controller, this.tfFilter.getText().trim(), ((Vat)this.cbVat.getSelectionModel().getSelectedItem()).getVatID(), ((ProductCategory)this.cbProductCategory.getSelectionModel().getSelectedItem()).getProductCategoryID()));
    }

    private void filter() {
        if (!this.tableProduct.getItems().isEmpty()) {
            FilteredList filteredData = new FilteredList(this.tableProduct.getItems(), p -> true);
            this.tfFilter.textProperty().addListener((observable, oldValue, newValue) -> filteredData.setPredicate(opd -> {
                if (newValue == null || newValue.isEmpty()) {
                    return true;
                }
                String lowerCaseFilter = newValue.toLowerCase();
                if (opd.getCode().toLowerCase().contains(lowerCaseFilter)) {
                    return true;
                }
                if (opd.getBarcode().toLowerCase().contains(lowerCaseFilter)) {
                    return true;
                }
                if (opd.getName().contains(lowerCaseFilter)) {
                    return true;
                }
                return opd.getShortName().contains(lowerCaseFilter);
            }));
            SortedList sortedData = new SortedList((ObservableList)filteredData);
            sortedData.comparatorProperty().bind((ObservableValue)this.tableProduct.comparatorProperty());
            this.tableProduct.setItems((ObservableList)sortedData);
        } else {
            this.controller.alert("Obavestenje", "Prvo popunite tabelu da biste mogli da vrsite pretragu.", this.rootPane.getScene().getWindow());
        }
    }
}

