/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice;

import java.util.HashMap;
import javafx.beans.property.adapter.JavaBeanStringPropertyBuilder;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.PointOfSale;

public class PointOfSaleConfigControllerTrgovina
implements ControlledScreen {
    ScreensController controller;
    ObservableList<PointOfSale> posList;
    PointOfSale selectedPointOfSale;
    HashMap<String, Object> hMap;
    @FXML
    private BorderPane rootPane;
    @FXML
    private TableView<PointOfSale> tablePointOfSale;
    @FXML
    private TableColumn<PointOfSale, String> columnName;
    @FXML
    private TableColumn<PointOfSale, String> columnCode;
    @FXML
    private TableColumn<PointOfSale, String> columnDepartment;
    @FXML
    private TableColumn<PointOfSale, Boolean> columnActive;
    @FXML
    private ComboBox<Department> cbDepartment;

    @Override
    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    @Override
    public void init() {
        if (this.controller.getVrstaPrograma() == 4) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/master/css/trgovina/tableTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/master/css/trgovina/backofficeTrgovina.css");
        }
        Department svaOdaljenja = new Department();
        svaOdaljenja.setDepartmentID(-1);
        svaOdaljenja.setName("Sva odeljenja");
        this.cbDepartment.getItems().add((Object)svaOdaljenja);
        for (Department department : Department.getList(this.controller.getObject(), this.controller.getSettings().getConnection())) {
            this.cbDepartment.getItems().add((Object)department);
        }
        this.cbDepartment.getSelectionModel().select(0);
        this.loadTable();
    }

    public void initialize() {
        this.tablePointOfSale.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<PointOfSale>(){

            public void changed(ObservableValue<? extends PointOfSale> observable, PointOfSale oldValue, PointOfSale newValue) {
                PointOfSaleConfigControllerTrgovina.this.selectedPointOfSale = newValue;
            }
        });
        this.tablePointOfSale.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                if (event.getClickCount() == 2 && !row.isEmpty()) {
                    this.actionChange();
                }
            });
            return row;
        });
        this.cbDepartment.getSelectionModel().selectedItemProperty().addListener((options, oldValue, newValue) -> {
            if (newValue != null) {
                this.loadTable();
            }
        });
    }

    @Override
    public void setParameter(Object parameter) {
        this.hMap = (HashMap)parameter;
    }

    @Override
    public Object getParameter() {
        return null;
    }

    @FXML
    private void actionNew(ActionEvent event) {
        this.hMap.put("controller", this.controller);
        this.hMap.put("selectedPOS", null);
        this.controller.showModalDialog("Kreiranje novog objekta", ScreensController.DIALOG_ADD_POINT_OF_SALE, this.hMap, (Window)((Stage)((Node)event.getSource()).getScene().getWindow()));
        this.tablePointOfSale.getSelectionModel().clearSelection();
        this.loadTable();
    }

    @FXML
    private void actionChange() {
        if (this.selectedPointOfSale != null) {
            this.hMap.put("selectedPOS", this.selectedPointOfSale);
            this.hMap.put("controller", this.controller);
            this.controller.showModalDialog("Izmena prodajnog mesta", ScreensController.DIALOG_ADD_POINT_OF_SALE, this.hMap, this.rootPane.getScene().getWindow());
            this.selectedPointOfSale = (PointOfSale)this.hMap.get("selectedPOS");
        } else {
            this.controller.alert("Obavestenje", "Morate odabrati objekat iz tabele!", this.rootPane.getScene().getWindow());
        }
        this.loadTable();
    }

    @FXML
    private void actionDelete() {
        if (this.selectedPointOfSale != null) {
            this.selectedPointOfSale.deletePOSDepartment(this.controller);
            this.selectedPointOfSale.delete(this.controller);
        } else {
            this.controller.alert("Obavestenje", "Morate odabrati prodajno mesto iz tabele, koje zelite da obrisete!", this.rootPane.getScene().getWindow());
        }
        this.loadTable();
    }

    private void loadTable() {
        this.tablePointOfSale.getSelectionModel().clearSelection();
        this.posList = PointOfSale.getPOSList(((Department)this.cbDepartment.getSelectionModel().getSelectedItem()).getDepartmentID(), this.controller.getSettings().getConnection());
        this.columnName.setCellValueFactory((Callback)new PropertyValueFactory("Name"));
        this.columnCode.setCellValueFactory((Callback)new PropertyValueFactory("Code"));
        this.columnDepartment.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<PointOfSale, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<PointOfSale, String> param) {
                try {
                    return new JavaBeanStringPropertyBuilder().bean((Object)Department.getByPOS((PointOfSale)param.getValue(), PointOfSaleConfigControllerTrgovina.this.controller.getSettings().getConnection())).name("Name").build();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        });
        this.columnActive.setCellValueFactory((Callback)new PropertyValueFactory("Active"));
        this.columnActive.setCellFactory(column -> new TableCell<PointOfSale, Boolean>(){

            protected void updateItem(Boolean item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (!empty) {
                    if (item.booleanValue()) {
                        this.setText("Da");
                    } else {
                        this.setText("Ne");
                    }
                }
            }
        });
        this.tablePointOfSale.setItems(this.posList);
    }
}

