/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice;

import java.sql.Connection;
import java.sql.Date;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBox;
import javafx.scene.control.CheckBoxTreeItem;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.control.cell.CheckBoxTreeCell;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.IdCard;
import rs.petcom.master.dal.PointOfSale;
import rs.petcom.master.dal.PosMenu;
import rs.petcom.master.dal.Role;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.User;
import rs.petcom.renameconnection.ChangeConnection;

public class PodesavanjeKorisnikaController
implements DialogController {
    private ScreensController controller;
    private Connection connection;
    private HashMap<String, Object> parameter;
    private int modalResult = ScreensController.MODAL_RESULT_CANCEL;
    private User user;
    private User selectedUser;
    private ObservableList<User> userList = FXCollections.observableArrayList();
    @FXML
    private BorderPane rootPane;
    @FXML
    private TreeView<PointOfSale> treeDepartment;
    @FXML
    private TreeView<PosMenu> treePosmenu;
    @FXML
    private TreeView<Role> treeRole;
    @FXML
    private Label lblUser;
    @FXML
    private TextField tfName;
    @FXML
    private TextField tfCardCode;
    @FXML
    private TextField tfPassword;
    @FXML
    private TextField tfLoginPassword;
    @FXML
    private CheckBox cbActive;
    @FXML
    private CheckBox cbTraining;
    @FXML
    private ComboBox<User> cbUsers;
    private List<CheckBoxTreeItem<PosMenu>> listCheckBoxPosMenu;
    private List<CheckBoxTreeItem<Role>> listCheckBoxRole;
    private List<CheckBoxTreeItem<PointOfSale>> listCheckBoxPointOfSale;
    private ObservableList<PosMenu> listPosMenuID;
    private List<PointOfSale> posListFromDb;
    private List<Role> listRoleID;
    private List<Role> listRole;
    private TreeItem<PointOfSale> treeRootPos;
    private boolean tMasterLight;

    public void initialize() {
    }

    @Override
    public void setParameter(HashMap<String, Object> parameter) {
        this.parameter = parameter;
        this.controller = (ScreensController)parameter.get("controller");
        this.connection = this.controller.getSettings().getConnection();
        this.tMasterLight = Boolean.parseBoolean(this.controller.getSettings().getActualByName("tmaster.light"));
        if (this.parameter.get("user") != null) {
            this.user = (User)this.parameter.get("user");
            this.tfName.setText(this.user.getUserName());
            this.tfCardCode.setText(this.user.getIdCard() == null ? "" : this.user.getIdCard().getCode());
            this.tfPassword.setText(this.user.getPassword());
            this.cbActive.setSelected(this.user.isActive());
            this.fillRoleTable();
            this.fillPOSTreeViewForNewUser();
        } else {
            this.fillRoleTableForNewUser();
        }
        this.fillPOSTreeViewForNewUser();
        this.fillPosMenuTreeView();
        this.userList = User.getUserList(this.connection);
        this.cbUsers.setItems(this.userList);
    }

    @Override
    public HashMap<String, Object> getParameter() {
        return this.parameter;
    }

    @Override
    public int getModalResult() {
        return this.modalResult;
    }

    @Override
    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }

    @FXML
    public void cancel(ActionEvent event) {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    @FXML
    private void commit() {
        this.connection = ChangeConnection.getConnectionAdmin(this.controller);
        User u = (User)this.parameter.get("user");
        if (u != null) {
            if (this.selectedUser != null) {
                this.clearAll();
            }
            if (!u.getUserName().equals(this.tfName.getText().trim()) || !u.getPassword().equals(this.tfPassword.getText().trim()) || u.isActive() || this.cbActive.isSelected()) {
                u.updateUser(this.connection, this.tfName.getText().trim(), this.tfPassword.getText().trim(), this.cbActive.isSelected(), u.getUserID());
            }
            if (this.user.getIdCard() == null && !this.tfCardCode.getText().isEmpty()) {
                IdCard.insertUserIdCard(u.getUserID(), this.tfCardCode.getText().trim(), this.connection);
            } else if (this.user.getIdCard() != null && !u.getIdCard().getCode().equals(this.tfCardCode.getText().trim())) {
                if (this.tfCardCode.getText().trim().isEmpty()) {
                    IdCard.deleteIdCardByUserId(u.getUserID(), this.connection);
                } else {
                    IdCard.updateCode(u.getUserID(), this.tfCardCode.getText().trim(), this.connection);
                }
            }
            this.insertDeleteUserPointOfSale();
            this.insetDeleteUserRole();
            this.insertDeleteUserPosMenu();
        } else {
            if (!this.validateInput()) {
                return;
            }
            this.user = new User();
            this.user.setUserName(this.tfName.getText().trim());
            this.user.setPassword(this.tfPassword.getText().trim());
            this.user.setActive(this.cbActive.isSelected());
            this.user.setSysDTCreated(new Date(Settings.DatefromLocalDateTime(LocalDateTime.now()).getTime()));
            long id = this.user.newUser(this.controller.getSettings().getConnection());
            IdCard.insertUserIdCard(id, this.tfPassword.getText().trim(), this.controller.getSettings().getConnection());
            for (CheckBoxTreeItem<PointOfSale> checkBoxTreeItem : this.listCheckBoxPointOfSale) {
                User.insertUserIntoUserPOS(id, ((PointOfSale)checkBoxTreeItem.getValue()).getPointOfSaleID(), checkBoxTreeItem.isSelected(), this.connection);
            }
            for (CheckBoxTreeItem checkBoxTreeItem : this.listCheckBoxRole) {
                if (!checkBoxTreeItem.isSelected()) continue;
                User.insertUserRole(id, ((Role)checkBoxTreeItem.getValue()).getRoleID(), this.connection);
            }
            for (CheckBoxTreeItem checkBoxTreeItem : this.listCheckBoxPosMenu) {
                if (!checkBoxTreeItem.isSelected()) continue;
                this.user.insertUserIntoPosMenu(id, ((PosMenu)checkBoxTreeItem.getValue()).getPosMenuID(), this.connection);
            }
        }
        this.parameter.put("user", this.user);
        this.modalResult = ScreensController.MODAL_RESULT_OK;
        ((Stage)this.rootPane.getScene().getWindow()).close();
        this.connection = ChangeConnection.getConnectionUser(this.controller);
    }

    @FXML
    private void onUserSelected() {
        this.selectedUser = (User)this.cbUsers.getSelectionModel().getSelectedItem();
        this.fillRoleTable();
        this.fillPosMenuTreeView();
    }

    private void clearAll() {
        User u = (User)this.parameter.get("user");
        this.posListFromDb = new ArrayList<PointOfSale>();
        u.deleteUserRoles(u.getUserID(), this.connection);
        this.listRoleID = new ArrayList<Role>();
        u.deleteAllUserPosMenu(u.getUserID(), this.connection);
        this.listPosMenuID = FXCollections.observableArrayList();
    }

    private boolean validateInput() {
        if (this.tfName.getText().trim().isEmpty()) {
            this.controller.alert("Obave\u0161tenje", "Morate uneti ime", this.rootPane.getScene().getWindow());
            return false;
        }
        if (this.tfCardCode.getText().trim().isEmpty()) {
            this.controller.alert("Obave\u0161tenje", "Morate uneti kod kartice", this.rootPane.getScene().getWindow());
            return false;
        }
        if (this.tfPassword.getText().trim().isEmpty()) {
            this.controller.alert("Obave\u0161tenje", "Morate uneti \u0161ifru", this.rootPane.getScene().getWindow());
            return false;
        }
        return true;
    }

    private void fillPOSTreeViewForNewUser() {
        this.listCheckBoxPointOfSale = new ArrayList<CheckBoxTreeItem<PointOfSale>>();
        User u = this.selectedUser != null ? this.selectedUser : (User)this.parameter.get("user");
        try {
            this.posListFromDb = User.getPointsOfSaleFromDb(u.getUserID(), this.connection);
        }
        catch (NullPointerException e) {
            this.posListFromDb = new ArrayList<PointOfSale>();
        }
        this.treeDepartment.setCellFactory(p -> new CheckBoxTreeCell<PointOfSale>(){

            public void updateItem(PointOfSale item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item != null) {
                    this.setText(item.getName());
                }
            }
        });
        this.treeDepartment.setShowRoot(false);
        this.treeRootPos = new TreeItem();
        for (rs.petcom.master.dal.Object o : rs.petcom.master.dal.Object.getList(this.controller.getSettings().getConnection())) {
            CheckBoxTreeItem pos = new CheckBoxTreeItem();
            pos.setValue((Object)new PointOfSale(o.getObjectID(), o.getName()));
            for (PointOfSale d : PointOfSale.getPosList(o, this.controller.getSettings().getConnection())) {
                CheckBoxTreeItem checkBoxTreeItem = new CheckBoxTreeItem();
                checkBoxTreeItem.setValue((Object)d);
                if (this.posListFromDb.contains(d)) {
                    checkBoxTreeItem.setSelected(true);
                }
                this.listCheckBoxPointOfSale.add((CheckBoxTreeItem<PointOfSale>)checkBoxTreeItem);
                pos.getChildren().add((Object)checkBoxTreeItem);
                pos.setExpanded(true);
            }
            this.treeRootPos.getChildren().add((Object)pos);
        }
        this.treeRootPos.setExpanded(false);
        this.treeDepartment.setRoot(this.treeRootPos);
    }

    private void insertDeleteUserPointOfSale() {
        ArrayList<Object> currentPOSSelectionList = new ArrayList<Object>();
        this.posListFromDb = User.getPointsOfSaleFromDb(((User)this.parameter.get("user")).getUserID(), this.connection);
        for (CheckBoxTreeItem<PointOfSale> ps : this.listCheckBoxPointOfSale) {
            if (ps.isSelected()) {
                ((PointOfSale)ps.getValue()).setActive(true);
                ((PointOfSale)ps.getValue()).setSelected(true);
            } else {
                ((PointOfSale)ps.getValue()).setActive(false);
                ((PointOfSale)ps.getValue()).setSelected(false);
            }
            currentPOSSelectionList.add(ps.getValue());
        }
        long userId = ((User)this.parameter.get("user")).getUserID();
        if (this.posListFromDb.size() < currentPOSSelectionList.size()) {
            Iterator it = currentPOSSelectionList.iterator();
            while (it.hasNext()) {
                PointOfSale pointOfSale = (PointOfSale)it.next();
                for (int i = 0; i < this.posListFromDb.size(); ++i) {
                    if (pointOfSale.getPointOfSaleID() != this.posListFromDb.get(i).getPointOfSaleID()) continue;
                    User.updateUserPos(userId, pointOfSale, this.connection);
                    it.remove();
                }
            }
            for (PointOfSale pointOfSale : currentPOSSelectionList) {
                User.insertUserIntoUserPOS(userId, pointOfSale.getPointOfSaleID(), pointOfSale.isActive(), this.connection);
            }
        } else {
            for (PointOfSale pointOfSale : currentPOSSelectionList) {
                User.updateUserPos(userId, pointOfSale, this.connection);
            }
        }
    }

    private void fillRoleTableForNewUser() {
        this.listCheckBoxRole = new ArrayList<CheckBoxTreeItem<Role>>();
        CheckBoxTreeItem roles = new CheckBoxTreeItem();
        Role r = new Role();
        r.setName("Izaberite privilegije...");
        roles.setValue((Object)r);
        roles.setExpanded(true);
        this.treeRole.setCellFactory(p -> new CheckBoxTreeCell<Role>(){

            public void updateItem(Role item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item != null) {
                    this.setText(item.getName());
                }
            }
        });
        this.listRole = Role.getRoleList(this.controller.getSettings().getConnection());
        for (Role role : this.listRole) {
            CheckBoxTreeItem checkBoxTreeItem = new CheckBoxTreeItem();
            checkBoxTreeItem.setValue((Object)role);
            this.listCheckBoxRole.add((CheckBoxTreeItem<Role>)checkBoxTreeItem);
            roles.getChildren().add((Object)checkBoxTreeItem);
        }
        this.treeRole.setRoot((TreeItem)roles);
        this.treeRole.setShowRoot(true);
    }

    private void fillRoleTable() {
        this.listCheckBoxRole = new ArrayList<CheckBoxTreeItem<Role>>();
        CheckBoxTreeItem roles = new CheckBoxTreeItem();
        Role r = new Role();
        r.setName("Izaberite privilegije...");
        roles.setValue((Object)r);
        roles.setExpanded(true);
        this.treeRole.setCellFactory(p -> new CheckBoxTreeCell<Role>(){

            public void updateItem(Role item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item != null) {
                    this.setText(item.getName());
                }
            }
        });
        User u = this.selectedUser != null ? this.selectedUser : (User)this.parameter.get("user");
        this.listRole = this.tMasterLight ? Role.getRoleLightList(this.controller.getSettings().getConnection()) : Role.getRoleList(this.controller.getSettings().getConnection());
        this.listRoleID = Role.getRoleId(u.getUserID(), this.controller.getSettings().getConnection());
        for (Role role : this.listRole) {
            CheckBoxTreeItem checkBoxTreeItem = new CheckBoxTreeItem();
            checkBoxTreeItem.setValue((Object)role);
            this.listCheckBoxRole.add((CheckBoxTreeItem<Role>)checkBoxTreeItem);
            roles.getChildren().add((Object)checkBoxTreeItem);
        }
        for (CheckBoxTreeItem checkBoxTreeItem : this.listCheckBoxRole) {
            if (!this.listRoleID.contains(checkBoxTreeItem.getValue())) continue;
            checkBoxTreeItem.setSelected(true);
        }
        this.treeRole.setRoot((TreeItem)roles);
        this.treeRole.setShowRoot(true);
    }

    private void insetDeleteUserRole() {
        block0: for (int i = 0; i < this.listCheckBoxRole.size(); ++i) {
            if (!this.listRoleID.isEmpty()) {
                for (int j = 0; j < this.listRoleID.size(); ++j) {
                    if (this.listRoleID.get(j).equals(this.listCheckBoxRole.get(i).getValue())) {
                        if (this.listCheckBoxRole.get(i).isSelected()) continue block0;
                        this.user.deleteUserRole(((User)this.parameter.get("user")).getUserID(), ((Role)this.listCheckBoxRole.get(i).getValue()).getRoleID(), this.controller.getSettings().getConnection());
                        continue block0;
                    }
                    if (!this.listCheckBoxRole.get(i).isSelected()) continue;
                    boolean exist = false;
                    for (int k = 0; k < this.listRoleID.size(); ++k) {
                        if (!this.listRoleID.get(k).equals(this.listCheckBoxRole.get(i).getValue())) continue;
                        exist = true;
                    }
                    if (exist) continue;
                    User.insertUserRole(((User)this.parameter.get("user")).getUserID(), ((Role)this.listCheckBoxRole.get(i).getValue()).getRoleID(), this.controller.getSettings().getConnection());
                    continue block0;
                }
                continue;
            }
            if (!this.listCheckBoxRole.get(i).isSelected()) continue;
            User.insertUserRole(((User)this.parameter.get("user")).getUserID(), ((Role)this.listCheckBoxRole.get(i).getValue()).getRoleID(), this.controller.getSettings().getConnection());
        }
    }

    private void fillPosMenuTreeView() {
        User u;
        this.listCheckBoxPosMenu = new ArrayList<CheckBoxTreeItem<PosMenu>>();
        String lightGroups = "";
        if (this.tMasterLight) {
            lightGroups = " AND PosMenuID IN(14,19,21,23,81,82)";
        }
        ObservableList<PosMenu> posMenuFullList = PosMenu.getFullList(this.controller.getSettings().getConnection(), " WHERE IsCommand = 0 " + lightGroups);
        CheckBoxTreeItem pos = new CheckBoxTreeItem();
        PosMenu pm = new PosMenu();
        pm.setTitle("Cekiraj meni");
        pos.setValue((Object)pm);
        pos.setExpanded(true);
        this.treePosmenu.setCellFactory(p -> new CheckBoxTreeCell<PosMenu>(){

            public void updateItem(PosMenu item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item != null) {
                    this.setText(item.getTitle());
                }
            }
        });
        for (PosMenu menu : posMenuFullList) {
            CheckBoxTreeItem posMenuGroup = new CheckBoxTreeItem();
            String lightSubGroups = "";
            if (this.tMasterLight) {
                lightSubGroups = " AND PosMenuID IN(24,35,38,48,50,63,82,83,102,114,117)";
            }
            posMenuGroup.setValue((Object)menu);
            pos.getChildren().add((Object)posMenuGroup);
            this.listCheckBoxPosMenu.add((CheckBoxTreeItem<PosMenu>)posMenuGroup);
            ObservableList<PosMenu> posMenuChildrenList = PosMenu.getFullList(this.controller.getSettings().getConnection(), " WHERE ParentPosMenuId = " + menu.getPosMenuID() + lightSubGroups);
            for (PosMenu posM : posMenuChildrenList) {
                CheckBoxTreeItem menuItem = new CheckBoxTreeItem();
                menuItem.setValue((Object)posM);
                posMenuGroup.getChildren().add((Object)menuItem);
                this.listCheckBoxPosMenu.add((CheckBoxTreeItem<PosMenu>)menuItem);
            }
        }
        User user = u = this.selectedUser != null ? this.selectedUser : (User)this.parameter.get("user");
        if (u != null) {
            this.listPosMenuID = PosMenu.getFullListID(u.getUserID(), this.controller.getSettings().getConnection());
            PosMenu pMenu = PosMenu.getByPosMenuCode("EXIT", this.connection);
            if (!this.listPosMenuID.contains((Object)pMenu)) {
                this.listPosMenuID.add((Object)pMenu);
            }
            for (CheckBoxTreeItem<PosMenu> posMenu : this.listCheckBoxPosMenu) {
                if (this.listPosMenuID.contains(posMenu.getValue())) {
                    posMenu.setSelected(true);
                    continue;
                }
                posMenu.setSelected(false);
            }
        }
        this.treePosmenu.setRoot((TreeItem)pos);
        this.treePosmenu.setShowRoot(true);
    }

    private void insertDeleteUserPosMenu() {
        ObservableList currentSelection = FXCollections.observableArrayList();
        for (CheckBoxTreeItem<PosMenu> ti : this.listCheckBoxPosMenu) {
            if (!(ti.isSelected() | ti.isIndeterminate())) continue;
            currentSelection.add(ti.getValue());
        }
        currentSelection.sort((pm1, pm2) -> pm1.getPosMenuID() - pm2.getPosMenuID());
        if (currentSelection.equals(this.listPosMenuID)) {
            return;
        }
        User u = (User)this.parameter.get("user");
        u.deleteAllUserPosMenu(u.getUserID(), this.connection);
        for (PosMenu pm : currentSelection) {
            u.insertUserIntoPosMenu(u.getUserID(), pm.getPosMenuID(), this.connection);
        }
    }
}

