/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import javafx.application.Platform;
import javafx.beans.property.adapter.JavaBeanStringPropertyBuilder;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.person.Loyality;
import rs.petcom.master.dal.person.Person;
import rs.petcom.master.dal.person.PersonCategory;
import rs.petcom.master.dal.person.PersonCategoryEnum;

public class PersonsController
implements ControlledScreen {
    private ScreensController controller;
    private ObservableList<Person> personsList = FXCollections.observableArrayList();
    private ObservableList<PersonCategory> personCategoryList = FXCollections.observableArrayList();
    private Person selectedPerson;
    private String personCategory;
    @FXML
    private BorderPane rootPane;
    @FXML
    private Label title;
    @FXML
    private TextField tfFilter;
    @FXML
    private TableView<Person> tvPerson;
    @FXML
    private TableColumn<Person, String> tcName;
    @FXML
    private TableColumn<Person, String> tcPib;
    @FXML
    private TableColumn<Person, String> tcAddress;
    @FXML
    private TableColumn<Person, String> tcCity;
    @FXML
    private TableColumn<Person, String> tcCategory;
    @FXML
    private Button btnCategoryChange;
    @FXML
    private VBox vBox;

    @Override
    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    @Override
    public void init() {
        this.personCategoryList = PersonCategory.getList(this.controller.getSettings().getConnection());
        this.tfFilter.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                PersonsController.this.loadPersonsList();
            }
        });
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/tableTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
    }

    @Override
    public void setParameter(Object parameter) {
        HashMap mapa = (HashMap)parameter;
        PersonCategoryEnum pce = (PersonCategoryEnum)((Object)mapa.get("personCategory"));
        this.personCategory = pce.getName();
        System.out.println(pce.getName());
        this.title.setText(this.personCategory);
        this.personCategoryList.add((Object)new PersonCategory(pce.getPersonCategoryId(), pce.getName(), pce.isBuyerCol(), pce.isSupplierCol()));
        this.loadPersonsList();
        this.vBox.setPrefWidth(this.controller.getRoot().getScene().getWidth() * 20.0 / 100.0);
    }

    @Override
    public Object getParameter() {
        return null;
    }

    public void initialize() {
        this.tcName.setCellValueFactory((Callback)new PropertyValueFactory("Name"));
        this.tcPib.setCellValueFactory((Callback)new PropertyValueFactory("PIB"));
        this.tcAddress.setCellValueFactory((Callback)new PropertyValueFactory("Address"));
        this.tcCity.setCellValueFactory((Callback)new PropertyValueFactory("City"));
        this.tcCategory.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<Person, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<Person, String> param) {
                try {
                    return new JavaBeanStringPropertyBuilder().bean((Object)PersonCategory.getByID(((Person)param.getValue()).getPersonCategoryID(), PersonsController.this.controller.getSettings().getConnection())).name("Name").build();
                }
                catch (NoSuchMethodException | NullPointerException e) {
                    return null;
                }
            }
        });
        this.tvPerson.getSelectionModel().selectedItemProperty().addListener((observableValue, oldValue, newValue) -> {
            this.selectedPerson = newValue;
        });
    }

    @FXML
    public void personNew(ActionEvent event) {
        String title;
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("controller", this.controller);
        hm.put("selectedPerson", null);
        hm.put("personCategory", this.personCategory);
        String string = title = this.personCategory.equals("Firma") ? "Izbor kategorije kupca" : "Kreiranje novog dobavlja\u010da";
        if (this.personCategory.equals("Firma")) {
            this.controller.showModalDialog(title, ScreensController.SCREEN_BACKOFFICE_PERSONS_NEW_CATEGORY_SELECT, hm, (Window)((Stage)((Node)event.getSource()).getScene().getWindow()));
        } else {
            this.controller.showModalDialog(title, ScreensController.DIALOG_ADD_PERSON, hm, (Window)((Stage)((Node)event.getSource()).getScene().getWindow()));
        }
        this.loadPersonsList();
    }

    @FXML
    public void personDelete(ActionEvent event) {
        if (this.selectedPerson == null) {
            String message = this.personCategory.equals("Firma") ? "Izaberite kupca koga \u017eelite da obrisete" : "Izaberite dobavlja\u010da koga \u017eelite da obrisete";
            this.controller.alert("Upozorenje", message, this.rootPane.getScene().getWindow());
            return;
        }
        this.selectedPerson.delete(this.selectedPerson.getPersonID(), this.controller.getSettings().getConnection());
        this.loadPersonsList();
    }

    @FXML
    public void personUpdate(ActionEvent event) {
        if (this.selectedPerson == null) {
            String message = this.personCategory.equals("Firma") ? "Izaberite kupca koga \u017eelite da izmenite" : "Izaberite dobavlja\u010da koga \u017eelite da izmenite";
            this.controller.alert("Upozorenje", message, this.rootPane.getScene().getWindow());
            return;
        }
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("controller", this.controller);
        hm.put("personCategory", this.personCategory);
        hm.put("selectedPerson", this.selectedPerson);
        hm.put("sourceButton", event.getSource());
        switch (this.selectedPerson.getPersonCategoryID()) {
            case 7: {
                this.controller.showModalDialog("Izmena Gotovinskog kupca", ScreensController.DIALOG_ADD_PERSON_CASHBUYER, hm, (Window)((Stage)((Node)event.getSource()).getScene().getWindow()));
                break;
            }
            case 4: {
                this.controller.showModalDialog("Izmena komitenta", ScreensController.DIALOG_ADD_PERSON_BUYER, hm, (Window)((Stage)((Node)event.getSource()).getScene().getWindow()));
                break;
            }
            case 2: {
                this.controller.showModalDialog("Izmena Loyalitija", ScreensController.DIALOG_ADD_LOYALITY, hm, (Window)((Stage)((Node)event.getSource()).getScene().getWindow()));
                break;
            }
            case 3: {
                this.controller.showModalDialog("Izmena Loyalitija", ScreensController.DIALOG_ADD_PERSON, hm, (Window)((Stage)((Node)event.getSource()).getScene().getWindow()));
            }
        }
        this.loadPersonsList();
    }

    @FXML
    private void changeCategory(ActionEvent event) {
        Person person = (Person)this.tvPerson.getSelectionModel().getSelectedItem();
        if (person != null) {
            if (person.getPersonCategoryID() == 2) {
                String message = "Kupac kategorije loyality se ne mo\u017ee menjati";
                this.controller.alert("Upozorenje", message, this.rootPane.getScene().getWindow());
            } else {
                HashMap<String, Object> hm = new HashMap<String, Object>();
                hm.put("controller", this.controller);
                hm.put("person", person);
                this.controller.showModalDialog("Izmena Gotovinskog kupca", ScreensController.DIALOG_CHANGE_PERSON_CATEGORY, hm, (Window)((Stage)((Node)event.getSource()).getScene().getWindow()));
            }
        } else {
            String message = "Izaberite kupca kome \u017eelite da izmenite kategoriju";
            this.controller.alert("Upozorenje", message, this.rootPane.getScene().getWindow());
        }
        this.loadPersonsList();
    }

    @FXML
    private void getExcel() {
        final Stage taskUpdateStage = this.controller.getSettings().getInfoStage("Kreiranje izve\u0161taja u toku.", this.rootPane.getScene().getWindow());
        Task<Void> creatingReport = new Task<Void>(){

            protected Void call() throws Exception {
                PersonsController.this.writeToExcel();
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        taskUpdateStage.hide();
                    }
                });
                return null;
            }
        };
        new Thread((Runnable)creatingReport).start();
        creatingReport.setOnSucceeded(eventValue -> {
            taskUpdateStage.hide();
            this.controller.alert("Obave\u0161tenje", "Uspe\u0161no ste kreirali izve\u0161taj.", this.rootPane.getScene().getWindow());
        });
        creatingReport.setOnFailed(eventValue -> {
            taskUpdateStage.hide();
            this.controller.alert("Gre\u0161ka!", "Do\u0161lo je do gre\u0161ke prilikom izdavanja izve\u0161taja.", this.rootPane.getScene().getWindow());
        });
    }

    @FXML
    private void actionCsvImport() {
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.US);
        nf.setGroupingUsed(false);
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Import prijemnice");
        FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("CSV files (*.csv)", new String[]{"*.csv"});
        fileChooser.getExtensionFilters().add((Object)extFilter);
        final File file = fileChooser.showOpenDialog(this.rootPane.getScene().getWindow());
        if (file != null) {
            Stage taskUpdateStage = this.controller.getSettings().getInfoStage("U\u010ditavanje detalja u toku.", this.rootPane.getScene().getWindow());
            ArrayList unexistedProducts = new ArrayList();
            Task<Void> loadingCsvTask = new Task<Void>(){

                protected Void call() throws Exception {
                    String line = "";
                    String[] colNames = null;
                    int colPersonTypeID = -1;
                    int colPersonCategoryID = -1;
                    int colPersonVatTypeID = -1;
                    int colName = -1;
                    int colPIB = -1;
                    int colAddress = -1;
                    int colCity = -1;
                    int colZIP = -1;
                    int colMB = -1;
                    int colMail = -1;
                    int colPhone = -1;
                    int colFirstName = -1;
                    int colLastName = -1;
                    int counterRow = 0;
                    try {
                        BufferedReader bf = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                        while ((line = bf.readLine()) != null) {
                            colNames = line.split(";");
                            if (counterRow == 0) {
                                for (int i = 0; i < colNames.length; ++i) {
                                    if (colNames[i].trim().toLowerCase().equals("type")) {
                                        colPersonTypeID = i;
                                    }
                                    if (colNames[i].trim().toLowerCase().equals("category")) {
                                        colPersonCategoryID = i;
                                    }
                                    if (colNames[i].trim().toLowerCase().equals("vat")) {
                                        colPersonVatTypeID = i;
                                    }
                                    if (colNames[i].trim().toLowerCase().equals("name")) {
                                        colName = i;
                                    }
                                    if (colNames[i].trim().toLowerCase().equals("pib")) {
                                        colPIB = i;
                                    }
                                    if (colNames[i].trim().toLowerCase().equals("address")) {
                                        colAddress = i;
                                    }
                                    if (colNames[i].trim().toLowerCase().equals("city")) {
                                        colCity = i;
                                    }
                                    if (colNames[i].trim().toLowerCase().equals("zip")) {
                                        colZIP = i;
                                    }
                                    if (colNames[i].trim().toLowerCase().equals("mb")) {
                                        colMB = i;
                                    }
                                    if (colNames[i].trim().toLowerCase().equals("mail")) {
                                        colMail = i;
                                    }
                                    if (colNames[i].trim().toLowerCase().equals("phone")) {
                                        colPhone = i;
                                    }
                                    if (colNames[i].trim().toLowerCase().equals("firstname")) {
                                        colFirstName = i;
                                    }
                                    if (!colNames[i].trim().toLowerCase().equals("lastname")) continue;
                                    colLastName = i;
                                }
                            } else {
                                Person person = new Person();
                                try {
                                    person.setPersonTypeID(Integer.parseInt(colNames[colPersonTypeID]));
                                }
                                catch (Exception e) {
                                    person.setPersonTypeID(2);
                                }
                                person.setPersonCategoryID(Integer.parseInt(colNames[colPersonCategoryID]));
                                person.setPersonVatTypeID(Integer.parseInt(colNames[colPersonVatTypeID]));
                                person.setSysUserAddID(1L);
                                person.setName(colNames[colName]);
                                person.setPIB(colNames[colPIB]);
                                person.setAddress(colNames[colAddress]);
                                person.setCity(colNames[colCity]);
                                person.setZIP(colNames[colZIP]);
                                try {
                                    person.setFirstName(colNames[colFirstName]);
                                }
                                catch (Exception e) {
                                    person.setFirstName("");
                                }
                                try {
                                    person.setLastName(colNames[colLastName]);
                                }
                                catch (Exception e) {
                                    person.setLastName("");
                                }
                                person.setMB(colNames[colMB]);
                                try {
                                    person.seteMail(colNames[colMail]);
                                }
                                catch (Exception e) {
                                    person.seteMail("");
                                }
                                try {
                                    person.setPhone(colNames[colPhone]);
                                }
                                catch (Exception e) {
                                    person.setPhone("");
                                }
                                person.setNote("");
                                person.setBuyerOfferPriceID(-1L);
                                person.setActive(true);
                                person.insert(PersonsController.this.controller.getUser(), PersonsController.this.controller.getSettings().getConnection());
                                if (person.getPersonTypeID() == 1) {
                                    Loyality.addLoyaliti(person, PersonsController.this.controller);
                                    Loyality.doLoyalitFinancialDiscount(person, PersonsController.this.controller);
                                }
                            }
                            ++counterRow;
                        }
                        bf.close();
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    return null;
                }
            };
            loadingCsvTask.setOnSucceeded(eventValue -> {
                taskUpdateStage.hide();
                this.loadPersonsList();
                if (unexistedProducts.size() > 0) {
                    this.controller.alert("Nepostoje\u0107i PIB", unexistedProducts.toString(), this.rootPane.getScene().getWindow());
                }
            });
            loadingCsvTask.setOnFailed(eventValue -> {
                taskUpdateStage.hide();
                this.controller.alert("Obave\u0161tenje", "Neuspe\u0161no u\u010ditavanje iz csv fajla", this.rootPane.getScene().getWindow());
            });
            loadingCsvTask.exceptionProperty().addListener((obs, old, newValue) -> {
                if (newValue != null) {
                    Exception ex = (Exception)newValue;
                    ex.printStackTrace();
                }
            });
            new Thread((Runnable)loadingCsvTask).start();
        }
    }

    private void writeToExcel() {
        String xlsxTitle = this.personCategory.equals("Firma") ? "Lista kupaca" : "Lista dobavljaca";
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFSheet sheet = wb.createSheet(xlsxTitle);
        XSSFRow header = sheet.createRow(0);
        header.createCell(0).setCellValue("Naziv");
        header.createCell(1).setCellValue("PIB");
        header.createCell(2).setCellValue("Adresa");
        header.createCell(3).setCellValue("Grad");
        header.createCell(4).setCellValue("Postanski broj");
        header.createCell(5).setCellValue("Mati\u010dni broj");
        header.createCell(6).setCellValue("Ime kontakt osobe");
        header.createCell(7).setCellValue("Prezime kontakt osobe");
        sheet.setColumnWidth(0, 4100);
        sheet.setColumnWidth(1, 4100);
        sheet.setColumnWidth(2, 9600);
        sheet.setColumnWidth(3, 4100);
        sheet.setColumnWidth(4, 4100);
        sheet.setColumnWidth(5, 4100);
        sheet.setColumnWidth(6, 4100);
        sheet.setColumnWidth(7, 4100);
        int index = 1;
        for (Person person : this.personsList) {
            XSSFRow row = sheet.createRow(index);
            row.createCell(0).setCellValue(person.getName());
            row.createCell(1).setCellValue(person.getPIB());
            row.createCell(2).setCellValue(person.getAddress());
            row.createCell(3).setCellValue(person.getCity());
            row.createCell(4).setCellValue(person.getZIP());
            row.createCell(5).setCellValue(person.getMB());
            row.createCell(6).setCellValue(person.getFirstName());
            row.createCell(7).setCellValue(person.getLastName());
            ++index;
        }
        try {
            File theDir = new File(this.controller.getSettings().getJasperToPDF() + xlsxTitle.replace(" ", "_"));
            if (!theDir.exists()) {
                try {
                    theDir.mkdir();
                }
                catch (SecurityException se) {
                    se.printStackTrace();
                }
            }
            FileOutputStream fileOutputStream = new FileOutputStream(theDir + File.separator + xlsxTitle.replace(" ", "_").concat(".xlsx"));
            wb.write((OutputStream)fileOutputStream);
            wb.close();
            fileOutputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadPersonsList() {
        PersonCategoryEnum pce = PersonCategoryEnum.getByName(this.personCategory);
        if (pce.isBuyerCol()) {
            PersonCategory.getByName("Firma", this.controller.getSettings().getConnection()).getPersonCategoryID();
            PersonCategory.getByName("Interna-firma", this.controller.getSettings().getConnection()).getPersonCategoryID();
            this.personsList = Person.getAllPersonsList(true, this.tfFilter.getText(), "2,4,7", this.controller.getSettings().getConnection());
        }
        if (pce.isSupplierCol()) {
            this.btnCategoryChange.setVisible(false);
            PersonCategory.getByName("Dobavlja\u010d", this.controller.getSettings().getConnection()).getPersonCategoryID();
            this.personsList = Person.getList(true, this.tfFilter.getText(), String.valueOf(pce.getPersonCategoryId()), this.controller.getSettings().getConnection());
        }
        this.tvPerson.setItems(this.personsList);
    }
}

