/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice;

import java.util.HashMap;
import javafx.beans.property.adapter.JavaBeanStringPropertyBuilder;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.util.Callback;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.person.Contact;
import rs.petcom.master.dal.person.Person;
import rs.petcom.master.dal.person.PersonCategory;

public class PersonSelectDialogNewController
implements DialogController {
    private ScreensController controller;
    private int modalResult;
    private HashMap<String, Object> parameters;
    @FXML
    private BorderPane rootPane;
    @FXML
    private TextField tfFilter;
    @FXML
    private TextArea taNote;
    @FXML
    private TableView<Person> tablePerson;
    @FXML
    private TableColumn<Person, String> tcName;
    @FXML
    private TableColumn<Person, String> tcPIB;
    @FXML
    private TableColumn<Person, String> tcAddress;
    @FXML
    private TableColumn<Person, String> tcPhoneNumber;
    @FXML
    private TableColumn<Person, String> tcMobileNumber;
    @FXML
    private TableColumn<Person, Long> tcFizickoLice;
    @FXML
    private CheckBox cbKupci;
    @FXML
    private CheckBox cbFizickaLica;

    public void initialize() {
        this.tcName.setCellValueFactory((Callback)new PropertyValueFactory("Name"));
        this.tcAddress.setCellValueFactory((Callback)new PropertyValueFactory("Address"));
        this.tcPhoneNumber.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<Person, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<Person, String> param) {
                try {
                    return new JavaBeanStringPropertyBuilder().bean((Object)Contact.getByPersonAndType(((Person)param.getValue()).getPersonID(), 1, PersonSelectDialogNewController.this.controller.getSettings().getConnection())).name("Contact").build();
                }
                catch (NoSuchMethodException | NullPointerException e) {
                    return null;
                }
            }
        });
        this.tcMobileNumber.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<Person, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<Person, String> param) {
                try {
                    return new JavaBeanStringPropertyBuilder().bean((Object)Contact.getByPersonAndType(((Person)param.getValue()).getPersonID(), 2, PersonSelectDialogNewController.this.controller.getSettings().getConnection())).name("Contact").build();
                }
                catch (NoSuchMethodException | NullPointerException e) {
                    return null;
                }
            }
        });
        this.tcFizickoLice.setCellValueFactory((Callback)new PropertyValueFactory("PersonID"));
        this.tcFizickoLice.setCellFactory(column -> new TableCell<Person, Long>(){

            protected void updateItem(Long item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Person.getById(item, PersonSelectDialogNewController.this.controller).getFirstLastName());
                }
            }
        });
        this.tcPIB.setCellValueFactory((Callback)new PropertyValueFactory("PIB"));
        this.cbKupci.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                PersonSelectDialogNewController.this.loadPersonTable();
            }
        });
        this.cbFizickaLica.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                PersonSelectDialogNewController.this.loadPersonTable();
            }
        });
    }

    @Override
    public void setParameter(HashMap<String, Object> parameter) {
        this.controller = (ScreensController)parameter.get("controller");
        this.parameters = parameter;
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.loadPersonTable();
    }

    @Override
    public HashMap<String, Object> getParameter() {
        return null;
    }

    @Override
    public int getModalResult() {
        return this.modalResult;
    }

    @Override
    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }

    @FXML
    private void mouseClick(MouseEvent event) {
        if (event.getClickCount() == 2) {
            this.confirm();
        }
    }

    @FXML
    private void newPerson() {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("controller", this.controller);
        int result = ScreensController.MODAL_RESULT_CANCEL;
        hm.put("personCategory", PersonCategory.BUYER);
        result = this.controller.showModalDialog("Dodavanje komitenta", ScreensController.DIALOG_ADD_PERSON, hm, this.rootPane.getScene().getWindow());
        if (result == ScreensController.MODAL_RESULT_OK) {
            this.loadPersonTable();
        }
    }

    @FXML
    private void confirm() {
        this.modalResult = ScreensController.MODAL_RESULT_OK;
        this.parameters.put("person", this.tablePerson.getSelectionModel().getSelectedItem());
        this.parameters.put("nefiskalnaOtpremnica", false);
        this.controller.getBillList().get(this.controller.getActiveBill()).setNapomena(this.taNote.getText().trim());
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    @FXML
    private void cancel(ActionEvent actionEvent) {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        this.parameters.put("nefiskalnaOtpremnica", false);
        Node source = (Node)actionEvent.getSource();
        Stage stage = (Stage)source.getScene().getWindow();
        stage.close();
    }

    private void loadPersonTable() {
        this.tablePerson.getItems().clear();
        ObservableList<Person> lista = Person.getListByCategory(true, this.controller.getSettings().getConnection());
        for (Person person : lista) {
            if (this.cbKupci.isSelected() && this.cbFizickaLica.isSelected() && (person.getPersonCategoryID() == PersonCategory.getByName("Firma", this.controller.getSettings().getConnection()).getPersonCategoryID() || person.getPersonCategoryID() == PersonCategory.getByName("Kupac", this.controller.getSettings().getConnection()).getPersonCategoryID())) {
                this.tablePerson.getItems().add((Object)person);
            }
            if (this.cbKupci.isSelected() && !this.cbFizickaLica.isSelected() && person.getPersonCategoryID() == PersonCategory.getByName("Firma", this.controller.getSettings().getConnection()).getPersonCategoryID()) {
                this.tablePerson.getItems().add((Object)person);
            }
            if (this.cbKupci.isSelected() || !this.cbFizickaLica.isSelected() || person.getPersonCategoryID() != PersonCategory.getByName("Kupac", this.controller.getSettings().getConnection()).getPersonCategoryID()) continue;
            this.tablePerson.getItems().add((Object)person);
        }
    }
}

