/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice;

import java.util.HashMap;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.PasswordField;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.util.Callback;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Bill;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.person.GiftCard;
import rs.petcom.master.dal.person.Person;
import rs.petcom.master.dal.person.PersonCategory;

public class PersonSelectDialogController
implements DialogController {
    int modalResult = ScreensController.MODAL_RESULT_CANCEL;
    HashMap<String, Object> parameters;
    ScreensController controller;
    Person person;
    Person selectedHiddenLoyality;
    String personCategory;
    ObservableList<Person> listLoyalityPersonWithCard;
    ObservableList<Person> data = FXCollections.observableArrayList();
    boolean postoji;
    Bill bill;
    @FXML
    BorderPane rootPane;
    @FXML
    TableView<Person> table;
    @FXML
    TableColumn<Person, String> tcAddress;
    @FXML
    TableColumn<Person, String> tcPhoneNumber;
    @FXML
    TableColumn<Person, String> tcPIB;
    @FXML
    TableColumn<Person, String> tcMB;
    @FXML
    TableColumn<Person, String> tcCity;
    @FXML
    TableColumn<Person, String> tcZip;
    @FXML
    TableColumn<Person, String> tcEmail;
    @FXML
    TableColumn<Person, Double> tcDiscount;
    @FXML
    TableColumn<Person, Long> tcName;
    @FXML
    TextField tfFilter;
    @FXML
    PasswordField tfCardNumber;
    @FXML
    PasswordField tfGiftCardCode;
    @FXML
    Button btnNewPerson;
    @FXML
    Button btnNewGiftCard;
    @FXML
    Button btnNonFiscal;
    @FXML
    RadioButton rbFizicka;
    @FXML
    RadioButton rbKupci;

    public void initialize() {
        this.tcName.setCellValueFactory((Callback)new PropertyValueFactory("PersonID"));
        this.tcName.setCellFactory(column -> new TableCell<Person, Long>(){

            protected void updateItem(Long item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    Person person = Person.getById(item, PersonSelectDialogController.this.controller);
                    this.setText(!person.getName().equals("") ? person.getName() : person.getFirstLastName());
                }
            }
        });
        this.tcPIB.setCellValueFactory((Callback)new PropertyValueFactory("PIB"));
        this.tcAddress.setCellValueFactory((Callback)new PropertyValueFactory("Address"));
        this.tcPhoneNumber.setCellValueFactory((Callback)new PropertyValueFactory("phone"));
        this.tcEmail.setCellValueFactory((Callback)new PropertyValueFactory("Mail"));
        this.tcCity.setCellValueFactory((Callback)new PropertyValueFactory("City"));
        this.tcZip.setCellValueFactory((Callback)new PropertyValueFactory("ZIP"));
        this.tcDiscount.setCellValueFactory((Callback)new PropertyValueFactory("Discount"));
        this.tcDiscount.setCellFactory((Callback)new Callback<TableColumn<Person, Double>, TableCell<Person, Double>>(){

            public TableCell<Person, Double> call(TableColumn<Person, Double> param) {
                return new TableCell<Person, Double>(){

                    protected void updateItem(Double item, boolean arg1) {
                        super.updateItem((Object)item, arg1);
                        if (item == null) {
                            this.setText("");
                        } else {
                            this.setText(Settings.getNumberFormat(2, true).format(item));
                        }
                    }
                };
            }
        });
        this.tcMB.setCellValueFactory((Callback)new PropertyValueFactory("MB"));
        this.rbFizicka.getToggleGroup().selectedToggleProperty().addListener((observableValue, old_toggle, new_toggle) -> this.populateTable());
    }

    @Override
    public void setParameter(final HashMap<String, Object> parameter) {
        this.parameters = parameter;
        this.controller = (ScreensController)parameter.get("controller");
        this.rbKupci.setSelected(true);
        this.bill = (Bill)parameter.get("currentBill");
        this.listLoyalityPersonWithCard = Person.getPersonForLoyalitiWithCode(this.controller);
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.personCategory = (String)parameter.get("personCategory");
        for (String o : parameter.keySet()) {
            System.out.println((Object)o);
        }
        this.populateTable();
        if (parameter.get("OTP") == null) {
            this.btnNonFiscal.setVisible(false);
            this.btnNonFiscal.setDisable(true);
            this.btnNonFiscal.setPrefWidth(0.0);
        } else {
            if (this.table.getItems().size() > 0) {
                this.table.getSelectionModel().selectFirst();
            }
            this.btnNonFiscal.requestFocus();
        }
        if (!this.controller.getUser().hasRole("gift.card")) {
            this.tfGiftCardCode.setVisible(false);
            this.btnNewGiftCard.setVisible(false);
        }
        this.tfFilter.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode().equals((Object)KeyCode.ENTER)) {
                    event.consume();
                    if (parameter.get("OTP") == null) {
                        PersonSelectDialogController.this.confirm(null);
                    } else {
                        PersonSelectDialogController.this.printNefiskalnaStampa();
                    }
                }
            }
        });
        this.tfCardNumber.requestFocus();
        this.tfCardNumber.setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode().equals((Object)KeyCode.ENTER)) {
                boolean personFound = false;
                keyEvent.consume();
                for (Person p : this.listLoyalityPersonWithCard) {
                    if (!p.getLoyalityCard().equals(this.tfCardNumber.getText())) continue;
                    this.selectedHiddenLoyality = p;
                    personFound = true;
                }
                if (personFound) {
                    if (parameter.get("OTP") == null) {
                        this.confirm(null);
                    } else {
                        this.printNefiskalnaStampa();
                    }
                } else {
                    this.controller.alert("Obave\u0161tenje", "Kupac pod unetom \u0161ifrom nije pronadjen", this.rootPane.getScene().getWindow());
                }
            }
            if (keyEvent.getCode().equals((Object)KeyCode.TAB)) {
                keyEvent.consume();
                this.tfFilter.requestFocus();
            }
            if (keyEvent.getCode().equals((Object)KeyCode.DOWN)) {
                keyEvent.consume();
                this.table.requestFocus();
            }
        });
        this.table.setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode().equals((Object)KeyCode.ENTER)) {
                keyEvent.consume();
                if (parameter.get("OTP") == null) {
                    this.confirm(null);
                } else {
                    this.printNefiskalnaStampa();
                }
            }
        });
        this.tfGiftCardCode.setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode().equals((Object)KeyCode.ENTER)) {
                keyEvent.consume();
                if (this.bill.getSumWithDiscout() <= 0.0) {
                    this.controller.alert("Obavestenje", "Pre odabira proklon kartice, morate odabrati artikle koje zelite da kupite sa istom.", this.rootPane.getScene().getWindow());
                    this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
                    this.parameters.put("nefiskalnaOtpremnica", false);
                    Node source = (Node)keyEvent.getSource();
                    Stage stage = (Stage)source.getScene().getWindow();
                    stage.close();
                } else {
                    for (GiftCard gc : GiftCard.getList(this.controller)) {
                        if (gc.getCode().equals(this.tfGiftCardCode.getText())) {
                            this.parameters.put("giftCard", gc);
                            this.postoji = true;
                            break;
                        }
                        this.postoji = false;
                    }
                    if (parameter.get("OTP") == null) {
                        this.confirm(null);
                    } else {
                        this.printNefiskalnaStampa();
                    }
                }
            }
        });
        if (this.controller.getUser().hasRole("novi.komitent")) {
            this.btnNewPerson.setVisible(true);
        } else {
            this.btnNewPerson.setVisible(false);
        }
    }

    @FXML
    private void cancel(ActionEvent actionEvent) {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        this.parameters.put("nefiskalnaOtpremnica", false);
        Node source = (Node)actionEvent.getSource();
        Stage stage = (Stage)source.getScene().getWindow();
        stage.close();
    }

    @FXML
    private void confirm(ActionEvent actionEvent) {
        if (this.selectedHiddenLoyality != null) {
            this.person = this.selectedHiddenLoyality;
        } else if (this.table.getSelectionModel().getSelectedItem() != null) {
            this.person = (Person)this.table.getSelectionModel().getSelectedItem();
        } else if (!this.tfGiftCardCode.getText().equals("")) {
            if (!this.postoji) {
                this.controller.alert("Obavestenje", "Taj kod ne postoji u bazi", this.rootPane.getScene().getWindow());
                this.tfGiftCardCode.setText("");
                return;
            }
        } else {
            return;
        }
        this.modalResult = ScreensController.MODAL_RESULT_OK;
        this.parameters.put("person", this.person);
        this.parameters.put("nefiskalnaOtpremnica", false);
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    @FXML
    private void printNefiskalnaStampa() {
        this.modalResult = ScreensController.MODAL_RESULT_OK;
        this.parameters.put("nefiskalnaOtpremnica", true);
        this.parameters.put("person", (Person)this.table.getSelectionModel().getSelectedItem());
        this.parameters.put("OTP", null);
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    private void populateTable() {
        this.data.clear();
        ObservableList<Person> persons = FXCollections.observableArrayList();
        if (this.rbKupci.isSelected()) {
            this.tcMB.setVisible(true);
            this.tcPIB.setVisible(true);
            persons = Person.getPersonForLoyaliti(2, this.controller);
        } else {
            this.tcMB.setVisible(false);
            this.tcPIB.setVisible(false);
            persons = Person.getPersonForLoyaliti(1, this.controller);
        }
        for (Person person : persons) {
            if (person.getCode() != null && !person.getCode().equals("")) continue;
            this.data.add((Object)person);
        }
        this.table.setItems(this.data);
        this.filter();
    }

    @FXML
    private void mouseClick(MouseEvent event) {
        if (event.getClickCount() == 2) {
            this.modalResult = ScreensController.MODAL_RESULT_OK;
            this.person = (Person)this.table.getSelectionModel().getSelectedItem();
            this.parameters.put("person", this.person);
            this.parameters.put("nefiskalnaOtpremnica", false);
            ((Stage)((Node)event.getSource()).getScene().getWindow()).close();
        }
    }

    @FXML
    private void newPerson(ActionEvent event) {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("controller", this.controller);
        hm.put("sourceButton", event.getSource());
        System.out.println(event.getSource().toString());
        int result = ScreensController.MODAL_RESULT_CANCEL;
        hm.put("personCategory", PersonCategory.LOYALTY);
        result = this.controller.showModalDialog("Dodavanje loyality-ja", ScreensController.DIALOG_ADD_LOYALITY, hm, this.rootPane.getScene().getWindow());
        if (result == ScreensController.MODAL_RESULT_OK) {
            this.populateTable();
        }
    }

    @FXML
    private void newCardGift() {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("controller", this.controller);
        this.controller.showModalDialog("Dodavanje poklon kartice", ScreensController.DIALOG_ADD_GIFT_CARD, hm, this.rootPane.getScene().getWindow());
    }

    @Override
    public HashMap<String, Object> getParameter() {
        return this.parameters;
    }

    @Override
    public int getModalResult() {
        return this.modalResult;
    }

    @Override
    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }

    private void filter() {
        FilteredList filteredData = new FilteredList(this.data, p -> true);
        this.tfFilter.textProperty().addListener((observable, oldValue, newValue) -> filteredData.setPredicate(p -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            try {
                if (p.getName().toLowerCase().contains(lowerCaseFilter)) {
                    return true;
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            try {
                if (p.getLastName().toLowerCase().contains(lowerCaseFilter)) {
                    return true;
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            try {
                if (p.getFirstLastName().toLowerCase().contains(lowerCaseFilter)) {
                    return true;
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            try {
                if (p.getPIB().toLowerCase().contains(lowerCaseFilter)) {
                    return true;
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            try {
                if (p.getAddress().toLowerCase().contains(lowerCaseFilter)) {
                    return true;
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            return false;
        }));
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)this.table.comparatorProperty());
        this.table.setItems((ObservableList)sortedData);
    }
}

