/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice;

import java.util.HashMap;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.util.Callback;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.person.Person;
import rs.petcom.master.dal.person.PersonCategory;

public class PersonSelectBuyerDialogController
implements DialogController {
    private ScreensController controller;
    private int modalResult;
    private HashMap<String, Object> parameters;
    private ObservableList<Person> personsList = FXCollections.observableArrayList();
    @FXML
    private BorderPane rootPane;
    @FXML
    private TextField tfFilter;
    @FXML
    private TableView<Person> tablePerson;
    @FXML
    private TableColumn<Person, String> tcName;
    @FXML
    private TableColumn<Person, String> tcPIB;
    @FXML
    private TableColumn<Person, String> tcAddress;
    @FXML
    private TableColumn<Person, String> tcMB;
    @FXML
    private TableColumn<Person, String> tcMobileNumber;
    @FXML
    private CheckBox checkAddNote;
    @FXML
    private CheckBox checkAddEfaktura;

    public void initialize() {
        this.tcName.setCellValueFactory((Callback)new PropertyValueFactory("Name"));
        this.tcAddress.setCellValueFactory((Callback)new PropertyValueFactory("Address"));
        this.tcMB.setCellValueFactory((Callback)new PropertyValueFactory("MB"));
        this.tcMobileNumber.setCellValueFactory((Callback)new PropertyValueFactory("phone"));
        this.tcPIB.setCellValueFactory((Callback)new PropertyValueFactory("PIB"));
        this.checkAddEfaktura.setVisible(false);
    }

    @Override
    public void setParameter(HashMap<String, Object> parameter) {
        this.controller = (ScreensController)parameter.get("controller");
        this.parameters = parameter;
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.loadPersonTable();
    }

    @Override
    public HashMap<String, Object> getParameter() {
        return null;
    }

    @Override
    public int getModalResult() {
        return this.modalResult;
    }

    @Override
    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }

    @FXML
    private void mouseClick(MouseEvent event) {
        if (event.getClickCount() == 2) {
            this.confirm();
        }
    }

    @FXML
    private void newPerson() {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("controller", this.controller);
        int result = ScreensController.MODAL_RESULT_CANCEL;
        hm.put("personCategory", PersonCategory.BUYER);
        result = this.controller.showModalDialog("Dodavanje komitenta", ScreensController.DIALOG_ADD_PERSON_BUYER, hm, this.rootPane.getScene().getWindow());
        if (result == ScreensController.MODAL_RESULT_OK) {
            this.loadPersonTable();
        }
        if (hm.get("person") != null) {
            Person p = (Person)hm.get("person");
            this.tfFilter.setText(p.getName());
        }
    }

    @FXML
    private void confirm() {
        if (this.tablePerson.getSelectionModel().getSelectedItem() != null) {
            boolean note = false;
            if (this.checkAddNote.isSelected()) {
                note = true;
            }
            this.modalResult = ScreensController.MODAL_RESULT_OK;
            this.parameters.put("person", this.tablePerson.getSelectionModel().getSelectedItem());
            if (this.parameters.get("person") != null) {
                Person person = (Person)this.parameters.get("person");
                Person personDatabse = Person.getById(person.getPersonID(), this.controller);
                person.setPersonVatTypeID(personDatabse.getPersonVatTypeID());
                this.parameters.put("person", person);
            }
            this.parameters.put("nefiskalnaOtpremnica", false);
            this.parameters.put("addNote", note);
            boolean efaktura = false;
            if (this.checkAddEfaktura.isSelected()) {
                efaktura = true;
            }
            this.parameters.put("addEFaktura", efaktura);
            ((Stage)this.rootPane.getScene().getWindow()).close();
        } else {
            boolean efaktura = false;
            if (this.checkAddEfaktura.isSelected()) {
                efaktura = true;
            }
            this.parameters.put("addEFaktura", efaktura);
            boolean note = false;
            if (this.checkAddNote.isSelected()) {
                note = true;
            }
            this.modalResult = ScreensController.MODAL_RESULT_OK;
            this.parameters.put("person", null);
            this.parameters.put("nefiskalnaOtpremnica", false);
            this.parameters.put("addNote", note);
            this.parameters.put("personEmty", "personEmty");
            ((Stage)this.rootPane.getScene().getWindow()).close();
        }
    }

    @FXML
    private void cancel(ActionEvent actionEvent) {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        this.parameters.put("nefiskalnaOtpremnica", false);
        Node source = (Node)actionEvent.getSource();
        Stage stage = (Stage)source.getScene().getWindow();
        stage.close();
    }

    private void loadPersonTable() {
        this.personsList.clear();
        this.tablePerson.getItems().clear();
        this.personsList = Person.getPersonsByersList(this.controller);
        this.tablePerson.setItems(this.personsList);
        if (!this.personsList.isEmpty()) {
            // empty if block
        }
        this.filter();
    }

    private void filter() {
        FilteredList filteredData = new FilteredList(this.personsList, p -> true);
        this.tfFilter.textProperty().addListener((observable, oldValue, newValue) -> filteredData.setPredicate(p -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            try {
                if (p.getName().toLowerCase().contains(lowerCaseFilter)) {
                    return true;
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            try {
                if (p.getLastName().toLowerCase().contains(lowerCaseFilter)) {
                    return true;
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            try {
                if (p.getFirstLastName().toLowerCase().contains(lowerCaseFilter)) {
                    return true;
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            try {
                if (p.getPIB().toLowerCase().contains(lowerCaseFilter)) {
                    return true;
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            try {
                if (p.getAddress().toLowerCase().contains(lowerCaseFilter)) {
                    return true;
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            return false;
        }));
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)this.tablePerson.comparatorProperty());
        this.tablePerson.setItems((ObservableList)sortedData);
    }
}

