/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice;

import java.util.HashMap;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.util.Callback;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.person.Person;
import rs.petcom.master.dal.person.PersonCategory;

public class PersonReserveSelectDialogController
implements DialogController {
    private int modalResult = ScreensController.MODAL_RESULT_CANCEL;
    private HashMap<String, Object> parameters;
    private ScreensController controller;
    @FXML
    private BorderPane rootPane;
    @FXML
    private TextField tfFilter;
    @FXML
    private TableView<Person> tablePerson;
    @FXML
    private TableColumn<Person, String> columnName;
    @FXML
    private TableColumn<Person, String> columnSurname;
    @FXML
    private TableColumn<Person, String> columnCompany;
    @FXML
    private TableColumn<Person, String> columnPIB;
    @FXML
    private TableColumn<Person, String> columnAddress;
    @FXML
    private TableColumn<Person, String> columnPlace;
    @FXML
    private TableColumn<Person, String> columnPhone;
    @FXML
    private ComboBox<PersonCategory> cbPersonCategory;

    public void initialize() {
        this.columnName.setCellValueFactory((Callback)new PropertyValueFactory("FirstName"));
        this.columnSurname.setCellValueFactory((Callback)new PropertyValueFactory("LastName"));
        this.columnCompany.setCellValueFactory((Callback)new PropertyValueFactory("Name"));
        this.columnPIB.setCellValueFactory((Callback)new PropertyValueFactory("PIB"));
        this.columnAddress.setCellValueFactory((Callback)new PropertyValueFactory("Address"));
        this.columnPlace.setCellValueFactory((Callback)new PropertyValueFactory("City"));
        this.columnPhone.setCellValueFactory((Callback)new PropertyValueFactory("Phone"));
        this.cbPersonCategory.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                PersonReserveSelectDialogController.this.fillPersonTable();
            }
        });
    }

    @Override
    public void setParameter(HashMap<String, Object> parameter) {
        this.parameters = parameter;
        this.controller = (ScreensController)parameter.get("controller");
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.fillPersonCategoryCombo();
        this.fillPersonTable();
    }

    @Override
    public HashMap<String, Object> getParameter() {
        return this.parameters;
    }

    @Override
    public int getModalResult() {
        return this.modalResult;
    }

    @Override
    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }

    private void fillPersonTable() {
        this.tablePerson.setItems(Person.getPersonListByCategories(this.controller, (PersonCategory)this.cbPersonCategory.getSelectionModel().getSelectedItem()));
        this.filter();
    }

    @FXML
    private void cancel(ActionEvent actionEvent) {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        this.parameters.put("selectedPerson", null);
        Node source = (Node)actionEvent.getSource();
        Stage stage = (Stage)source.getScene().getWindow();
        stage.close();
    }

    @FXML
    private void confirm(ActionEvent actionEvent) {
        this.modalResult = ScreensController.MODAL_RESULT_OK;
        this.parameters.put("selectedPerson", this.tablePerson.getSelectionModel().getSelectedItem());
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    @FXML
    private void actionCreatePerson(ActionEvent actionEvent) {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("controller", this.controller);
        hm.put("personCategory", PersonCategory.BUYER);
        this.controller.showModalDialog("Dodavanje komitenta", ScreensController.DIALOG_ADD_PERSON, hm, this.rootPane.getScene().getWindow());
        this.fillPersonTable();
    }

    private void filter() {
        FilteredList filteredData = new FilteredList(this.tablePerson.getItems(), p -> true);
        this.tfFilter.textProperty().addListener((observable, oldValue, newValue) -> filteredData.setPredicate(person -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            try {
                if (person.getName().toLowerCase().contains(lowerCaseFilter)) {
                    return true;
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            try {
                if (person.getLastName().toLowerCase().contains(lowerCaseFilter)) {
                    return true;
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            try {
                if (person.getFirstName().toLowerCase().contains(lowerCaseFilter)) {
                    return true;
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            try {
                if (person.getPIB().toLowerCase().contains(lowerCaseFilter)) {
                    return true;
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            try {
                if (person.getAddress().toLowerCase().contains(lowerCaseFilter)) {
                    return true;
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            try {
                if (person.getPhone().toLowerCase().contains(lowerCaseFilter)) {
                    return true;
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            try {
                if (person.getCity().toLowerCase().contains(lowerCaseFilter)) {
                    return true;
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            try {
                if (person.geteMail().toLowerCase().contains(lowerCaseFilter)) {
                    return true;
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            return false;
        }));
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)this.tablePerson.comparatorProperty());
        this.tablePerson.setItems((ObservableList)sortedData);
    }

    private void fillPersonCategoryCombo() {
        this.cbPersonCategory.getItems().add((Object)new PersonCategory(-1, "Svi kupci", false, false));
        this.cbPersonCategory.getItems().add((Object)PersonCategory.getByName("Firma", this.controller.getSettings().getConnection()));
        this.cbPersonCategory.getItems().add((Object)PersonCategory.getByName("Kupac", this.controller.getSettings().getConnection()));
        this.cbPersonCategory.getSelectionModel().selectFirst();
    }
}

