/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice;

import java.sql.Connection;
import java.util.HashMap;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.User;
import rs.petcom.master.dal.person.Loyality;
import rs.petcom.master.dal.person.Person;

public class PersonCategoryChangeController
implements DialogController {
    private ScreensController controller;
    private HashMap<String, Object> parameters;
    private int modalResult;
    private Person person;
    @FXML
    private BorderPane rootPane;
    @FXML
    private RadioButton rbLoyality;
    @FXML
    private RadioButton rbCompany;
    @FXML
    private Button btnConfirm;
    @FXML
    private Button btnCancel;
    @FXML
    private Label lblMessage;

    @Override
    public void setParameter(HashMap<String, Object> parameter) {
        this.parameters = parameter;
        this.controller = (ScreensController)this.parameters.get("controller");
        this.person = (Person)this.parameters.get("person");
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/tableTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        if (this.person.getPersonCategoryID() == 7) {
            this.lblMessage.setText("Kupac " + this.person.getName() + " pripada kategoriji gotovinski kupac. Mo\u017eete ga prebaciti u kategoriju firma ili Loyaliti ");
            this.rbCompany.setSelected(true);
        } else if (this.person.getPersonCategoryID() == 4) {
            this.lblMessage.setText("Kupac " + this.person.getName() + " pripada kategoriji firma. Mo\u017eete ga prebaciti samo u kategoriju Loyaliti ");
            this.rbCompany.setVisible(false);
            this.rbLoyality.setSelected(true);
        }
    }

    @Override
    public HashMap<String, Object> getParameter() {
        return this.parameters;
    }

    @Override
    public int getModalResult() {
        return this.modalResult;
    }

    @Override
    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }

    @FXML
    private void cancelCategoryChange() {
        ((Stage)this.btnCancel.getScene().getWindow()).close();
    }

    @FXML
    private void confirmCategoryChange() {
        Connection connection = this.controller.getSettings().getConnection();
        User user = this.controller.getUser();
        if (this.rbCompany.isSelected()) {
            this.person.setPersonCategoryID(4);
            this.person.setBuyerOfferPriceID(-1L);
            this.person.update(user, connection);
        } else {
            this.person.setPersonCategoryID(2);
            this.person.setBuyerOfferPriceID(-1L);
            this.person.update(user, connection);
            Loyality.addLoyaliti(this.person, this.controller);
            Loyality.doLoyalitFinancialDiscount(this.person, this.controller);
        }
        ((Stage)this.btnConfirm.getScene().getWindow()).close();
    }
}

