/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice;

import java.util.HashMap;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.PaymentMethod;

public class PaymentMethodNewDialogTrgovinaController
implements DialogController {
    ScreensController controller;
    int modalResult;
    HashMap<String, Object> parameter;
    PaymentMethod selectedPaymentMethod;
    @FXML
    private BorderPane rootPane;
    @FXML
    private TextField tfName;
    @FXML
    private TextField tfCode;
    @FXML
    private TextField tfSort;
    @FXML
    private CheckBox cbActive;
    @FXML
    private CheckBox cbExactAmountDefault;
    @FXML
    private CheckBox cbDefaultSelected;

    @Override
    public void setParameter(HashMap<String, Object> parameter) {
        this.parameter = parameter;
        this.controller = (ScreensController)parameter.get("controller");
        this.selectedPaymentMethod = (PaymentMethod)parameter.get("selectedPaymentMethod");
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/master/css/trgovina/dialogTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/master/css/trgovina/backofficeTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/master/css/trgovina/tabpaneTrgovina.css");
        }
        this.fillDataObject();
    }

    @Override
    public HashMap<String, Object> getParameter() {
        return null;
    }

    @Override
    public int getModalResult() {
        return 0;
    }

    @Override
    public void setModalResult(int modalResult) {
    }

    @FXML
    public void cancel() {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        this.parameter.put("selectedCompany", null);
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    @FXML
    public void post() {
        if (this.selectedPaymentMethod != null) {
            this.selectedPaymentMethod.setName(this.tfName.getText());
            this.selectedPaymentMethod.setCode(this.tfCode.getText());
            this.selectedPaymentMethod.setSort(Integer.parseInt(this.tfSort.getText().trim()));
            this.selectedPaymentMethod.setActive(this.cbActive.isSelected());
            this.selectedPaymentMethod.setIsDefault(this.cbDefaultSelected.isSelected());
            this.selectedPaymentMethod.setExactAmountDefault(this.cbExactAmountDefault.isSelected());
            this.selectedPaymentMethod.update(this.controller);
        } else {
            this.selectedPaymentMethod = new PaymentMethod();
            this.selectedPaymentMethod.setName(this.tfName.getText());
            this.selectedPaymentMethod.setCode(this.tfCode.getText());
            this.selectedPaymentMethod.setSort(Integer.parseInt(this.tfSort.getText().trim()));
            this.selectedPaymentMethod.setActive(this.cbActive.isSelected());
            this.selectedPaymentMethod.setIsDefault(this.cbDefaultSelected.isSelected());
            this.selectedPaymentMethod.setExactAmountDefault(this.cbExactAmountDefault.isSelected());
            this.selectedPaymentMethod.insert(this.controller);
        }
        this.modalResult = ScreensController.MODAL_RESULT_OK;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    private void fillDataObject() {
        if (this.selectedPaymentMethod != null) {
            this.tfName.setText(this.selectedPaymentMethod.getName());
            this.tfCode.setText(this.selectedPaymentMethod.getCode());
            this.tfSort.setText(String.valueOf(this.selectedPaymentMethod.getSort()));
            this.cbActive.setSelected(this.selectedPaymentMethod.isActive());
            this.cbExactAmountDefault.setSelected(this.selectedPaymentMethod.isExactAmountDefault());
            this.cbDefaultSelected.setSelected(this.selectedPaymentMethod.isIsDefault());
        } else {
            this.tfName.setText("");
            this.tfCode.setText("");
            this.tfSort.setText("");
            this.cbActive.setSelected(false);
            this.cbExactAmountDefault.setSelected(false);
            this.cbDefaultSelected.setSelected(false);
        }
    }
}

