/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice;

import java.sql.SQLException;
import java.util.HashMap;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.PayCard;

public class PayCardNewDialogController
implements DialogController {
    private ScreensController controller;
    private int modalResult;
    private PayCard selectedPayCard;
    @FXML
    private BorderPane rootPane;
    @FXML
    private TextField tfName;
    @FXML
    private TextField tfPercent;
    @FXML
    private CheckBox cbActive;

    @Override
    public void setParameter(HashMap<String, Object> parameter) {
        this.controller = (ScreensController)parameter.get("controller");
        this.tfPercent.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (!newValue.matches("|[-\\+]?|[-\\+]?\\d+\\.?|[-\\+]?\\d+\\.?\\d+")) {
                    PayCardNewDialogController.this.tfPercent.setText(oldValue);
                }
            }
        });
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/master/css/trgovina/dialogTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/master/css/trgovina/backofficeTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/master/css/trgovina/tabpaneTrgovina.css");
        }
        this.selectedPayCard = (PayCard)parameter.get("selectedPayCard");
        this.loadPayCard();
    }

    @Override
    public HashMap<String, Object> getParameter() {
        return null;
    }

    @Override
    public int getModalResult() {
        return this.modalResult;
    }

    @Override
    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }

    @FXML
    public void confirm(ActionEvent event) {
        if (!this.validate()) {
            return;
        }
        if (this.selectedPayCard != null) {
            this.selectedPayCard.setName(this.tfName.getText().trim());
            this.selectedPayCard.setPercent(Double.parseDouble(this.tfPercent.getText().trim()));
            this.selectedPayCard.setActive(this.cbActive.isSelected());
            this.selectedPayCard.update(this.controller);
        } else {
            this.selectedPayCard = new PayCard();
            this.selectedPayCard.setName(this.tfName.getText().trim());
            this.selectedPayCard.setPercent(Double.parseDouble(this.tfPercent.getText().trim()));
            this.selectedPayCard.setActive(this.cbActive.isSelected());
            try {
                this.selectedPayCard.insert(this.controller);
            }
            catch (SQLException e) {
                this.controller.alert("Obavestenje", "Postoji karica sa tim imenom u bazi podataka, unesite novu karticu", this.rootPane.getScene().getWindow());
                return;
            }
        }
        ((Stage)((Node)event.getSource()).getScene().getWindow()).close();
    }

    @FXML
    public void cancel(ActionEvent event) {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        ((Stage)((Node)event.getSource()).getScene().getWindow()).close();
    }

    private void loadPayCard() {
        if (this.selectedPayCard != null) {
            this.tfName.setText(this.selectedPayCard.getName().trim());
            this.tfPercent.setText(String.valueOf(this.selectedPayCard.getPercent()));
            this.cbActive.setSelected(this.selectedPayCard.isActive());
        } else {
            this.tfName.setText("");
            this.tfPercent.setText("");
            this.cbActive.setSelected(false);
        }
    }

    private boolean validate() {
        if (this.tfName.getText() == null) {
            this.controller.alert("Upozorenje", "Popunite sva polja!", this.rootPane.getScene().getWindow());
            return false;
        }
        return true;
    }
}

