/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Tab;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.LoyalitySettings;

public class LoyalitySettingsController
implements ControlledScreen {
    ScreensController controller;
    long ParentLoyalitySettingsID;
    ObservableList<LoyalitySettings> list;
    @FXML
    private BorderPane rootPane;
    @FXML
    private Tab tabAkcijaBodovi;
    @FXML
    private Tab tabAkcijaKupovina;
    @FXML
    private Tab tabLimit;
    @FXML
    private CheckBox cbAkcijaBodovi;
    @FXML
    private CheckBox cbAkcijaKupovina;
    @FXML
    private CheckBox cbLimit;
    @FXML
    private TextField tfVrednostKupovnogBoda;
    @FXML
    private TextField tfVrednostProdajnogBoda;
    @FXML
    private TextField tfBrojKupovina;
    @FXML
    private TextField tfPopustNaBrojKupovina;
    @FXML
    private TextField tfMinimumVrednost;
    @FXML
    private TextField tfMaksimumVrednost;
    @FXML
    private TextField tfLimit;

    @Override
    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    @Override
    public void init() {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/tableTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.list = LoyalitySettings.getList(this.controller);
        try {
            this.cbAkcijaBodovi.setSelected(this.controller.getLoyalitySettings().getActualByName(this.controller, "point.value.round").equals("true"));
            this.cbAkcijaKupovina.setSelected(this.controller.getLoyalitySettings().getActualByName(this.controller, "bill.number.discount.active").equals("true"));
            this.cbLimit.setSelected(this.controller.getLoyalitySettings().getActualByName(this.controller, "loyalty.limit").equals("true"));
            this.tfVrednostKupovnogBoda.setText(this.controller.getLoyalitySettings().getActualByName(this.controller, "value.loyality.buying.point"));
            this.tfVrednostProdajnogBoda.setText(this.controller.getLoyalitySettings().getActualByName(this.controller, "value.loyality.sales.point"));
            this.tfMinimumVrednost.setText(this.controller.getLoyalitySettings().getActualByName(this.controller, "minimum.value.buying"));
            this.tfMaksimumVrednost.setText(this.controller.getLoyalitySettings().getActualByName(this.controller, "maximum.value.buying"));
            this.tfBrojKupovina.setText(this.controller.getLoyalitySettings().getActualByName(this.controller, "bill.no.discount.numbers"));
            this.tfPopustNaBrojKupovina.setText(this.controller.getLoyalitySettings().getActualByName(this.controller, "bill.no.discount.percent"));
            this.tfLimit.setText(this.controller.getLoyalitySettings().getActualByName(this.controller, "loyalty.limit.value"));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (this.cbAkcijaBodovi.isSelected()) {
            this.tabAkcijaBodovi.setDisable(false);
        }
        if (this.cbAkcijaKupovina.isSelected()) {
            this.tabAkcijaKupovina.setDisable(false);
        }
        if (this.cbLimit.isSelected()) {
            this.tabLimit.setDisable(false);
        }
    }

    @Override
    public void setParameter(Object parameter) {
    }

    @Override
    public Object getParameter() {
        return null;
    }

    public void initialize() {
        this.cbAkcijaBodovi.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (newValue.booleanValue()) {
                    LoyalitySettingsController.this.tabAkcijaBodovi.setDisable(false);
                } else {
                    LoyalitySettingsController.this.tabAkcijaBodovi.setDisable(true);
                }
            }
        });
        this.cbAkcijaKupovina.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (newValue.booleanValue()) {
                    LoyalitySettingsController.this.tabAkcijaKupovina.setDisable(false);
                } else {
                    LoyalitySettingsController.this.tabAkcijaKupovina.setDisable(true);
                }
            }
        });
        this.cbLimit.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (newValue.booleanValue()) {
                    LoyalitySettingsController.this.tabLimit.setDisable(false);
                } else {
                    LoyalitySettingsController.this.tabLimit.setDisable(true);
                }
            }
        });
    }

    @FXML
    private void commitAction() {
        for (LoyalitySettings loyalitySettings : this.list) {
            LoyalitySettings lSettings = new LoyalitySettings();
            if (this.cbAkcijaBodovi.isSelected()) {
                lSettings.setLoyalitySettingsName("point.value.round");
                lSettings.setLoyalitySettingsActual("true");
                lSettings.setLoyalitySettingsID(lSettings.getIDByName(this.controller, "point.value.round"));
                lSettings.updateActualByName(this.controller);
                if (loyalitySettings.getLoyalitySettingsName().equals("value.loyality.sales.point")) {
                    lSettings.setLoyalitySettingsName("value.loyality.sales.point");
                    lSettings.setLoyalitySettingsActual(this.tfVrednostProdajnogBoda.getText());
                    lSettings.setLoyalitySettingsID(lSettings.getIDByName(this.controller, "value.loyality.sales.point"));
                    lSettings.updateActualByName(this.controller);
                }
                if (loyalitySettings.getLoyalitySettingsName().equals("value.loyality.buying.point")) {
                    lSettings.setLoyalitySettingsName("value.loyality.buying.point");
                    lSettings.setLoyalitySettingsActual(this.tfVrednostKupovnogBoda.getText());
                    lSettings.setLoyalitySettingsID(lSettings.getIDByName(this.controller, "value.loyality.buying.point"));
                    lSettings.updateActualByName(this.controller);
                }
                if (loyalitySettings.getLoyalitySettingsName().equals("minimum.value.buying")) {
                    lSettings.setLoyalitySettingsName("minimum.value.buying");
                    lSettings.setLoyalitySettingsActual(this.tfMinimumVrednost.getText());
                    lSettings.setLoyalitySettingsID(lSettings.getIDByName(this.controller, "minimum.value.buying"));
                    lSettings.updateActualByName(this.controller);
                }
                if (loyalitySettings.getLoyalitySettingsName().equals("maximum.value.buying")) {
                    lSettings.setLoyalitySettingsName("maximum.value.buying");
                    lSettings.setLoyalitySettingsActual(this.tfMaksimumVrednost.getText());
                    lSettings.setLoyalitySettingsID(lSettings.getIDByName(this.controller, "maximum.value.buying"));
                    lSettings.updateActualByName(this.controller);
                }
            } else {
                lSettings.setLoyalitySettingsName("point.value.round");
                lSettings.setLoyalitySettingsActual("false");
                lSettings.setLoyalitySettingsID(lSettings.getIDByName(this.controller, "point.value.round"));
                lSettings.updateActualByName(this.controller);
            }
            if (this.cbAkcijaKupovina.isSelected()) {
                lSettings.setLoyalitySettingsName("bill.number.discount.active");
                lSettings.setLoyalitySettingsActual("true");
                lSettings.setLoyalitySettingsID(lSettings.getIDByName(this.controller, "bill.number.discount.active"));
                lSettings.updateActualByName(this.controller);
                if (loyalitySettings.getLoyalitySettingsName().equals("bill.no.discount.numbers")) {
                    lSettings.setLoyalitySettingsName("bill.no.discount.numbers");
                    lSettings.setLoyalitySettingsActual(this.tfBrojKupovina.getText());
                    lSettings.setLoyalitySettingsID(lSettings.getIDByName(this.controller, "bill.no.discount.numbers"));
                    lSettings.updateActualByName(this.controller);
                }
                if (loyalitySettings.getLoyalitySettingsName().equals("bill.no.discount.percent")) {
                    lSettings.setLoyalitySettingsName("bill.no.discount.percent");
                    lSettings.setLoyalitySettingsActual(this.tfPopustNaBrojKupovina.getText());
                    lSettings.setLoyalitySettingsID(lSettings.getIDByName(this.controller, "bill.no.discount.percent"));
                    lSettings.updateActualByName(this.controller);
                }
            } else {
                lSettings.setLoyalitySettingsName("bill.number.discount.active");
                lSettings.setLoyalitySettingsActual("false");
                lSettings.setLoyalitySettingsID(lSettings.getIDByName(this.controller, "bill.number.discount.active"));
                lSettings.updateActualByName(this.controller);
            }
            if (this.cbLimit.isSelected()) {
                lSettings.setLoyalitySettingsName("loyalty.limit");
                lSettings.setLoyalitySettingsActual("true");
                lSettings.setLoyalitySettingsID(lSettings.getIDByName(this.controller, "loyalty.limit"));
                lSettings.updateActualByName(this.controller);
                if (!loyalitySettings.getLoyalitySettingsName().equals("loyalty.limit.value")) continue;
                lSettings.setLoyalitySettingsName("loyalty.limit.value");
                lSettings.setLoyalitySettingsActual(this.tfLimit.getText());
                lSettings.setLoyalitySettingsID(lSettings.getIDByName(this.controller, "loyalty.limit.value"));
                lSettings.updateActualByName(this.controller);
                continue;
            }
            lSettings.setLoyalitySettingsName("loyalty.limit");
            lSettings.setLoyalitySettingsActual("false");
            lSettings.setLoyalitySettingsID(lSettings.getIDByName(this.controller, "loyalty.limit"));
            lSettings.updateActualByName(this.controller);
        }
    }
}

