/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice;

import java.sql.Connection;
import java.time.LocalDate;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.util.Callback;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.BuyerOfferPrice;
import rs.petcom.master.dal.FinancialDiscount;
import rs.petcom.master.dal.LoyalitySettings;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.person.Contact;
import rs.petcom.master.dal.person.Loyality;
import rs.petcom.master.dal.person.LoyaltyFinancialDiscount;
import rs.petcom.master.dal.person.LoyaltyGroup;
import rs.petcom.master.dal.person.LoyaltyLimit;
import rs.petcom.master.dal.person.Person;
import rs.petcom.master.dal.person.PersonType;

public class LoyalityNewDialogController
implements DialogController {
    ScreensController controller;
    int modalResult;
    HashMap<String, Object> parameter;
    Person selectedPerson;
    LoyaltyLimit loyaltyLimit;
    ObservableList<Contact> contactList;
    private ObservableList<LoyaltyFinancialDiscount> loyaltyFinancialDiscountList;
    private EventHandler<KeyEvent> handler;
    int days;
    @FXML
    private BorderPane rootPane;
    @FXML
    private TabPane tabs;
    @FXML
    private Tab tabAkcijaBodovi;
    @FXML
    private Tab tabAkcijaBrojKupovina;
    @FXML
    private Tab tabLimit;
    @FXML
    private Tab tabPerson;
    @FXML
    private Tab tabCompany;
    @FXML
    private TextField tfName;
    @FXML
    private TextField tfFirstName;
    @FXML
    private TextField tfLastName;
    @FXML
    private TextField tfPhone;
    @FXML
    private TextField tfEmail;
    @FXML
    private TextField tfCode;
    @FXML
    private TextField tfAddress;
    @FXML
    private TextField tfZip;
    @FXML
    private TextField tfCity;
    @FXML
    private TextField tfPIB;
    @FXML
    private TextField tfMB;
    @FXML
    private TextField tfPopust;
    @FXML
    private TextField tfBrojBodova;
    @FXML
    private TextField tfVrednostKupovnogBoda;
    @FXML
    private TextField tfVrednostProdajnogBoda;
    @FXML
    private TextField tfBrojKupovina;
    @FXML
    private TextField tfTrenutniBrojKupovina;
    @FXML
    private TextField tfPopustNaKupovine;
    @FXML
    private TextField tfLimit;
    @FXML
    private TextField tfCurrentLimit;
    @FXML
    private TextField tfNumberOfDays;
    @FXML
    private TextField tfDetailsPrintNumber;
    @FXML
    private TextField tfBrojDana;
    @FXML
    private TextField tfCompanyAddress;
    @FXML
    private TextField tfCompanyZip;
    @FXML
    private TextField tfCompanyCity;
    @FXML
    private TextField tfCompanyDiscount;
    @FXML
    private TextField tfCompanyEmail;
    @FXML
    private TextField tfCompnyPhone;
    @FXML
    private TextField tfCompanyCardCode;
    @FXML
    private TextField tfCurrencyDays;
    @FXML
    private TextArea taCompanyNote;
    @FXML
    private TextArea taNote;
    @FXML
    private Button btnConfirm;
    @FXML
    private Button btnConfirmPib;
    @FXML
    private CheckBox cbActive;
    @FXML
    private CheckBox cbVipLoyaltyPrice;
    @FXML
    private CheckBox cbActiveLimit;
    @FXML
    private CheckBox cbAktivanFP;
    @FXML
    private CheckBox cbGodina;
    @FXML
    private CheckBox cbMesec;
    @FXML
    private CheckBox cbNedelja;
    @FXML
    private CheckBox cbBrojDana;
    @FXML
    private TableView<FinancialDiscount> tableFP;
    @FXML
    private Label lblmessage;
    @FXML
    private Label title;
    @FXML
    private TableColumn<FinancialDiscount, Long> columnNaziv;
    @FXML
    private TableColumn<FinancialDiscount, Long> columnVrednost;
    @FXML
    private TableColumn<FinancialDiscount, Long> columnPopust;
    @FXML
    private TableColumn<FinancialDiscount, CheckBox> columnAktivan;
    @FXML
    private ComboBox<LoyaltyGroup> cbLoyaltyGroup;
    @FXML
    private ComboBox<BuyerOfferPrice> cbBuyerOfferPriceList;
    @FXML
    private RadioButton rbYear;
    @FXML
    private RadioButton rbMonth;
    @FXML
    private RadioButton rbWeek;
    @FXML
    private RadioButton rbDay;
    @FXML
    private DatePicker dpDateTo;
    @FXML
    private CheckBox cbTaxExampt;
    @FXML
    private TextField tfIznosRacuna;
    protected String period = "";
    private Button pressedButton;

    public void initialize() {
        this.columnNaziv.setCellValueFactory((Callback)new PropertyValueFactory("financialDiscountiD"));
        this.columnNaziv.setCellFactory(column -> new TableCell<FinancialDiscount, Long>(){

            protected void updateItem(Long item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText("");
                } else {
                    FinancialDiscount financialDiscount = FinancialDiscount.getFinancialDiscountById(item, LoyalityNewDialogController.this.controller);
                    this.setText(financialDiscount.getName());
                }
            }
        });
        this.columnVrednost.setCellValueFactory((Callback)new PropertyValueFactory("financialDiscountiD"));
        this.columnVrednost.setCellFactory(column -> new TableCell<FinancialDiscount, Long>(){

            protected void updateItem(Long item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText("");
                } else {
                    FinancialDiscount financialDiscount = FinancialDiscount.getFinancialDiscountById(item, LoyalityNewDialogController.this.controller);
                    this.setText(String.valueOf(financialDiscount.getValue()));
                }
            }
        });
        this.columnPopust.setCellValueFactory((Callback)new PropertyValueFactory("financialDiscountiD"));
        this.columnPopust.setCellFactory(column -> new TableCell<FinancialDiscount, Long>(){

            protected void updateItem(Long item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText("");
                } else {
                    FinancialDiscount financialDiscount = FinancialDiscount.getFinancialDiscountById(item, LoyalityNewDialogController.this.controller);
                    this.setText(String.valueOf(financialDiscount.getDiscount()));
                }
            }
        });
        this.columnAktivan.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<FinancialDiscount, CheckBox>, ObservableValue<CheckBox>>(){

            public ObservableValue<CheckBox> call(TableColumn.CellDataFeatures<FinancialDiscount, CheckBox> arg0) {
                final FinancialDiscount financialDiscount = (FinancialDiscount)arg0.getValue();
                final CheckBox checkBox = new CheckBox();
                checkBox.selectedProperty().setValue(Boolean.valueOf(LoyalityNewDialogController.this.loyaltyFinancialDiscountList.contains((Object)LoyaltyFinancialDiscount.getFinancialDiscountByID(financialDiscount.getFinancialDiscountiD(), LoyalityNewDialogController.this.controller))));
                checkBox.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                    public void changed(ObservableValue<? extends Boolean> ov, Boolean old_val, Boolean new_val) {
                        if (checkBox.isSelected()) {
                            LoyaltyFinancialDiscount loyaltyFinancialDiscount = new LoyaltyFinancialDiscount();
                            loyaltyFinancialDiscount.setFinancialDiscountID(financialDiscount.getFinancialDiscountiD());
                            loyaltyFinancialDiscount.setLoyaltyID(LoyalityNewDialogController.this.selectedPerson != null ? LoyalityNewDialogController.this.selectedPerson.getLoyalityID() : -1L);
                            LoyalityNewDialogController.this.loyaltyFinancialDiscountList.add((Object)loyaltyFinancialDiscount);
                        } else {
                            Iterator i = LoyalityNewDialogController.this.loyaltyFinancialDiscountList.iterator();
                            while (i.hasNext()) {
                                LoyaltyFinancialDiscount e = (LoyaltyFinancialDiscount)i.next();
                                if (e.getFinancialDiscountID() != financialDiscount.getFinancialDiscountiD()) continue;
                                i.remove();
                            }
                        }
                    }
                });
                return new SimpleObjectProperty((Object)checkBox);
            }
        });
        this.cbGodina.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (LoyalityNewDialogController.this.cbGodina.isSelected()) {
                    LoyalityNewDialogController.this.cbMesec.setSelected(!LoyalityNewDialogController.this.cbGodina.isSelected());
                    LoyalityNewDialogController.this.cbNedelja.setSelected(!LoyalityNewDialogController.this.cbGodina.isSelected());
                    LoyalityNewDialogController.this.cbBrojDana.setSelected(!LoyalityNewDialogController.this.cbGodina.isSelected());
                    LoyalityNewDialogController.this.tfBrojDana.setDisable(LoyalityNewDialogController.this.cbGodina.isSelected());
                    LoyalityNewDialogController.this.period = "YEAR";
                    System.out.println(LoyalityNewDialogController.this.period);
                }
            }
        });
        this.cbMesec.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (LoyalityNewDialogController.this.cbMesec.isSelected()) {
                    LoyalityNewDialogController.this.cbGodina.setSelected(!LoyalityNewDialogController.this.cbMesec.isSelected());
                    LoyalityNewDialogController.this.cbNedelja.setSelected(!LoyalityNewDialogController.this.cbMesec.isSelected());
                    LoyalityNewDialogController.this.cbBrojDana.setSelected(!LoyalityNewDialogController.this.cbMesec.isSelected());
                    LoyalityNewDialogController.this.tfBrojDana.setDisable(LoyalityNewDialogController.this.cbMesec.isSelected());
                    LoyalityNewDialogController.this.period = "MONTH";
                    System.out.println(LoyalityNewDialogController.this.period);
                }
            }
        });
        this.cbNedelja.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (LoyalityNewDialogController.this.cbNedelja.isSelected()) {
                    LoyalityNewDialogController.this.cbGodina.setSelected(!LoyalityNewDialogController.this.cbNedelja.isSelected());
                    LoyalityNewDialogController.this.cbMesec.setSelected(!LoyalityNewDialogController.this.cbNedelja.isSelected());
                    LoyalityNewDialogController.this.cbBrojDana.setSelected(!LoyalityNewDialogController.this.cbNedelja.isSelected());
                    LoyalityNewDialogController.this.tfBrojDana.setDisable(LoyalityNewDialogController.this.cbNedelja.isSelected());
                    LoyalityNewDialogController.this.period = "WEEK";
                    System.out.println(LoyalityNewDialogController.this.period);
                }
            }
        });
        this.cbBrojDana.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (LoyalityNewDialogController.this.cbBrojDana.isSelected()) {
                    LoyalityNewDialogController.this.cbGodina.setSelected(!LoyalityNewDialogController.this.cbBrojDana.isSelected());
                    LoyalityNewDialogController.this.cbMesec.setSelected(!LoyalityNewDialogController.this.cbBrojDana.isSelected());
                    LoyalityNewDialogController.this.cbNedelja.setSelected(!LoyalityNewDialogController.this.cbBrojDana.isSelected());
                    LoyalityNewDialogController.this.tfBrojDana.setDisable(!LoyalityNewDialogController.this.cbBrojDana.isSelected());
                    LoyalityNewDialogController.this.period = "DAY";
                    System.out.println(LoyalityNewDialogController.this.period);
                }
            }
        });
        this.cbLoyaltyGroup.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (LoyalityNewDialogController.this.selectedPerson == null) {
                    LoyalityNewDialogController.this.tfPopust.setText(String.valueOf(((LoyaltyGroup)LoyalityNewDialogController.this.cbLoyaltyGroup.getSelectionModel().getSelectedItem()).getDefaultDiscount()));
                }
            }
        });
        final ToggleGroup group = new ToggleGroup();
        this.rbYear.setToggleGroup(group);
        this.rbMonth.setToggleGroup(group);
        this.rbWeek.setToggleGroup(group);
        this.rbDay.setToggleGroup(group);
        group.selectedToggleProperty().addListener((ChangeListener)new ChangeListener<Toggle>(){

            public void changed(ObservableValue<? extends Toggle> ov, Toggle old_toggle, final Toggle new_toggle) {
                if (group.getSelectedToggle() != null) {
                    RadioButton chk = (RadioButton)new_toggle.getToggleGroup().getSelectedToggle();
                    final Date date1 = Settings.fromLocalDate((LocalDate)LoyalityNewDialogController.this.dpDateTo.getValue());
                    if (chk.getText().equals("Godina")) {
                        LoyalityNewDialogController.this.tfNumberOfDays.setDisable(true);
                        LoyalityNewDialogController.this.tfNumberOfDays.setText("1");
                        Date date2 = Settings.fromLocalDate(((LocalDate)LoyalityNewDialogController.this.dpDateTo.getValue()).plusYears(1L));
                        long diff = date2.getTime() - date1.getTime();
                        LoyalityNewDialogController.this.days = (int)TimeUnit.DAYS.convert(diff, TimeUnit.MILLISECONDS);
                    }
                    if (chk.getText().equals("Mesec")) {
                        LoyalityNewDialogController.this.tfNumberOfDays.setDisable(true);
                        LoyalityNewDialogController.this.tfNumberOfDays.setText("1");
                        Date date3 = Settings.fromLocalDate(((LocalDate)LoyalityNewDialogController.this.dpDateTo.getValue()).plusMonths(1L));
                        long diff1 = date3.getTime() - date1.getTime();
                        LoyalityNewDialogController.this.days = (int)TimeUnit.DAYS.convert(diff1, TimeUnit.MILLISECONDS);
                    }
                    if (chk.getText().equals("Nedelja")) {
                        LoyalityNewDialogController.this.tfNumberOfDays.setDisable(true);
                        LoyalityNewDialogController.this.tfNumberOfDays.setText("1");
                        Date date4 = Settings.fromLocalDate(((LocalDate)LoyalityNewDialogController.this.dpDateTo.getValue()).plusWeeks(1L));
                        long diff2 = date4.getTime() - date1.getTime();
                        LoyalityNewDialogController.this.days = (int)TimeUnit.DAYS.convert(diff2, TimeUnit.MILLISECONDS);
                    }
                    if (chk.getText().equals("Dan")) {
                        LoyalityNewDialogController.this.tfNumberOfDays.setDisable(false);
                        LoyalityNewDialogController.this.tfNumberOfDays.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

                            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                                Date date5 = null;
                                if (new_toggle != null) {
                                    date5 = Settings.fromLocalDate(((LocalDate)LoyalityNewDialogController.this.dpDateTo.getValue()).plusDays(Long.parseLong(newValue)));
                                }
                                long diff3 = date5.getTime() - date1.getTime();
                                LoyalityNewDialogController.this.days = (int)TimeUnit.DAYS.convert(diff3, TimeUnit.MILLISECONDS);
                            }
                        });
                    }
                }
            }
        });
    }

    @Override
    public void setParameter(HashMap<String, Object> parameter) {
        this.parameter = parameter;
        this.pressedButton = (Button)parameter.get("sourceButton");
        this.selectedPerson = (Person)parameter.get("selectedPerson");
        System.out.println(this.pressedButton.getText());
        this.taCompanyNote.setWrapText(true);
        this.taNote.setWrapText(true);
        switch (this.pressedButton.getText().trim()) {
            case "Novi komitent": {
                this.tabs.getTabs().remove((Object)this.tabCompany);
                break;
            }
            case "Nova firma": {
                this.tabs.getTabs().remove((Object)this.tabPerson);
                break;
            }
            case "Izmene": {
                if (this.selectedPerson.getPersonTypeID() == 2) {
                    this.tabs.getTabs().remove((Object)this.tabPerson);
                    this.cbTaxExampt.setSelected(this.selectedPerson.isTaxExempt());
                    break;
                }
                this.tabs.getTabs().remove((Object)this.tabCompany);
                break;
            }
            default: {
                this.tabs.getTabs().remove((Object)this.tabPerson);
            }
        }
        this.controller = (ScreensController)parameter.get("controller");
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0) {
            this.rootPane.getStylesheets().clear();
        }
        BuyerOfferPrice buyerOfferPrice = new BuyerOfferPrice();
        buyerOfferPrice.setName("Svi cenovnici");
        this.cbBuyerOfferPriceList.getItems().add((Object)buyerOfferPrice);
        this.cbLoyaltyGroup.setItems(LoyaltyGroup.getLoyaltyGroupList(this.controller));
        if (this.selectedPerson != null) {
            this.btnConfirmPib.setDisable(true);
            this.title.setText("Loyality izmena");
            this.contactList = Contact.getListByPerson(this.selectedPerson, this.controller.getSettings().getConnection());
            this.fillPersonData(this.selectedPerson);
            this.fillLoyaltyData(this.selectedPerson.getLoyality().getLoyalityID());
            for (LoyaltyGroup loyaltyGroup : this.cbLoyaltyGroup.getItems()) {
                if (this.selectedPerson.getLoyality().getLoyaltyGroupId() != loyaltyGroup.getLoyaltyGroupId()) continue;
                this.cbLoyaltyGroup.getSelectionModel().select((Object)loyaltyGroup);
            }
        } else {
            this.disableAllFields();
            this.tfPIB.requestFocus();
            this.tfCurrentLimit.setText("");
            LoyalitySettings lSettings = new LoyalitySettings();
            this.tfLimit.setText(lSettings.getActualByName(this.controller, "loyalty.limit.value"));
            this.tfVrednostKupovnogBoda.setText(lSettings.getActualByName(this.controller, "value.loyality.sales.point"));
            this.tfVrednostProdajnogBoda.setText(lSettings.getActualByName(this.controller, "value.loyality.buying.point"));
            this.tfNumberOfDays.setText("");
            this.cbActiveLimit.setSelected(false);
            this.cbLoyaltyGroup.getSelectionModel().select(0);
            this.tfPopust.setText(String.valueOf(((LoyaltyGroup)this.cbLoyaltyGroup.getSelectionModel().getSelectedItem()).getDefaultDiscount()));
            this.dpDateTo.setValue((Object)LocalDate.now());
        }
        if (this.controller.getLoyalitySettings().getActualByName(this.controller, "point.value.round").equals("false")) {
            this.tabAkcijaBodovi.setDisable(true);
        }
        if (this.controller.getLoyalitySettings().getActualByName(this.controller, "bill.number.discount.active").equals("false")) {
            this.tabAkcijaBrojKupovina.setDisable(true);
        }
        if (this.controller.getLoyalitySettings().getActualByName(this.controller, "loyalty.limit").equals("false")) {
            this.tabLimit.setDisable(true);
        }
        if (this.controller.getVrstaPrograma() == 4) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/master/css/trgovina/backofficeTrgovina.css");
        }
        this.tfBrojBodova.setDisable(true);
        this.tfTrenutniBrojKupovina.setDisable(true);
        this.rbYear.setSelected(true);
        this.days = 365;
        this.tfNumberOfDays.setText("1");
        if (this.tfName.isDisable()) {
            this.handler = new EventHandler<KeyEvent>(){

                public void handle(KeyEvent event) {
                    if (event.getCode() == KeyCode.ENTER) {
                        LoyalityNewDialogController.this.confirmPib();
                    }
                }
            };
            this.tfPIB.addEventHandler(KeyEvent.KEY_PRESSED, this.handler);
        }
        this.fillTableFP();
    }

    @Override
    public HashMap<String, Object> getParameter() {
        return null;
    }

    @Override
    public int getModalResult() {
        return 0;
    }

    @Override
    public void setModalResult(int modalResult) {
    }

    @FXML
    private void actionDodajPoene() {
        try {
            double poeni = this.round(Double.parseDouble(this.tfIznosRacuna.getText()), 0);
            Loyality loyality = new Loyality();
            loyality.setPoints(poeni + Double.parseDouble(this.tfBrojBodova.getText()));
            loyality.setLoyalityID(this.selectedPerson.getLoyality().getLoyalityID());
            loyality.updatePoints(this.controller.getSettings().getConnection());
            this.tfIznosRacuna.setText("");
            this.tfBrojBodova.setText("" + loyality.getPoints());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private double res(double x, double y) {
        return Settings.round(0.0 + (x - x % y) / y + x % y / y, 1);
    }

    private double round(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        long factor = (long)Math.pow(10.0, places);
        long tmp = Math.round(value *= (double)factor);
        return (double)tmp / (double)factor;
    }

    private void fillPersonData(Person person) {
        if (PersonType.getByName("Fizi\u010dko lice", this.controller).getPersonTypeID() == person.getPersonTypeID()) {
            this.tfFirstName.setText(person.getFirstName());
            this.tfLastName.setText(person.getLastName());
            this.tfPhone.setText(person.getPhone());
            this.tfEmail.setText(person.geteMail());
            if (person.getCode() != null) {
                this.tfCode.setText(person.getCode());
            } else {
                this.tfCode.setText("");
            }
            this.tfAddress.setText(person.getAddress());
            this.tfZip.setText(person.getZIP());
            this.tfCity.setText(person.getCity());
            this.tfPopust.setText("" + person.getDiscount());
            this.taNote.setText(person.getNote());
        } else {
            this.tfName.setText(person.getName());
            if (person.getCode() != null) {
                this.tfCompanyCardCode.setText(person.getCode());
            } else {
                this.tfCompanyCardCode.setText("");
            }
            this.tfCompanyAddress.setText(person.getAddress());
            this.tfPIB.setText(person.getPIB());
            this.tfMB.setText(person.getMB());
            this.tfCompanyZip.setText(person.getZIP());
            this.tfCompanyCity.setText(person.getCity());
            this.tfCompanyDiscount.setText("" + person.getDiscount());
            this.tfDetailsPrintNumber.setText(String.valueOf(person.getDetailsPrintNumber()));
            this.taCompanyNote.setText(person.getNote());
            if (person.getPhone() == null) {
                this.tfCompnyPhone.setText(" ");
            } else {
                this.tfCompnyPhone.setText(person.getPhone());
            }
            if (person.geteMail() == null) {
                this.tfCompanyEmail.setText(" ");
            } else {
                this.tfCompanyEmail.setText(person.geteMail());
            }
            this.tfCurrencyDays.setText(String.valueOf(person.getCurrencyPaymentDays()));
        }
        this.cbActive.setSelected(person.isActive());
        for (BuyerOfferPrice bop : BuyerOfferPrice.getList(this.controller.getObject().getObjectID(), this.controller.getSettings().getConnection())) {
            this.cbBuyerOfferPriceList.getItems().add((Object)bop);
        }
        if (person.getBuyerOfferPriceID() != 0L) {
            this.cbBuyerOfferPriceList.getSelectionModel().select((Object)BuyerOfferPrice.getOfferPrice(person.getBuyerOfferPriceID(), this.controller.getSettings().getConnection()));
        } else {
            this.cbBuyerOfferPriceList.getSelectionModel().select(0);
        }
        this.tfBrojKupovina.setText("" + person.getLoyality().getNumberEntry());
        this.tfTrenutniBrojKupovina.setText("" + person.getLoyality().getCurrentNumberEntry());
        this.tfPopustNaKupovine.setText("" + person.getLoyality().getDiscountEntry());
        this.cbVipLoyaltyPrice.setSelected(person.getLoyality().isVipLoyaltyPrice());
        this.tfBrojBodova.setText("" + person.getLoyality().getPoints());
        this.tfVrednostKupovnogBoda.setText("" + person.getLoyality().getBuyingPointsValue());
        this.tfVrednostProdajnogBoda.setText("" + person.getLoyality().getSellingPointsValue());
        this.period = person.getLoyality().getPeriodDays();
        if (!this.period.equals("")) {
            this.cbGodina.setSelected(person.getLoyality().getPeriodDays().endsWith("YEAR"));
            this.cbMesec.setSelected(person.getLoyality().getPeriodDays().endsWith("MONTH"));
            this.cbNedelja.setSelected(person.getLoyality().getPeriodDays().endsWith("WEEK"));
            if (person.getLoyality().getPeriodDays().startsWith("DAY")) {
                this.cbBrojDana.setSelected(true);
                this.tfBrojDana.setText(person.getLoyality().getPeriodDays().substring(3));
                this.tfBrojDana.setDisable(!this.cbBrojDana.isSelected());
            }
        }
    }

    private void fillLoyaltyData(long loyaltiId) {
        this.loyaltyLimit = LoyaltyLimit.getLoyaltyLimitByLoyaltyID(loyaltiId, this.controller);
        if (this.loyaltyLimit != null) {
            this.tfCurrentLimit.setText("" + this.loyaltyLimit.getCurrentValue());
            this.tfLimit.setText("" + this.loyaltyLimit.getLimitValue());
            this.tfNumberOfDays.setText("" + this.loyaltyLimit.getNumberOfDates());
            this.cbActiveLimit.setSelected(this.loyaltyLimit.isActive());
            this.dpDateTo.setValue((Object)Settings.fromDate(this.loyaltyLimit.getDateTo()));
        }
    }

    @FXML
    public void cancel(ActionEvent event) {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        ((Stage)((Node)event.getSource()).getScene().getWindow()).close();
    }

    @FXML
    public void post(ActionEvent event) {
        if (this.selectedPerson != null) {
            Person zamena = Person.getById(this.selectedPerson.getPersonID(), this.controller);
            Contact cPhone = Contact.getByPersonAndType(this.selectedPerson.getPersonID(), 1, this.controller.getSettings().getConnection());
            Contact cMobile = Contact.getByPersonAndType(this.selectedPerson.getPersonID(), 2, this.controller.getSettings().getConnection());
            Contact cEmail = Contact.getByPersonAndType(this.selectedPerson.getPersonID(), 4, this.controller.getSettings().getConnection());
            if (this.selectedPerson.getPersonTypeID() == 1) {
                this.selectedPerson.setPhone(this.tfPhone.getText().trim());
                this.selectedPerson.setAddress(this.tfAddress.getText().trim());
                this.selectedPerson.setFirstName(this.tfFirstName.getText());
                this.selectedPerson.setLastName(this.tfLastName.getText());
                this.selectedPerson.setActive(this.cbActive.isSelected());
                this.selectedPerson.setCode(this.tfCode.getText());
                this.selectedPerson.setCity(this.tfCity.getText());
                this.selectedPerson.setNote(this.taNote.getText());
                this.selectedPerson.seteMail(this.tfEmail.getText());
                this.selectedPerson.setZIP(this.tfZip.getText());
                this.selectedPerson.setDetailsPrintNumber(Integer.parseInt(this.tfDetailsPrintNumber.getText().trim()));
                this.selectedPerson.setPersonID(this.selectedPerson.getPersonID());
                try {
                    this.selectedPerson.setDiscount(Double.parseDouble(this.tfPopust.getText()));
                }
                catch (NumberFormatException e) {
                    this.selectedPerson.setDiscount(0.0);
                }
            } else {
                this.selectedPerson.setName(this.tfName.getText().trim());
                this.selectedPerson.setAddress(this.tfCompanyAddress.getText().trim());
                this.selectedPerson.setZIP(this.tfCompanyZip.getText().trim());
                this.selectedPerson.setCity(this.tfCompanyCity.getText().trim());
                this.selectedPerson.setPIB(this.tfPIB.getText().trim());
                this.selectedPerson.setMB(this.tfMB.getText().trim());
                this.selectedPerson.setCode(this.tfCompanyCardCode.getText().trim());
                this.selectedPerson.setPhone(this.tfCompnyPhone.getText().trim());
                this.selectedPerson.setDetailsPrintNumber(Integer.parseInt(this.tfDetailsPrintNumber.getText().trim()));
                this.selectedPerson.seteMail(this.tfCompanyEmail.getText().trim());
                this.selectedPerson.setNote(this.taCompanyNote.getText());
                this.selectedPerson.setTaxExempt(this.cbTaxExampt.isSelected());
                if (((BuyerOfferPrice)this.cbBuyerOfferPriceList.getSelectionModel().getSelectedItem()).getBuyerOfferPriceID() != null) {
                    this.selectedPerson.setBuyerOfferPriceID(((BuyerOfferPrice)this.cbBuyerOfferPriceList.getSelectionModel().getSelectedItem()).getBuyerOfferPriceID());
                }
                this.selectedPerson.setCurrencyPaymentDays(Integer.parseInt(this.tfCurrencyDays.getText().trim()));
                try {
                    this.selectedPerson.setDiscount(Double.parseDouble(this.tfCompanyDiscount.getText()));
                }
                catch (NumberFormatException e) {
                    this.selectedPerson.setDiscount(0.0);
                }
            }
            try {
                this.selectedPerson.setBuyerOfferPriceID(((BuyerOfferPrice)this.cbBuyerOfferPriceList.getSelectionModel().getSelectedItem()).getBuyerOfferPriceID());
            }
            catch (NullPointerException e) {
                this.selectedPerson.setBuyerOfferPriceID(-1L);
            }
            this.selectedPerson.update(this.controller.getUser(), this.controller.getSettings().getConnection());
            Loyality l = new Loyality();
            l.setPersonID(this.selectedPerson.getPersonID());
            l.setCardNumber(this.selectedPerson.getCode());
            l.setDiscount(this.selectedPerson.getDiscount());
            l.setActive(this.selectedPerson.isActive());
            l.setBuyingPointsValue(Double.parseDouble(this.tfVrednostKupovnogBoda.getText()));
            l.setSellingPointsValue(Double.parseDouble(this.tfVrednostProdajnogBoda.getText()));
            l.setNumberEntry(Integer.parseInt(this.tfBrojKupovina.getText()));
            l.setDiscountEntry(Double.parseDouble(this.tfPopustNaKupovine.getText()));
            l.setVipLoyaltyPrice(false);
            l.setLoyalityID(this.selectedPerson.getLoyality().getLoyalityID());
            l.setNote(this.selectedPerson.getNote());
            l.setLoyaltyGroupId(((LoyaltyGroup)this.cbLoyaltyGroup.getSelectionModel().getSelectedItem()).getLoyaltyGroupId());
            l.setPeriodDays(this.period.contains("DAY") ? "DAY".concat(this.tfBrojDana.getText().trim()) : this.period);
            l.update(this.controller.getSettings().getConnection());
            try {
                if (this.cbActiveLimit.isSelected()) {
                    this.loyaltyLimit.setLoyaltyId(this.selectedPerson.getLoyality().getLoyalityID());
                    this.loyaltyLimit.setLimitValue(Double.parseDouble(this.tfLimit.getText()));
                    this.loyaltyLimit.setCurrentValue(this.loyaltyLimit.getCurrentValue());
                    this.loyaltyLimit.setDateTo(Settings.fromLocalDate(((LocalDate)this.dpDateTo.getValue()).plusDays(this.days)));
                    this.loyaltyLimit.setNumberOfDates(this.days);
                    this.loyaltyLimit.setActive(this.cbActiveLimit.isSelected());
                    this.loyaltyLimit.update(this.controller);
                }
                cPhone.setContactID(cPhone.getContactID());
                cPhone.setPersonID(this.selectedPerson.getPersonID());
                cPhone.setContact(this.tfPhone.getText());
                cPhone.setActive(true);
                cPhone.setSysUserAddID(this.controller.getUser().getUserID());
                cPhone.setContactTypeID(1);
                cPhone.update(this.controller);
                cMobile.setPersonID(this.selectedPerson.getPersonID());
                cMobile.setContact(this.tfPhone.getText());
                cMobile.setActive(true);
                cMobile.setSysUserAddID(this.controller.getUser().getUserID());
                cMobile.setContactTypeID(2);
                cMobile.setContactID(cMobile.getContactID());
                cMobile.update(this.controller);
                cEmail.setPersonID(this.selectedPerson.getPersonID());
                cEmail.setContact(this.tfEmail.getText());
                cEmail.setActive(true);
                cEmail.setSysUserAddID(this.controller.getUser().getUserID());
                cEmail.setContactTypeID(4);
                cEmail.setContactID(cEmail.getContactID());
                cEmail.update(this.controller);
            }
            catch (NullPointerException e) {
                if (this.cbActiveLimit.isSelected()) {
                    LoyaltyLimit loyaltyL = new LoyaltyLimit();
                    loyaltyL.setLoyaltyId(this.selectedPerson.getLoyality().getLoyalityID());
                    loyaltyL.setDateTo(Settings.fromLocalDate(((LocalDate)this.dpDateTo.getValue()).plusDays(this.days)));
                    loyaltyL.setLimitValue(Double.parseDouble(this.tfLimit.getText()));
                    loyaltyL.setNumberOfDates(this.days);
                    loyaltyL.setActive(this.cbActiveLimit.isSelected());
                    loyaltyL.insert(this.controller);
                }
                Contact cPhone1 = new Contact();
                cPhone1.setActive(true);
                cPhone1.setContact(this.tfPhone.getText());
                cPhone1.setPersonID(this.selectedPerson.getPersonID());
                cPhone1.setSysUserAddID(this.controller.getUser().getUserID());
                cPhone1.setContactTypeID(1);
                cPhone1.insert(this.controller);
                Contact cMobile1 = new Contact();
                cMobile1.setActive(true);
                cMobile1.setContact(this.tfPhone.getText());
                cMobile1.setPersonID(this.selectedPerson.getPersonID());
                cMobile1.setSysUserAddID(this.controller.getUser().getUserID());
                cMobile1.setContactTypeID(2);
                cMobile1.insert(this.controller);
                Contact cEmail1 = new Contact();
                cEmail1.setActive(true);
                cEmail1.setContact(this.tfEmail.getText());
                cEmail1.setPersonID(this.selectedPerson.getPersonID());
                cEmail1.setSysUserAddID(this.controller.getUser().getUserID());
                cEmail1.setContactTypeID(4);
                cEmail1.insert(this.controller);
            }
        } else {
            this.selectedPerson = new Person();
            if (this.pressedButton.getText().equals("Novi komitent")) {
                this.selectedPerson.setPersonTypeID(1);
                this.selectedPerson.setPersonCategoryID(2);
                this.selectedPerson.setPersonVatTypeID(1);
                this.selectedPerson.setPhone(this.tfPhone.getText().trim());
                this.selectedPerson.setAddress(this.tfAddress.getText().trim());
                this.selectedPerson.setFirstName(this.tfFirstName.getText());
                this.selectedPerson.setLastName(this.tfLastName.getText());
                this.selectedPerson.setName("");
                this.selectedPerson.setCity(this.tfCity.getText());
                this.selectedPerson.setZIP(this.tfZip.getText());
                this.selectedPerson.setActive(true);
                this.selectedPerson.setSysUserAddID(this.controller.getUser().getUserID());
                this.selectedPerson.setCode(this.tfCode.getText());
                this.selectedPerson.seteMail(this.tfEmail.getText());
                this.selectedPerson.setNote(this.taNote.getText());
                try {
                    this.selectedPerson.setDiscount(Double.parseDouble(this.tfPopust.getText()));
                }
                catch (NumberFormatException e) {
                    this.selectedPerson.setDiscount(0.0);
                }
                try {
                    this.selectedPerson.setBuyerOfferPriceID(((BuyerOfferPrice)this.cbBuyerOfferPriceList.getSelectionModel().getSelectedItem()).getBuyerOfferPriceID());
                }
                catch (NullPointerException e) {
                    this.selectedPerson.setBuyerOfferPriceID(-1L);
                }
            } else {
                this.selectedPerson.setPersonTypeID(2);
                this.selectedPerson.setPersonCategoryID(2);
                this.selectedPerson.setPersonVatTypeID(1);
                this.selectedPerson.setPhone(this.tfCompnyPhone.getText().trim());
                this.selectedPerson.setAddress(this.tfCompanyAddress.getText().trim());
                this.selectedPerson.setPIB(this.tfPIB.getText().trim());
                this.selectedPerson.setMB(this.tfMB.getText().trim());
                this.selectedPerson.setName(this.tfName.getText());
                this.selectedPerson.setCity(this.tfCompanyCity.getText());
                this.selectedPerson.setZIP(this.tfCompanyZip.getText());
                this.selectedPerson.setActive(true);
                this.selectedPerson.setSysUserAddID(this.controller.getUser().getUserID());
                this.selectedPerson.setCode(this.tfCompanyCardCode.getText());
                this.selectedPerson.seteMail(this.tfCompanyEmail.getText());
                this.selectedPerson.setNote(this.taCompanyNote.getText());
                this.selectedPerson.setCurrencyPaymentDays(Integer.parseInt(this.tfCurrencyDays.getText().trim()));
                this.selectedPerson.setTaxExempt(this.cbTaxExampt.isSelected());
                try {
                    this.selectedPerson.setDiscount(Double.parseDouble(this.tfCompanyDiscount.getText()));
                }
                catch (NumberFormatException e) {
                    this.selectedPerson.setDiscount(0.0);
                }
                try {
                    this.selectedPerson.setBuyerOfferPriceID(((BuyerOfferPrice)this.cbBuyerOfferPriceList.getSelectionModel().getSelectedItem()).getBuyerOfferPriceID());
                }
                catch (NullPointerException e) {
                    this.selectedPerson.setBuyerOfferPriceID(-1L);
                }
                this.selectedPerson.setDetailsPrintNumber(Integer.parseInt(this.tfDetailsPrintNumber.getText().trim()));
            }
            this.selectedPerson.insert(this.controller.getUser(), this.controller.getSettings().getConnection());
            this.addLoyaliti(this.selectedPerson);
            Contact cPhone = new Contact();
            cPhone.setActive(true);
            cPhone.setContact(this.tfPhone.getText());
            cPhone.setPersonID(this.selectedPerson.getPersonID());
            cPhone.setSysUserAddID(this.controller.getUser().getUserID());
            cPhone.setContactTypeID(1);
            cPhone.insert(this.controller);
            Contact cMobile = new Contact();
            cMobile.setActive(true);
            cMobile.setContact(this.tfPhone.getText());
            cMobile.setPersonID(this.selectedPerson.getPersonID());
            cMobile.setSysUserAddID(this.controller.getUser().getUserID());
            cMobile.setContactTypeID(2);
            cMobile.insert(this.controller);
            Contact cEmail = new Contact();
            cEmail.setActive(true);
            cEmail.setContact(this.tfEmail.getText());
            cEmail.setPersonID(this.selectedPerson.getPersonID());
            cEmail.setSysUserAddID(this.controller.getUser().getUserID());
            cEmail.setContactTypeID(4);
            cEmail.insert(this.controller);
        }
        this.doLoyalitFinancialDiscount(this.selectedPerson);
        this.parameter.put("person", this.selectedPerson);
        this.modalResult = ScreensController.MODAL_RESULT_OK;
        ((Stage)((Node)event.getSource()).getScene().getWindow()).close();
    }

    private void fillTableFP() {
        if (this.selectedPerson != null) {
            this.tableFP.setItems(FinancialDiscount.getFinancialDiscountsList(this.controller));
            this.loyaltyFinancialDiscountList = LoyaltyFinancialDiscount.getListByLoyalty(this.selectedPerson.getLoyality().getLoyalityID(), this.controller);
        } else {
            this.loyaltyFinancialDiscountList = FXCollections.observableArrayList();
            this.tableFP.setItems(FinancialDiscount.getFinancialDiscountsList(this.controller));
        }
    }

    @FXML
    private void confirmPib() {
        Connection connection = this.controller.getSettings().getConnection();
        Person p = Person.getByPIB(this.tfPIB.getText(), connection);
        if (p != null) {
            String name = p.getName();
            if (p.getPersonCategoryID() == 4 || p.getPersonCategoryID() == 7) {
                String categoryString = p.getPersonCategoryID() == 4 ? "firma." : "gotovinski kupac.";
                int result = this.controller.yesNoDialog("Kupac " + name + " postoji u bazi ", "Kupac sa unetim pibom ve\u0107 postoji u bazi i evidentiran je " + categoryString + " Da li \u017eelite da omogu\u0107ite kupcu kupovinu preko Loyaliti programa ", this.rootPane.getScene().getWindow());
                if (result == ScreensController.MODAL_RESULT_YES) {
                    p.setPersonCategoryID(2);
                    p.setBuyerOfferPriceID(-1L);
                    p.update(this.controller.getUser(), connection);
                    this.addLoyaliti(p);
                    this.doLoyalitFinancialDiscount(p);
                }
            } else if (p.getPersonCategoryID() == 2) {
                this.controller.alert("Kupac " + name + " postoji u bazi", "Kupac sa unetim pibom ve\u0107 postoji u bazi ", this.rootPane.getScene().getWindow());
                this.parameter.put("person", p);
                ((Stage)this.btnConfirmPib.getScene().getWindow()).close();
            }
        } else {
            this.enableAllFields();
        }
    }

    private void disableAllFields() {
        this.tfName.setDisable(true);
        this.tfCompanyAddress.setDisable(true);
        this.tfCompanyZip.setDisable(true);
        this.tfCompanyCity.setDisable(true);
        this.tfCompanyDiscount.setDisable(true);
        this.tfCompanyEmail.setDisable(true);
        this.taCompanyNote.setDisable(true);
        this.tfCompnyPhone.setDisable(true);
        this.tfCurrencyDays.setDisable(true);
        this.tfMB.setDisable(true);
        this.tfDetailsPrintNumber.setDisable(true);
        this.tfCompanyCardCode.setDisable(true);
        this.cbTaxExampt.setDisable(true);
        if (this.pressedButton.getText().trim().equals("Nova firma")) {
            this.btnConfirm.setDisable(true);
        }
        this.btnConfirmPib.setDisable(false);
        this.tfPIB.requestFocus();
    }

    private void enableAllFields() {
        this.tfName.setDisable(false);
        this.tfCompanyAddress.setDisable(false);
        this.tfCompanyZip.setDisable(false);
        this.tfCompanyCity.setDisable(false);
        this.tfCompanyDiscount.setDisable(false);
        this.tfCompanyEmail.setDisable(false);
        this.taCompanyNote.setDisable(false);
        this.tfCompnyPhone.setDisable(false);
        this.tfMB.setDisable(false);
        this.tfDetailsPrintNumber.setDisable(false);
        this.tfCompanyCardCode.setDisable(false);
        this.tfCurrencyDays.setDisable(false);
        this.lblmessage.setVisible(false);
        this.cbTaxExampt.setDisable(false);
        this.btnConfirm.setDisable(false);
        this.btnConfirmPib.setDisable(true);
        this.tfPIB.removeEventHandler(KeyEvent.KEY_PRESSED, this.handler);
    }

    private void addLoyaliti(Person selectedPerson) {
        Loyality l = new Loyality();
        l.setPersonID(selectedPerson.getPersonID());
        l.setCardNumber(selectedPerson.getCode());
        l.setActive(selectedPerson.isActive());
        l.setDiscount(selectedPerson.getDiscount());
        l.setSysDTCreated(selectedPerson.getSysDTCreated());
        l.setSysDTEdit(selectedPerson.getSysDTEdit());
        l.setSysUserAddID(selectedPerson.getSysUserAddID());
        l.setSysUserEditID(selectedPerson.getSysUserEditID());
        l.setVipLoyaltyPrice(false);
        if (this.pressedButton.getText().equals("Novi komitent")) {
            l.setNote(this.taNote.getText().trim());
        } else {
            l.setNote(this.taCompanyNote.getText().trim());
        }
        l.setLoyaltyGroupId(((LoyaltyGroup)this.cbLoyaltyGroup.getSelectionModel().getSelectedItem()).getLoyaltyGroupId());
        if (this.period != null && !this.period.equals("")) {
            l.setPeriodDays(this.period.contains("DAY") ? this.period.concat(this.tfBrojDana.getText().trim()) : this.period);
        } else {
            l.setPeriodDays("YEAR");
        }
        l.insert(this.controller);
        selectedPerson.setLoyality(l);
        LoyaltyLimit loyaltyLimit = new LoyaltyLimit();
        loyaltyLimit.setLoyaltyId(l.getLoyalityID());
        loyaltyLimit.setDateTo(Settings.fromLocalDate(((LocalDate)this.dpDateTo.getValue()).plusDays(this.days)));
        LoyalitySettings lSettings = new LoyalitySettings();
        loyaltyLimit.setLimitValue(Double.parseDouble(lSettings.getActualByName(this.controller, "loyalty.limit.value")));
        loyaltyLimit.setNumberOfDates(this.days);
        loyaltyLimit.setActive(this.cbActiveLimit.isSelected());
        loyaltyLimit.insert(this.controller);
    }

    private void doLoyalitFinancialDiscount(Person selectedPerson) {
        for (LoyaltyFinancialDiscount loyaltyFinancialDiscount : LoyaltyFinancialDiscount.getListByLoyalty(selectedPerson.getLoyality().getLoyalityID(), this.controller)) {
            loyaltyFinancialDiscount.delete(this.controller);
        }
        for (LoyaltyFinancialDiscount loyaltyFinancialDiscount : this.loyaltyFinancialDiscountList) {
            loyaltyFinancialDiscount.setLoyaltyID(selectedPerson.getLoyality().getLoyalityID());
            loyaltyFinancialDiscount.insert(this.controller);
        }
    }
}

