/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.adapter.JavaBeanStringPropertyBuilder;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.person.Contact;
import rs.petcom.master.dal.person.ContactType;
import rs.petcom.master.dal.person.Loyality;
import rs.petcom.master.dal.person.LoyaltyGroup;
import rs.petcom.master.dal.person.LoyaltyLimit;
import rs.petcom.master.dal.person.Person;
import rs.petcom.master.dal.person.PersonCategoryEnum;
import rs.petcom.master.dal.person.PersonType;

public class LoyalityController
implements ControlledScreen {
    ScreensController controller;
    ObservableList<Loyality> loyalityList = FXCollections.observableArrayList();
    ObservableList<ContactType> contactTypeList = FXCollections.observableArrayList();
    Person selectedPerson;
    PersonCategoryEnum pce;
    ComboBox<LoyaltyGroup> combo;
    @FXML
    private BorderPane rootPane;
    @FXML
    private TextField tfFilter;
    @FXML
    private TableView<Loyality> tvPerson;
    @FXML
    private TableColumn<Loyality, String> tcName;
    @FXML
    private TableColumn<Loyality, String> tcPIB;
    @FXML
    private TableColumn<Loyality, String> tcMB;
    @FXML
    private TableColumn<Loyality, String> tcAdresa;
    @FXML
    private TableColumn<Loyality, String> tcTelefon;
    @FXML
    private RadioButton rbPerson;
    @FXML
    private RadioButton rbCompany;
    @FXML
    private TableColumn<Loyality, ComboBox<LoyaltyGroup>> tcLoyaltyGroup;
    @FXML
    private ComboBox<LoyaltyGroup> cbLoyaltyGroup;

    @Override
    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    @Override
    public void init() {
        this.contactTypeList = ContactType.getListSpecific(this.controller.getSettings().getConnection());
        this.tfFilter.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (oldValue != null && newValue.length() < oldValue.length()) {
                    LoyalityController.this.loadPersonsList();
                }
                String value = newValue.toLowerCase();
                ObservableList subentries = FXCollections.observableArrayList();
                long count = LoyalityController.this.tvPerson.getColumns().stream().count();
                block0: for (int i = 0; i < LoyalityController.this.tvPerson.getItems().size(); ++i) {
                    int j = 0;
                    while ((long)j < count) {
                        String entry = "" + ((TableColumn)LoyalityController.this.tvPerson.getColumns().get(j)).getCellData(i);
                        if (entry.toLowerCase().contains(value)) {
                            subentries.add(LoyalityController.this.tvPerson.getItems().get(i));
                            continue block0;
                        }
                        ++j;
                    }
                }
                LoyalityController.this.tvPerson.setItems(subentries);
            }
        });
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/tableTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
    }

    @Override
    public void setParameter(Object parameter) {
        HashMap mapa = (HashMap)parameter;
        this.pce = (PersonCategoryEnum)((Object)mapa.get("personCategory"));
        this.fillLoyaltyGroupComboBox();
        this.rbCompany.setSelected(true);
        this.loadPersonsList();
        this.rbCompany.getToggleGroup().selectedToggleProperty().addListener((obsrvableValue, old_toggle, new_toggle) -> {
            if (this.rbCompany.isSelected()) {
                this.tcMB.setVisible(true);
                this.tcPIB.setVisible(true);
            } else {
                this.tcMB.setVisible(false);
                this.tcPIB.setVisible(false);
            }
            this.loadPersonsList();
        });
    }

    @Override
    public Object getParameter() {
        return null;
    }

    public void initialize() {
        this.tvPerson.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Loyality>(){

            public void changed(ObservableValue<? extends Loyality> observable, Loyality oldValue, Loyality newValue) {
                if (LoyalityController.this.tvPerson.getSelectionModel().getSelectedItem() != null) {
                    LoyalityController.this.selectedPerson = Person.getById(newValue.getPersonID(), LoyalityController.this.controller);
                }
            }
        });
        this.cbLoyaltyGroup.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                LoyalityController.this.loadPersonsList();
            }
        });
    }

    @FXML
    public void personNew(ActionEvent event) {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("controller", this.controller);
        hm.put("selectedPerson", null);
        hm.put("sourceButton", event.getSource());
        this.controller.showModalDialog("Kreiranje novog loyality-ja", ScreensController.DIALOG_ADD_LOYALITY, hm, (Window)((Stage)((Node)event.getSource()).getScene().getWindow()));
        this.tvPerson.getSelectionModel().clearSelection();
        this.loadPersonsList();
        this.tfFilter.setText("");
    }

    @FXML
    private void personDelete(ActionEvent event) {
        if (this.selectedPerson != null) {
            Contact.delete(this.selectedPerson.getPersonID(), this.controller.getSettings().getConnection());
            LoyaltyLimit.delete(this.selectedPerson.getLoyality().getLoyalityID(), this.controller.getSettings().getConnection());
            Loyality.delete(this.selectedPerson.getPersonID(), this.controller.getSettings().getConnection());
            this.selectedPerson.delete(this.selectedPerson.getPersonID(), this.controller.getSettings().getConnection());
        } else {
            this.controller.alert("Brisanje stalnog kupca", "Morate odabrati stalnog kupca iz tabele ako zelite da ga obrisete", this.rootPane.getScene().getWindow());
        }
        this.loadPersonsList();
        this.tfFilter.setText("");
    }

    @FXML
    private void personCommit(ActionEvent event) {
        if (this.selectedPerson != null) {
            HashMap<String, Object> hm = new HashMap<String, Object>();
            hm.put("controller", this.controller);
            hm.put("selectedPerson", this.selectedPerson);
            hm.put("sourceButton", event.getSource());
            this.controller.showModalDialog("Kreiranje novog loyality-ja", ScreensController.DIALOG_ADD_LOYALITY, hm, (Window)((Stage)((Node)event.getSource()).getScene().getWindow()));
            this.tvPerson.getSelectionModel().clearSelection();
        } else {
            this.controller.alert("Odabir stalnog kupca", "Morate odabrati stalnog kupca iz tabele ako zelite izmene", this.rootPane.getScene().getWindow());
        }
        this.loadPersonsList();
        this.tfFilter.setText("");
    }

    @FXML
    private void excelAction() {
        this.onBtnSave();
    }

    private void onBtnSave() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Sa\u010duvaj kao...");
        fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("EXCEL files (*.xlsx)", new String[]{"*.XLSX"}), new FileChooser.ExtensionFilter("CSV files (*.csv)", new String[]{"*.CSV"})});
        File file = fileChooser.showSaveDialog(this.rootPane.getScene().getWindow());
        if (fileChooser.getSelectedExtensionFilter() != null && fileChooser.getSelectedExtensionFilter().getExtensions() != null) {
            int pitanje;
            List selectedExtension = fileChooser.getSelectedExtensionFilter().getExtensions();
            int extensionLength = 0;
            if (selectedExtension.contains("*.CSV")) {
                extensionLength = 4;
            }
            if (selectedExtension.contains("*.XLSX")) {
                extensionLength = 5;
            }
            ObservableList personsList = FXCollections.observableArrayList();
            for (Loyality loyality : this.tvPerson.getItems()) {
                Person person = Person.getById(loyality.getPersonID(), this.controller);
                personsList.add((Object)person);
            }
            String nameWithoutExt = file.getName().substring(0, file.getName().length() - extensionLength);
            String pathWithoutExt = file.getAbsolutePath().substring(0, file.getAbsolutePath().length() - extensionLength);
            String pathWithoutName = pathWithoutExt.substring(0, pathWithoutExt.lastIndexOf(nameWithoutExt) - 1);
            if (selectedExtension.contains("*.CSV")) {
                Person.getPersonToExcel(this.controller, (ObservableList<Person>)personsList, nameWithoutExt, pathWithoutName);
            }
            if (selectedExtension.contains("*.XLSX")) {
                Person.getPersonToExcel(this.controller, (ObservableList<Person>)personsList, nameWithoutExt, pathWithoutName);
            }
            if ((pitanje = this.controller.yesNoDialog("Pitanje", "Da li zelite da prikazete izvestaj? (Do you wanna show report?)", this.rootPane.getScene().getWindow())) == 1) {
                FileChooser fileOpenChooser = new FileChooser();
                fileOpenChooser.setTitle("Open");
                FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("XML files (*.xlsx)", new String[]{"*.xlsx", "*.xls"});
                fileOpenChooser.getExtensionFilters().add((Object)extFilter);
                File userDirectory = new File(pathWithoutName);
                if (!userDirectory.canRead()) {
                    userDirectory = new File("c:/");
                }
                fileOpenChooser.setInitialDirectory(userDirectory);
                File chosenFile = fileOpenChooser.showOpenDialog(null);
                this.controller.printFileFromPDF(chosenFile);
            }
        }
        Task<Boolean> task = new Task<Boolean>(){

            protected Boolean call() throws Exception {
                return false;
            }
        };
        task.run();
    }

    private void loadPersonsList() {
        this.tcName.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<Loyality, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<Loyality, String> param) {
                try {
                    if (((Loyality)param.getValue()).getPerson().getPersonTypeID() == PersonType.getByName("Fizi\u010dko lice", LoyalityController.this.controller).getPersonTypeID()) {
                        return new JavaBeanStringPropertyBuilder().bean((Object)Person.getById(((Loyality)param.getValue()).getPersonID(), LoyalityController.this.controller)).name("names1").build();
                    }
                    return new JavaBeanStringPropertyBuilder().bean((Object)Person.getById(((Loyality)param.getValue()).getPersonID(), LoyalityController.this.controller)).name("Name").build();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        });
        this.tcAdresa.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<Loyality, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<Loyality, String> param) {
                try {
                    return new JavaBeanStringPropertyBuilder().bean((Object)Person.getById(((Loyality)param.getValue()).getPersonID(), LoyalityController.this.controller)).name("Address").build();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        });
        this.tcPIB.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<Loyality, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<Loyality, String> param) {
                try {
                    return new JavaBeanStringPropertyBuilder().bean((Object)Person.getById(((Loyality)param.getValue()).getPersonID(), LoyalityController.this.controller)).name("PIB").build();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        });
        this.tcMB.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<Loyality, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<Loyality, String> param) {
                try {
                    return new JavaBeanStringPropertyBuilder().bean((Object)Person.getById(((Loyality)param.getValue()).getPersonID(), LoyalityController.this.controller)).name("MB").build();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        });
        this.tcTelefon.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<Loyality, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<Loyality, String> param) {
                try {
                    return new JavaBeanStringPropertyBuilder().bean((Object)Person.getById(((Loyality)param.getValue()).getPersonID(), LoyalityController.this.controller)).name("phone").build();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        });
        this.tcLoyaltyGroup.setCellValueFactory((Callback)new PropertyValueFactory("LoyaltyGroup"));
        this.tcLoyaltyGroup.setCellValueFactory(param -> {
            this.combo = new ComboBox();
            this.combo.getItems().addAll(LoyaltyGroup.getLoyaltyGroupList(this.controller));
            for (LoyaltyGroup loyaltyGroup : this.combo.getItems()) {
                if (((Loyality)param.getValue()).getLoyaltyGroupId() != loyaltyGroup.getLoyaltyGroupId()) continue;
                this.combo.getSelectionModel().select((Object)loyaltyGroup);
            }
            this.combo.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<LoyaltyGroup>(){

                public void changed(ObservableValue<? extends LoyaltyGroup> observable, LoyaltyGroup oldValue, LoyaltyGroup newValue) {
                    ((Loyality)param.getValue()).setLoyaltyGroupId(newValue.getLoyaltyGroupId());
                    if (newValue != null) {
                        ((Loyality)param.getValue()).setLoyaltyGroupId(newValue.getLoyaltyGroupId());
                        ((Loyality)param.getValue()).update(LoyalityController.this.controller.getSettings().getConnection());
                    }
                }
            });
            return new SimpleObjectProperty(this.combo);
        });
        ObservableList personsList = FXCollections.observableArrayList();
        int personTypeId = this.rbCompany.isSelected() ? 2 : 1;
        for (Person person : Person.getLoyalityListWithFilter(this.controller.getSettings().getConnection(), 2, personTypeId, (LoyaltyGroup)this.cbLoyaltyGroup.getSelectionModel().getSelectedItem())) {
            Loyality loyality = Loyality.getByPerson(person, this.controller);
            personsList.add((Object)loyality);
        }
        this.tvPerson.setItems(personsList);
    }

    private void fillLoyaltyGroupComboBox() {
        LoyaltyGroup loyaltyGroup = new LoyaltyGroup();
        loyaltyGroup.setLoyaltyGroupId(-1L);
        loyaltyGroup.setName("Sve grupe");
        this.cbLoyaltyGroup.getItems().add((Object)loyaltyGroup);
        for (LoyaltyGroup lGroup : LoyaltyGroup.getLoyaltyGroupList(this.controller)) {
            this.cbLoyaltyGroup.getItems().add((Object)lGroup);
        }
        this.cbLoyaltyGroup.getSelectionModel().selectFirst();
    }
}

