/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.util.Callback;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.IdCard;
import rs.petcom.master.dal.PointOfSale;
import rs.petcom.master.dal.User;
import rs.petcom.renameconnection.ChangeConnection;

public class KorisniciSistemaController
implements ControlledScreen {
    private ScreensController controller;
    private ObservableList<User> userList = FXCollections.observableArrayList();
    private rs.petcom.master.dal.Object selectedObject;
    @FXML
    private BorderPane rootPane;
    @FXML
    private ComboBox<rs.petcom.master.dal.Object> cbObjekat;
    @FXML
    private Label lblObjekat;
    @FXML
    private ComboBox<PointOfSale> cbPos;
    @FXML
    private TextField tfFilter;
    @FXML
    private CheckBox cbActive;
    @FXML
    private TableView<User> tableUser;
    @FXML
    private TableColumn<User, String> columnNaziv;

    @Override
    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    @Override
    public void init() {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/tableTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.columnNaziv.setCellValueFactory((Callback)new PropertyValueFactory("UserName"));
        this.objekatChange();
    }

    @Override
    public void setParameter(Object parameter) {
    }

    @Override
    public Object getParameter() {
        return null;
    }

    public void initialize() {
        this.columnNaziv.setCellValueFactory((Callback)new PropertyValueFactory("UserName"));
        this.tfFilter.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (oldValue != null && newValue.length() < oldValue.length()) {
                    KorisniciSistemaController.this.objekatChange();
                    KorisniciSistemaController.this.posChange();
                }
                String value = newValue.toLowerCase();
                ObservableList subentries = FXCollections.observableArrayList();
                long count = KorisniciSistemaController.this.tableUser.getColumns().stream().count();
                block0: for (int i = 0; i < KorisniciSistemaController.this.tableUser.getItems().size(); ++i) {
                    int j = 0;
                    while ((long)j < count) {
                        String entry = "" + ((TableColumn)KorisniciSistemaController.this.tableUser.getColumns().get(j)).getCellData(i);
                        if (entry.toLowerCase().contains(value)) {
                            subentries.add(KorisniciSistemaController.this.tableUser.getItems().get(i));
                            continue block0;
                        }
                        ++j;
                    }
                }
                KorisniciSistemaController.this.tableUser.setItems(subentries);
            }
        });
    }

    @FXML
    private void userNew(ActionEvent event) {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("controller", this.controller);
        int model = this.controller.showModalDialog("Novi korisnik", ScreensController.USER_SETUP, hm, this.rootPane.getScene().getWindow());
        if (model == ScreensController.MODAL_RESULT_OK) {
            this.objekatChange();
        }
    }

    @FXML
    private void userDelete(ActionEvent event) {
        try {
            this.controller.getSettings().setConnection(ChangeConnection.getConnectionAdmin(this.controller));
            User user = (User)this.tableUser.getSelectionModel().getSelectedItem();
            user.deleteAllUserPosMenu(user.getUserID(), this.controller.getSettings().getConnection());
            user.deleteUserRoles(user.getUserID(), this.controller.getSettings().getConnection());
            user.deleteUserPOS(user.getUserID(), this.controller.getSettings().getConnection());
            IdCard.deleteIdCardByUserId(user.getUserID(), this.controller.getSettings().getConnection());
            ((User)this.tableUser.getSelectionModel().getSelectedItem()).deleteUser(this.controller.getSettings().getConnection());
            this.objekatChange();
            this.controller.getSettings().setConnection(ChangeConnection.getConnectionUser(this.controller));
        }
        catch (NullPointerException e) {
            this.controller.alert("Obavestenje", "Morate selektovati korisnika iz tabele", this.controller.getRoot().getScene().getWindow());
        }
    }

    @FXML
    private void posChange() {
        ObservableList<User> users = FXCollections.observableArrayList();
        if (this.cbPos.getSelectionModel() != null && this.cbPos.getSelectionModel().getSelectedItem() != null && ((PointOfSale)this.cbPos.getSelectionModel().getSelectedItem()).getPointOfSaleID() != -1) {
            PointOfSale pos = (PointOfSale)this.cbPos.getSelectionModel().getSelectedItem();
            for (User u : this.userList) {
                for (PointOfSale point : u.getPointsOfSale()) {
                    if (point.getPointOfSaleID() != pos.getPointOfSaleID() || point.isActive() != this.cbActive.isSelected() || users.contains((Object)u)) continue;
                    users.add((Object)u);
                }
            }
        } else {
            users = User.getUsersListByObjectId(this.controller.getSettings().getConnection(), this.selectedObject.getObjectID());
        }
        this.tableUser.setItems(users);
    }

    @FXML
    private void cbActiveChange() {
        this.posChange();
    }

    @FXML
    private void userChangePOS(ActionEvent event) {
        if (this.tableUser.getSelectionModel().getSelectedItem() != null) {
            HashMap<String, Object> hm = new HashMap<String, Object>();
            hm.put("controller", this.controller);
            hm.put("connection", this.controller.getSettings().getConnection());
            hm.put("user", this.tableUser.getSelectionModel().getSelectedItem());
            int model = this.controller.showModalDialog("Promena mesta prodaje korisnika", ScreensController.USER_SETUP, hm, this.rootPane.getScene().getWindow());
            if (model == ScreensController.MODAL_RESULT_OK) {
                this.objekatChange();
            }
        } else {
            this.controller.alert("Obavestenje", "Morate odabrati KORISNIKA ", this.rootPane.getScene().getWindow());
        }
    }

    @FXML
    private void objekatChange() {
        this.cbObjekat.getItems().clear();
        this.cbPos.getItems().clear();
        ArrayList<Object> list = new ArrayList();
        ObservableList<rs.petcom.master.dal.Object> objList = rs.petcom.master.dal.Object.getList(this.controller.getSettings().getConnection());
        if (objList.size() == 1) {
            this.selectedObject = (rs.petcom.master.dal.Object)objList.get(0);
            this.cbObjekat.setVisible(false);
            this.lblObjekat.setText(((rs.petcom.master.dal.Object)objList.get(0)).getName());
            list = PointOfSale.getPosList((rs.petcom.master.dal.Object)objList.get(0), this.controller.getSettings().getConnection());
            this.userList = User.getUsersListByObjectId(this.controller.getSettings().getConnection(), ((rs.petcom.master.dal.Object)objList.get(0)).getObjectID());
            ObservableList posList = FXCollections.observableArrayList();
            list.forEach(e -> posList.add(e));
            this.cbPos.getItems().add((Object)new PointOfSale(-1, "Sva prodajna mesta"));
            this.cbPos.getItems().addAll((Collection)posList);
            this.cbPos.getSelectionModel().select(0);
        } else {
            this.lblObjekat.setVisible(false);
            rs.petcom.master.dal.Object sviObjekti = new rs.petcom.master.dal.Object(-1, "Izaberite objekat");
            this.cbObjekat.getItems().add((Object)sviObjekti);
            for (rs.petcom.master.dal.Object o : objList) {
                this.cbObjekat.getItems().add((Object)o);
            }
        }
        this.userList.removeIf(e -> e.getUserName().equalsIgnoreCase("admin"));
        this.tableUser.setItems(this.userList);
    }
}

