/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice;

import java.io.File;
import java.io.InputStream;
import java.time.LocalDate;
import java.util.Collection;
import java.util.HashMap;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.TilePane;
import javafx.util.Callback;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.util.JRLoader;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.DocumentPayCard;
import rs.petcom.master.dal.PayCard;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.WorkDay;
import rs.petcom.master.gui.PayCardCheckBox;
import rs.petcom.print.JRPrintPreviewPaneOld;
import tornadofx.control.DateTimePicker;

public class IzvestajPlatnihKarticaController
implements ControlledScreen {
    private ScreensController controller;
    private ObservableList<Long> checkedPayCardList = FXCollections.observableArrayList();
    @FXML
    private BorderPane rootPane;
    @FXML
    private TilePane tilePane;
    @FXML
    private DateTimePicker dpFrom;
    @FXML
    private DateTimePicker dpTo;
    @FXML
    private TableView<DocumentPayCard> tvPayCard;
    @FXML
    private TableColumn<DocumentPayCard, String> columnName;
    @FXML
    private TableColumn<DocumentPayCard, Double> columnValue;
    @FXML
    private TableColumn<DocumentPayCard, Double> columnDocumentSum;
    @FXML
    private TableColumn<DocumentPayCard, Double> columnDifferentSum;

    public void initialize() {
        this.columnName.setCellValueFactory((Callback)new PropertyValueFactory("payCardName"));
        this.columnValue.setCellValueFactory((Callback)new PropertyValueFactory("value"));
        this.columnDocumentSum.setCellValueFactory((Callback)new PropertyValueFactory("documentSum"));
        this.columnDifferentSum.setCellValueFactory((Callback)new PropertyValueFactory("differentSum"));
        this.tvPayCard.getSelectionModel().getSelectedItems().addListener((ListChangeListener)new ListChangeListener<DocumentPayCard>(){

            public void onChanged(ListChangeListener.Change<? extends DocumentPayCard> c) {
            }
        });
    }

    @Override
    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    @Override
    public void init() {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/master/css/trgovina/tableTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/master/css/trgovina/backofficeTrgovina.css");
        }
        this.dpFrom.setValue((Object)Settings.fromDate(WorkDay.getFirstStart(this.controller.getSettings().getConnection())));
        this.dpTo.setValue((Object)LocalDate.now());
        this.createPayCardCheckBox();
    }

    @Override
    public void setParameter(Object parameter) {
    }

    @Override
    public Object getParameter() {
        return null;
    }

    @FXML
    public void printAction() {
        String reportFileName = "rs/petcom/backoffice/jasper/blagajna/IzvestajPlatnihKartica.jasper";
        ObservableList dataList = FXCollections.observableArrayList();
        for (DocumentPayCard documentPayCard : this.tvPayCard.getItems()) {
            dataList.add((Object)documentPayCard);
        }
        JRBeanCollectionDataSource beanColDataSource = new JRBeanCollectionDataSource((Collection)dataList);
        HashMap<String, String> hm = new HashMap<String, String>();
        File file = new File(this.controller.getSettings().getSetting("company.memorandum", this.controller.getPointOfSale()));
        if (file.exists() && file.isFile()) {
            hm.put("memorandum", this.controller.getSettings().getSetting("company.memorandum", this.controller.getPointOfSale()));
        } else {
            hm.put("memorandum", "");
        }
        try {
            JasperReport report = (JasperReport)JRLoader.loadObject((InputStream)JRLoader.getResourceInputStream((String)reportFileName));
            JasperPrint jprint = JasperFillManager.fillReport((JasperReport)report, hm, (JRDataSource)beanColDataSource);
            JRPrintPreviewPaneOld printViewPane = new JRPrintPreviewPaneOld(jprint);
            HashMap<String, Object> hm2 = new HashMap<String, Object>();
            hm2.put("report", (Object)printViewPane);
            this.controller.showModalDialog("Povrat", ScreensController.DIALOG_PRINT_PREVIEW, hm2, this.rootPane.getScene().getWindow());
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    private void createPayCardCheckBox() {
        for (PayCard payCard : PayCard.getList(this.controller, "")) {
            final PayCardCheckBox payCardCheckBox = new PayCardCheckBox();
            payCardCheckBox.setPayCard(payCard);
            this.tilePane.getChildren().add((Object)payCardCheckBox);
            payCardCheckBox.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    if (payCardCheckBox.isSelected()) {
                        IzvestajPlatnihKarticaController.this.checkedPayCardList.add((Object)payCardCheckBox.getPayCard().getPayCardId());
                    } else {
                        IzvestajPlatnihKarticaController.this.checkedPayCardList.remove((Object)payCardCheckBox.getPayCard().getPayCardId());
                    }
                    IzvestajPlatnihKarticaController.this.loadTable(IzvestajPlatnihKarticaController.this.getPayCards((ObservableList<Long>)IzvestajPlatnihKarticaController.this.checkedPayCardList));
                }
            });
        }
    }

    private void loadTable(String payCards) {
        this.tvPayCard.setItems(DocumentPayCard.getList(this.controller, this.dpFrom.getDateTimeValue(), this.dpTo.getDateTimeValue(), payCards));
    }

    private String getPayCards(ObservableList<Long> list) {
        String payCards = "";
        if (!list.isEmpty()) {
            for (Long id : list) {
                payCards = payCards + id;
                payCards = payCards + ",";
            }
            payCards.substring(0, payCards.length() - 1);
        }
        return payCards;
    }
}

