/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice;

import java.util.ArrayList;
import java.util.HashMap;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.util.Callback;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.Group;
import rs.petcom.master.dal.PointOfSale;
import rs.petcom.master.dal.product.GroupPointOfSale;
import rs.petcom.master.gui.PointOfSaleCheckBoxCell;

public class GroupNewController
implements DialogController {
    ScreensController controller;
    HashMap<String, Object> parameter;
    ObservableList<Group> groupList = FXCollections.observableArrayList();
    ObservableList<GroupPointOfSale> listSortForPOS = FXCollections.observableArrayList();
    ObservableList<GroupPointOfSale> listSortForPOSParent = FXCollections.observableArrayList();
    ObservableList<PointOfSale> groupPOSList = FXCollections.observableArrayList();
    ObservableList<PointOfSale> selectedIdList = FXCollections.observableArrayList();
    TreeItem<PointOfSale> treeRootD = new TreeItem();
    int modalResult;
    @FXML
    private BorderPane rootPane;
    @FXML
    private TextField tfImeGrupe;
    @FXML
    private ComboBox<Group> cbBrojRoditeljskeGrupe;
    @FXML
    private ColorPicker cpBojaGrupe;
    @FXML
    private TextField tfPozicijaGrupe;
    @FXML
    private TextField tfPozicijaPodgrupe;
    @FXML
    private TreeView<PointOfSale> treeDepartment;

    @Override
    public void setParameter(HashMap<String, Object> parameter) {
        this.parameter = parameter;
        this.controller = (ScreensController)parameter.get("controller");
        this.groupList = Group.getGroupList(this.controller);
        this.groupPOSList = PointOfSale.getPOSGroupTableList(this.controller.getSettings().getConnection());
        Group startGroup = new Group(-1, "Sve grupe");
        this.cbBrojRoditeljskeGrupe.getItems().add((Object)startGroup);
        for (Group group : this.groupList) {
            this.cbBrojRoditeljskeGrupe.getItems().add((Object)group);
        }
        this.cbBrojRoditeljskeGrupe.getSelectionModel().select((Object)startGroup);
        this.treeDepartment.setCellFactory((Callback)new Callback<TreeView<PointOfSale>, TreeCell<PointOfSale>>(){

            public TreeCell<PointOfSale> call(TreeView<PointOfSale> param) {
                return new PointOfSaleCheckBoxCell(false);
            }
        });
        this.treeDepartment.setShowRoot(false);
        this.treeRootD = new TreeItem();
        this.treeRootD.setValue((Object)new PointOfSale(-1, "Objekti"));
        for (rs.petcom.master.dal.Object o : rs.petcom.master.dal.Object.getList(this.controller.getSettings().getConnection())) {
            TreeItem objekatItem = new TreeItem();
            objekatItem.setValue((Object)new PointOfSale(o.getObjectID(), o.getName()));
            for (PointOfSale d : PointOfSale.getPosList(o, this.controller.getSettings().getConnection())) {
                TreeItem departmentItem = new TreeItem();
                departmentItem.setValue((Object)d);
                objekatItem.getChildren().add((Object)departmentItem);
                objekatItem.setExpanded(true);
            }
            this.treeRootD.getChildren().add((Object)objekatItem);
        }
        this.treeRootD.setExpanded(true);
        this.treeDepartment.setRoot(this.treeRootD);
        this.tfPozicijaPodgrupe.setDisable(true);
        if (this.controller.getVrstaPrograma() == 4) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/master/css/trgovina/tableTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/master/css/trgovina/backofficeTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/master/css/trgovina/dialogTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/master/css/trgovina/tabpaneTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/master/css/trgovina/treeviewTrgovina.css");
        }
    }

    @Override
    public HashMap<String, Object> getParameter() {
        return null;
    }

    @Override
    public int getModalResult() {
        return 0;
    }

    @Override
    public void setModalResult(int modalResult) {
    }

    public void cancel(ActionEvent event) {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        ((Stage)((Node)event.getSource()).getScene().getWindow()).close();
    }

    public void commit(ActionEvent event) {
        ArrayList<Object> izabraniPosovi = new ArrayList<Object>();
        for (Object pos : this.treeRootD.getChildren()) {
            for (TreeItem pos1 : pos.getChildren()) {
                if (!((PointOfSale)pos1.getValue()).isSelected()) continue;
                izabraniPosovi.add(pos1.getValue());
            }
        }
        ArrayList<Department> odeljenjaZaDodavanje = new ArrayList<Department>();
        for (PointOfSale pointOfSale : izabraniPosovi) {
            for (Department department : pointOfSale.getDepartmentList(this.controller.getSettings().getConnection())) {
                boolean postoji = false;
                for (Department dp : odeljenjaZaDodavanje) {
                    if (dp.getDepartmentID() != department.getDepartmentID()) continue;
                    postoji = true;
                    break;
                }
                if (postoji) continue;
                odeljenjaZaDodavanje.add(department);
            }
        }
        Group group = new Group();
        group.setName(this.tfImeGrupe.getText().toUpperCase());
        group.setParentGroupID(((Group)this.cbBrojRoditeljskeGrupe.getSelectionModel().getSelectedItem()).getGroupID());
        int n = group.createNewGroup(this.controller, null);
        for (PointOfSale pointOfSale : izabraniPosovi) {
            int sort = 0;
            boolean istiSort = false;
            this.listSortForPOS = GroupPointOfSale.getListSortForPOS(pointOfSale.getPointOfSaleID(), this.controller.getSettings().getConnection());
            if (((Group)this.cbBrojRoditeljskeGrupe.getSelectionModel().getSelectedItem()).getParentGroupID() == 0) {
                if (this.tfPozicijaGrupe.getText().equals("")) {
                    sort = GroupPointOfSale.getMaxPositionGrupe(pointOfSale.getPointOfSaleID(), this.controller.getSettings().getConnection());
                } else {
                    sort = Integer.parseInt(this.tfPozicijaGrupe.getText());
                    for (GroupPointOfSale gpos : this.listSortForPOS) {
                        if (sort == gpos.getSort()) {
                            istiSort = false;
                            break;
                        }
                        istiSort = true;
                    }
                    sort = istiSort ? GroupPointOfSale.getMaxPositionGrupe(pointOfSale.getPointOfSaleID(), this.controller.getSettings().getConnection()) + 1 : GroupPointOfSale.getMaxPositionGrupe(pointOfSale.getPointOfSaleID(), this.controller.getSettings().getConnection());
                }
                GroupPointOfSale.insert(n, pointOfSale.getPointOfSaleID(), sort, 0, this.controller.getSettings().getConnection());
                continue;
            }
            this.listSortForPOSParent = GroupPointOfSale.getListSortForPOSParent(pointOfSale.getPointOfSaleID(), ((Group)this.cbBrojRoditeljskeGrupe.getSelectionModel().getSelectedItem()).getParentGroupID(), this.controller.getSettings().getConnection());
            if (this.tfPozicijaPodgrupe.getText().equals("")) {
                sort = GroupPointOfSale.getMaxPositionPodgrupe(((Group)this.cbBrojRoditeljskeGrupe.getSelectionModel().getSelectedItem()).getParentGroupID(), pointOfSale.getPointOfSaleID(), this.controller.getSettings().getConnection());
            } else {
                sort = Integer.parseInt(this.tfPozicijaPodgrupe.getText());
                for (GroupPointOfSale gpos : this.listSortForPOSParent) {
                    if (sort == gpos.getSort()) {
                        istiSort = false;
                        break;
                    }
                    istiSort = true;
                }
                sort = istiSort ? GroupPointOfSale.getMaxPositionPodgrupe(((Group)this.cbBrojRoditeljskeGrupe.getSelectionModel().getSelectedItem()).getParentGroupID(), pointOfSale.getPointOfSaleID(), this.controller.getSettings().getConnection()) + 1 : GroupPointOfSale.getMaxPositionPodgrupe(((Group)this.cbBrojRoditeljskeGrupe.getSelectionModel().getSelectedItem()).getParentGroupID(), pointOfSale.getPointOfSaleID(), this.controller.getSettings().getConnection());
            }
            GroupPointOfSale.insert(n, pointOfSale.getPointOfSaleID(), sort, ((Group)this.cbBrojRoditeljskeGrupe.getSelectionModel().getSelectedItem()).getParentGroupID(), this.controller.getSettings().getConnection());
        }
        ((Stage)((Node)event.getSource()).getScene().getWindow()).close();
    }

    public void checkAll(ActionEvent event) {
        for (TreeItem pos : this.treeRootD.getChildren()) {
            for (TreeItem pos1 : pos.getChildren()) {
                ((PointOfSale)pos1.getValue()).setSelected(true);
            }
        }
    }

    @FXML
    private void cbBrojRoditeljskeGrupeAction() {
        if (((Group)this.cbBrojRoditeljskeGrupe.getSelectionModel().getSelectedItem()).getGroupID() != -1) {
            this.tfPozicijaGrupe.setDisable(true);
            this.tfPozicijaPodgrupe.setDisable(false);
        } else {
            this.tfPozicijaGrupe.setDisable(false);
            this.tfPozicijaPodgrupe.setDisable(true);
        }
    }
}

