/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice;

import java.util.HashMap;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.util.Callback;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Group;

public class GroupController
implements ControlledScreen {
    private ScreensController controller = null;
    @FXML
    private BorderPane rootPane;
    @FXML
    private TextField tfFilter;
    @FXML
    private TableView<Group> tableGrupe;
    @FXML
    private TableColumn<Group, String> columnName;
    @FXML
    private TableColumn<Group, Boolean> columnActive;

    @Override
    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    @Override
    public void init() {
        if (this.controller.getVrstaPrograma() == 6 || this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/master/css/trgovina/tableTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/master/css/trgovina/backofficeTrgovina.css");
        }
        this.loadGroupList();
    }

    @Override
    public void setParameter(Object parameter) {
    }

    @Override
    public Object getParameter() {
        return null;
    }

    public void initialize() {
        this.tfFilter.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                GroupController.this.loadGroupList();
            }
        });
    }

    @FXML
    public void groupNew(ActionEvent event) {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("controller", this.controller);
        hm.put("group", null);
        this.controller.showModalDialog("Izbor grupe", ScreensController.DIALOG_GROUP, hm, this.rootPane.getScene().getWindow());
        this.loadGroupList();
    }

    @FXML
    public void groupDelete(ActionEvent event) {
        if (this.tableGrupe.getSelectionModel().getSelectedItem() != null) {
            ((Group)this.tableGrupe.getSelectionModel().getSelectedItem()).delete(this.controller);
        }
        this.loadGroupList();
    }

    @FXML
    private void addProduct() {
        if (this.tableGrupe.getSelectionModel().getSelectedItem() != null) {
            HashMap<String, Object> hm = new HashMap<String, Object>();
            hm.put("controller", this.controller);
            hm.put("selectedGroup", this.tableGrupe.getSelectionModel().getSelectedItem());
            this.controller.showModalDialog("Izbor grupe", ScreensController.DIALOG_GROUP_PRODUCT, hm, this.rootPane.getScene().getWindow());
            this.loadGroupList();
        } else {
            this.controller.alert("Obavestenje", "Morate odabrati grupu za azuriranje artikala, iz tabele", this.rootPane.getScene().getWindow());
        }
    }

    @FXML
    public void groupEdit(ActionEvent event) {
        if (this.tableGrupe.getSelectionModel().getSelectedItem() != null) {
            HashMap<String, Object> hm = new HashMap<String, Object>();
            hm.put("controller", this.controller);
            hm.put("group", this.tableGrupe.getSelectionModel().getSelectedItem());
            this.controller.showModalDialog("Izbor grupe", ScreensController.DIALOG_GROUP, hm, this.rootPane.getScene().getWindow());
            this.loadGroupList();
        } else {
            this.controller.alert("Obavestenje", "Morate odabrati grupu za izmenu, iz tabele", this.rootPane.getScene().getWindow());
        }
    }

    private void loadGroupList() {
        this.tableGrupe.getItems().clear();
        this.columnName.setCellValueFactory((Callback)new PropertyValueFactory("Name"));
        this.columnActive.setCellValueFactory((Callback)new PropertyValueFactory("Active"));
        this.columnActive.setCellFactory(column -> new TableCell<Group, Boolean>(){

            protected void updateItem(Boolean item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (!empty) {
                    if (!item.booleanValue()) {
                        this.setText("Ne");
                    } else {
                        this.setText("Da");
                    }
                } else {
                    this.setText("");
                }
            }
        });
        final PseudoClass myConditionPseudoClass = PseudoClass.getPseudoClass((String)"my-condition");
        this.tableGrupe.setRowFactory(tv -> new TableRow<Group>(){

            public void updateItem(Group item, boolean empty) {
                super.updateItem((Object)item, empty);
                this.pseudoClassStateChanged(myConditionPseudoClass, !empty && item.getParentGroupID() != 0);
            }
        });
        this.tableGrupe.setItems(Group.getList(this.tfFilter.getText().trim(), this.controller));
    }
}

