/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice;

import java.math.BigDecimal;
import java.util.HashMap;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.util.Callback;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.person.GiftCard;

public class GiftCardSettingsController
implements ControlledScreen {
    ScreensController controller;
    GiftCard selectedGiftCard;
    ObservableList<GiftCard> list;
    @FXML
    private BorderPane rootPane;
    @FXML
    private TextField tfFilter;
    @FXML
    private TableView<GiftCard> tvGiftCard;
    @FXML
    private TableColumn<GiftCard, String> tcCode;
    @FXML
    private TableColumn<GiftCard, String> tcName;
    @FXML
    private TableColumn<GiftCard, BigDecimal> tcAmount;
    @FXML
    private TableColumn<GiftCard, Boolean> tcActive;
    @FXML
    private CheckBox cbActive;

    @Override
    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    @Override
    public void init() {
        this.tfFilter.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (oldValue != null && newValue.length() < oldValue.length()) {
                    GiftCardSettingsController.this.loadGiftCardList();
                }
                String value = newValue.toLowerCase();
                ObservableList subentries = FXCollections.observableArrayList();
                long count = GiftCardSettingsController.this.tvGiftCard.getColumns().stream().count();
                block0: for (int i = 0; i < GiftCardSettingsController.this.tvGiftCard.getItems().size(); ++i) {
                    int j = 0;
                    while ((long)j < count) {
                        String entry = "" + ((TableColumn)GiftCardSettingsController.this.tvGiftCard.getColumns().get(j)).getCellData(i);
                        if (entry.toLowerCase().contains(value)) {
                            subentries.add(GiftCardSettingsController.this.tvGiftCard.getItems().get(i));
                            continue block0;
                        }
                        ++j;
                    }
                }
                GiftCardSettingsController.this.tvGiftCard.setItems(subentries);
            }
        });
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/tableTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.loadGiftCardList();
    }

    @Override
    public void setParameter(Object parameter) {
    }

    @Override
    public Object getParameter() {
        return null;
    }

    public void initialize() {
        this.tcCode.setCellValueFactory((Callback)new PropertyValueFactory("code"));
        this.tcName.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        this.tcAmount.setCellValueFactory((Callback)new PropertyValueFactory("amount"));
        this.tcActive.setCellValueFactory((Callback)new PropertyValueFactory("active"));
        this.tcActive.setCellFactory(column -> new TableCell<GiftCard, Boolean>(){

            protected void updateItem(Boolean item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (!empty) {
                    if (!item.booleanValue()) {
                        this.setText("Ne");
                    } else {
                        this.setText("Da");
                    }
                } else {
                    this.setText("");
                }
            }
        });
        this.tvGiftCard.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<GiftCard>(){

            public void changed(ObservableValue<? extends GiftCard> observable, GiftCard oldValue, GiftCard newValue) {
                GiftCardSettingsController.this.selectedGiftCard = newValue;
            }
        });
    }

    @FXML
    public void giftCardNew() {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("controller", this.controller);
        this.controller.showModalDialog("Dodavanje poklon kartice", ScreensController.DIALOG_ADD_GIFT_CARD, hm, this.rootPane.getScene().getWindow());
        this.tfFilter.setText("");
        this.loadGiftCardList();
    }

    @FXML
    private void giftCardChange() {
        if (this.selectedGiftCard != null) {
            HashMap<String, Object> hm = new HashMap<String, Object>();
            hm.put("controller", this.controller);
            hm.put("giftCard", this.selectedGiftCard);
            int result = this.controller.showModalDialog("Dodavanje poklon kartice", ScreensController.DIALOG_ADD_GIFT_CARD, hm, this.rootPane.getScene().getWindow());
            if (result == ScreensController.MODAL_RESULT_OK) {
                // empty if block
            }
            this.tfFilter.setText("");
            this.list.removeAll(this.list);
            this.loadGiftCardList();
        } else {
            this.controller.alert("Obavestenje", "Morate selektovati poklon karticu iz tabele kako bi izvrsili izmenu", this.rootPane.getScene().getWindow());
        }
    }

    @FXML
    private void giftCardDelete() {
        if (this.selectedGiftCard != null) {
            this.selectedGiftCard.delete(this.selectedGiftCard.getGiftCardID(), this.controller.getSettings().getConnection());
            this.loadGiftCardList();
        } else {
            this.controller.alert("Obavestenje", "Morate selektovati poklon karticu iz tabele kako bi mogli da je obrisete", this.rootPane.getScene().getWindow());
        }
        this.tfFilter.setText("");
    }

    private void loadGiftCardList() {
        this.list = GiftCard.getList(this.controller);
        this.tvGiftCard.setItems(this.list);
    }
}

