/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashMap;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.person.GiftCard;
import rs.petcom.master.fical.FiscalPrinter;

public class GiftCardNewDialogController
implements DialogController {
    ScreensController controller;
    HashMap<String, Object> parameter;
    int modalResult = ScreensController.MODAL_RESULT_CANCEL;
    GiftCard selectedGiftCard;
    @FXML
    private BorderPane rootPane;
    @FXML
    private TextField tfCode;
    @FXML
    private TextField tfAmount;
    @FXML
    private TextField tfName;
    @FXML
    private CheckBox cbActive;

    @Override
    public void setParameter(HashMap<String, Object> parameter) {
        this.parameter = parameter;
        this.selectedGiftCard = (GiftCard)parameter.get("giftCard");
        this.controller = (ScreensController)parameter.get("controller");
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/tableTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.loadData();
    }

    @Override
    public HashMap<String, Object> getParameter() {
        return this.parameter;
    }

    @Override
    public int getModalResult() {
        return this.modalResult;
    }

    @Override
    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }

    @FXML
    private void addAction() {
        int i;
        GiftCard gCard = new GiftCard();
        if (this.selectedGiftCard == null) {
            gCard.setCode(this.tfCode.getText());
            gCard.setAmount(new BigDecimal(this.tfAmount.getText()));
            gCard.setActive(this.cbActive.isSelected());
            gCard.setName(this.tfName.getText().trim());
            try {
                gCard.insert(this.controller);
            }
            catch (SQLException e) {
                e.printStackTrace();
                this.controller.alert("Obavestenje", "Kod kartice: " + this.tfCode.getText() + " vec postoji u bazi podataka, molim Vas da pokusate sa drugim kodom ili drugom karticom", this.rootPane.getScene().getWindow());
                return;
            }
            this.parameter.put("giftCard", gCard);
        } else {
            gCard.setCode(this.tfCode.getText());
            gCard.setAmount(new BigDecimal(this.tfAmount.getText()));
            gCard.setActive(this.cbActive.isSelected());
            gCard.setGiftCardID(this.selectedGiftCard.getGiftCardID());
            gCard.setName(this.tfName.getText().trim());
            gCard.update(this.controller);
            this.parameter.put("giftCard", gCard);
        }
        String[] orderKitchen = new String[1];
        for (i = 0; i < 1; ++i) {
            orderKitchen[i] = gCard.getCode().length() > 15 ? String.format("%2.0f", gCard.getAmount()) : String.format("%2.0f", gCard.getAmount());
        }
        for (i = 0; i < 2; ++i) {
            FiscalPrinter.printNonFiscalGiftCard(this.controller, orderKitchen);
        }
        this.modalResult = ScreensController.MODAL_RESULT_OK;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    @FXML
    private void cancelAction() {
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    private void loadData() {
        if (this.selectedGiftCard != null) {
            this.tfCode.setText(this.selectedGiftCard.getCode());
            this.tfName.setText(this.selectedGiftCard.getName());
            this.tfAmount.setText("" + this.selectedGiftCard.getAmount().doubleValue());
            this.cbActive.setSelected(this.selectedGiftCard.isActive());
        }
    }
}

