/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import javafx.application.Platform;
import javafx.beans.property.adapter.JavaBeanStringPropertyBuilder;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.person.CashBuyer;
import rs.petcom.master.dal.person.Person;
import rs.petcom.master.dal.person.PersonCategory;
import rs.petcom.master.dal.person.PersonCategoryEnum;

public class FizickoLiceController
implements ControlledScreen {
    private ScreensController controller;
    private ObservableList<Person> personsList = FXCollections.observableArrayList();
    private ObservableList<PersonCategory> personCategoryList = FXCollections.observableArrayList();
    private Person selectedPerson;
    private String personCategory;
    @FXML
    private BorderPane rootPane;
    @FXML
    private Label title;
    @FXML
    private TextField tfFilter;
    @FXML
    private TableView<Person> tvPerson;
    @FXML
    private TableColumn<Person, String> tcFirstName;
    @FXML
    private TableColumn<Person, String> tcLastName;
    @FXML
    private TableColumn<Person, String> tcAddress;
    @FXML
    private TableColumn<Person, String> tcCity;
    @FXML
    private TableColumn<Person, String> tcCategory;
    @FXML
    private VBox vBox;

    @Override
    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    @Override
    public void init() {
        this.personCategoryList = PersonCategory.getList(this.controller.getSettings().getConnection());
        this.tfFilter.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                FizickoLiceController.this.loadPersonsList();
            }
        });
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/tableTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
    }

    @Override
    public void setParameter(Object parameter) {
        HashMap mapa = (HashMap)parameter;
        PersonCategoryEnum pce = (PersonCategoryEnum)((Object)mapa.get("personCategory"));
        this.personCategory = pce.getName();
        System.out.println(pce.getName());
        this.title.setText(this.personCategory);
        this.personCategoryList.add((Object)new PersonCategory(pce.getPersonCategoryId(), pce.getName(), pce.isBuyerCol(), pce.isSupplierCol()));
        this.loadPersonsList();
        this.vBox.setPrefWidth(this.controller.getRoot().getScene().getWidth() * 20.0 / 100.0);
    }

    @Override
    public Object getParameter() {
        return null;
    }

    public void initialize() {
        this.tcFirstName.setCellValueFactory((Callback)new PropertyValueFactory("firstName"));
        this.tcLastName.setCellValueFactory((Callback)new PropertyValueFactory("lastName"));
        this.tcAddress.setCellValueFactory((Callback)new PropertyValueFactory("Address"));
        this.tcCity.setCellValueFactory((Callback)new PropertyValueFactory("City"));
        this.tcCategory.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<Person, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<Person, String> param) {
                try {
                    return new JavaBeanStringPropertyBuilder().bean((Object)PersonCategory.getByID(((Person)param.getValue()).getPersonCategoryID(), FizickoLiceController.this.controller.getSettings().getConnection())).name("Name").build();
                }
                catch (NoSuchMethodException | NullPointerException e) {
                    return null;
                }
            }
        });
        this.tvPerson.getSelectionModel().selectedItemProperty().addListener((observableValue, oldValue, newValue) -> {
            this.selectedPerson = newValue;
        });
    }

    @FXML
    public void personNew(ActionEvent event) {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("controller", this.controller);
        hm.put("selectedPerson", null);
        hm.put("personCategory", this.personCategory);
        String title = this.personCategory.equals("Kupac") ? "Kreiranje novog kupca" : "Kreiranje novog dobavlja\u010da";
        this.controller.showModalDialog(title, ScreensController.DIALOG_ADD_PERSON, hm, (Window)((Stage)((Node)event.getSource()).getScene().getWindow()));
        this.loadPersonsList();
    }

    @FXML
    public void personDelete(ActionEvent event) {
        if (this.selectedPerson == null) {
            String message = this.personCategory.equals("Kupac") ? "Izaberite kupca koga \u017eelite da obrisete" : "Izaberite dobavlja\u010da koga \u017eelite da obrisete";
            this.controller.alert("Upozorenje", message, this.rootPane.getScene().getWindow());
            return;
        }
        this.selectedPerson.delete(this.selectedPerson.getPersonID(), this.controller.getSettings().getConnection());
        this.loadPersonsList();
    }

    @FXML
    public void personUpdate(ActionEvent event) {
        if (this.selectedPerson == null) {
            String message = this.personCategory.equals("Kupac") ? "Izaberite kupca koga \u017eelite da izmenite" : "Izaberite dobavlja\u010da koga \u017eelite da izmenite";
            this.controller.alert("Upozorenje", message, this.rootPane.getScene().getWindow());
            return;
        }
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("controller", this.controller);
        hm.put("personCategory", this.personCategory);
        hm.put("selectedPerson", this.selectedPerson);
        this.controller.showModalDialog("Izmena podataka", ScreensController.DIALOG_ADD_PERSON, hm, (Window)((Stage)((Node)event.getSource()).getScene().getWindow()));
        this.loadPersonsList();
    }

    @FXML
    private void getExcel() {
        final Stage taskUpdateStage = this.controller.getSettings().getInfoStage("Kreiranje izve\u0161taja u toku.", this.rootPane.getScene().getWindow());
        Task<Void> creatingReport = new Task<Void>(){

            protected Void call() throws Exception {
                FizickoLiceController.this.writeToExcel();
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        taskUpdateStage.hide();
                    }
                });
                return null;
            }
        };
        new Thread((Runnable)creatingReport).start();
        creatingReport.setOnSucceeded(eventValue -> {
            taskUpdateStage.hide();
            this.controller.alert("Obave\u0161tenje", "Uspe\u0161no ste kreirali izve\u0161taj.", this.rootPane.getScene().getWindow());
        });
        creatingReport.setOnFailed(eventValue -> {
            taskUpdateStage.hide();
            this.controller.alert("Gre\u0161ka!", "Do\u0161lo je do gre\u0161ke prilikom izdavanja izve\u0161taja.", this.rootPane.getScene().getWindow());
        });
    }

    @FXML
    private void actionCsvImport() {
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.US);
        nf.setGroupingUsed(false);
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Import prijemnice");
        FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("CSV files (*.csv)", new String[]{"*.csv"});
        fileChooser.getExtensionFilters().add((Object)extFilter);
        final File file = fileChooser.showOpenDialog(this.rootPane.getScene().getWindow());
        if (file != null) {
            Stage taskUpdateStage = this.controller.getSettings().getInfoStage("U\u010ditavanje detalja u toku.", this.rootPane.getScene().getWindow());
            ArrayList unexistedProducts = new ArrayList();
            Task<Void> loadingCsvTask = new Task<Void>(){

                protected Void call() throws Exception {
                    String line = "";
                    String[] colNames = null;
                    int colPersonTypeID = -1;
                    int colPersonCategoryID = -1;
                    int colPersonVatTypeID = -1;
                    int colName = -1;
                    int colPIB = -1;
                    int colAddress = -1;
                    int colCity = -1;
                    int colZIP = -1;
                    int counterRow = 0;
                    try {
                        BufferedReader bf = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                        while ((line = bf.readLine()) != null) {
                            colNames = line.split(";");
                            if (counterRow == 0) {
                                for (int i = 0; i < colNames.length; ++i) {
                                    if (colNames[i].trim().toLowerCase().equals("type")) {
                                        colPersonTypeID = i;
                                    }
                                    if (colNames[i].trim().toLowerCase().equals("category")) {
                                        colPersonCategoryID = i;
                                    }
                                    if (colNames[i].trim().toLowerCase().equals("vat")) {
                                        colPersonVatTypeID = i;
                                    }
                                    if (colNames[i].trim().toLowerCase().equals("name")) {
                                        colName = i;
                                    }
                                    if (colNames[i].trim().toLowerCase().equals("pib")) {
                                        colPIB = i;
                                    }
                                    if (colNames[i].trim().toLowerCase().equals("address")) {
                                        colAddress = i;
                                    }
                                    if (colNames[i].trim().toLowerCase().equals("city")) {
                                        colCity = i;
                                    }
                                    if (!colNames[i].trim().toLowerCase().equals("zip")) continue;
                                    colZIP = i;
                                }
                            } else {
                                Person person = new Person();
                                person.setPersonTypeID(Integer.parseInt(colNames[colPersonTypeID]));
                                person.setPersonCategoryID(Integer.parseInt(colNames[colPersonCategoryID]));
                                person.setPersonVatTypeID(Integer.parseInt(colNames[colPersonVatTypeID]));
                                person.setName(colNames[colName]);
                                person.setPIB(colNames[colPIB]);
                                person.setAddress(colNames[colAddress]);
                                person.setCity(colNames[colCity]);
                                person.setZIP(colNames[colZIP]);
                                person.setFirstName("");
                                person.setLastName("");
                                person.setMB("");
                                person.setBuyerOfferPriceID(-1L);
                                person.setActive(true);
                                person.insert(FizickoLiceController.this.controller.getUser(), FizickoLiceController.this.controller.getSettings().getConnection());
                                if (person.getPersonCategoryID() == PersonCategory.getByName(PersonCategory.BUYER, FizickoLiceController.this.controller.getSettings().getConnection()).getPersonCategoryID()) {
                                    CashBuyer cashBuyer = new CashBuyer();
                                    cashBuyer.setName(person.getName());
                                    cashBuyer.setAddress(person.getAddress());
                                    cashBuyer.setCity(person.getCity());
                                    cashBuyer.setPIB(person.getPIB());
                                    cashBuyer.setZIP(person.getZIP());
                                    cashBuyer.setSysUserAddID(person.getSysUserAddID());
                                    cashBuyer.insert(FizickoLiceController.this.controller.getSettings().getConnection());
                                }
                            }
                            ++counterRow;
                        }
                        bf.close();
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    return null;
                }
            };
            loadingCsvTask.setOnSucceeded(eventValue -> {
                taskUpdateStage.hide();
                this.loadPersonsList();
                if (unexistedProducts.size() > 0) {
                    this.controller.alert("Nepostoje\u0107i PIB", unexistedProducts.toString(), this.rootPane.getScene().getWindow());
                }
            });
            loadingCsvTask.setOnFailed(eventValue -> {
                taskUpdateStage.hide();
                this.controller.alert("Obave\u0161tenje", "Neuspe\u0161no u\u010ditavanje iz csv fajla", this.rootPane.getScene().getWindow());
            });
            loadingCsvTask.exceptionProperty().addListener((obs, old, newValue) -> {
                if (newValue != null) {
                    Exception ex = (Exception)newValue;
                    ex.printStackTrace();
                }
            });
            new Thread((Runnable)loadingCsvTask).start();
        }
    }

    private void writeToExcel() {
        String xlsxTitle = this.personCategory.equals("Kupac") ? "Lista kupaca" : "Lista dobavljaca";
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFSheet sheet = wb.createSheet(xlsxTitle);
        XSSFRow header = sheet.createRow(0);
        header.createCell(0).setCellValue("Ime");
        header.createCell(1).setCellValue("Prezime");
        header.createCell(2).setCellValue("Adresa");
        header.createCell(3).setCellValue("Grad");
        header.createCell(4).setCellValue("Postanski broj");
        sheet.setColumnWidth(0, 4100);
        sheet.setColumnWidth(1, 4100);
        sheet.setColumnWidth(2, 9600);
        sheet.setColumnWidth(3, 4100);
        sheet.setColumnWidth(4, 4100);
        int index = 1;
        for (Person person : this.personsList) {
            XSSFRow row = sheet.createRow(index);
            row.createCell(0).setCellValue(person.getFirstName());
            row.createCell(1).setCellValue(person.getLastName());
            row.createCell(2).setCellValue(person.getAddress());
            row.createCell(3).setCellValue(person.getCity());
            row.createCell(4).setCellValue(person.getZIP());
            ++index;
        }
        try {
            File theDir = new File(this.controller.getSettings().getJasperToPDF() + xlsxTitle.replace(" ", "_"));
            if (!theDir.exists()) {
                try {
                    theDir.mkdir();
                }
                catch (SecurityException se) {
                    se.printStackTrace();
                }
            }
            FileOutputStream fileOutputStream = new FileOutputStream(theDir + File.separator + xlsxTitle.replace(" ", "_").concat(".xlsx"));
            wb.write((OutputStream)fileOutputStream);
            wb.close();
            fileOutputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadPersonsList() {
        PersonCategoryEnum pce = PersonCategoryEnum.getByName(this.personCategory);
        if (pce.isBuyerCol()) {
            this.personsList = Person.getList(true, this.tfFilter.getText(), String.valueOf(PersonCategory.getByName("Kupac", this.controller.getSettings().getConnection()).getPersonCategoryID()), this.controller.getSettings().getConnection());
        }
        this.tvPerson.setItems(this.personsList);
    }
}

