/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice;

import java.util.HashMap;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.util.Callback;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.product.Product;

public class DodatniProductSelectDialogController
implements DialogController {
    ScreensController controller;
    HashMap<String, Object> parameters;
    Product product;
    int modalResult = ScreensController.MODAL_RESULT_CANCEL;
    ObservableList<Product> productList = FXCollections.observableArrayList();
    @FXML
    BorderPane rootPane;
    @FXML
    TableView<Product> table;
    @FXML
    TableColumn<Product, String> tcCode;
    @FXML
    TableColumn<Product, String> tcName;
    @FXML
    TableColumn<Product, String> tcShortName;
    @FXML
    TextField tfFilter;

    public void initialize() {
        this.tcCode.setCellValueFactory((Callback)new PropertyValueFactory("Code"));
        this.tcName.setCellValueFactory((Callback)new PropertyValueFactory("Name"));
        this.tcShortName.setCellValueFactory((Callback)new PropertyValueFactory("ShortName"));
        this.tfFilter.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                DodatniProductSelectDialogController.this.populateTable();
            }
        });
    }

    @Override
    public void setParameter(HashMap<String, Object> parameters) {
        this.parameters = parameters;
        this.product = (Product)parameters.get("product");
        this.controller = (ScreensController)parameters.get("controller");
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/dialogTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/tabpaneTrgovina.css");
        }
        this.tfFilter.setText("");
        this.tfFilter.requestFocus();
        this.populateTable();
    }

    @Override
    public HashMap<String, Object> getParameter() {
        return this.parameters;
    }

    @FXML
    private void cancel(ActionEvent actionEvent) {
        this.setModalResult(ScreensController.MODAL_RESULT_CANCEL);
        Node source = (Node)actionEvent.getSource();
        Stage stage = (Stage)source.getScene().getWindow();
        stage.close();
    }

    @FXML
    private void confirm(ActionEvent actionEvent) {
        this.parameters.put("product", this.table.getSelectionModel().getSelectedItem());
        this.modalResult = ScreensController.MODAL_RESULT_OK;
        ((Stage)((Node)actionEvent.getSource()).getScene().getWindow()).close();
    }

    private void populateTable() {
        this.table.setItems(Product.getObeservableList(this.product, this.tfFilter.getText(), true, (Department)this.parameters.get("department"), this.controller.getSettings().getConnection()));
        if (this.table.getItems().size() > 0) {
            this.table.getSelectionModel().select(0);
        }
    }

    @FXML
    private void mouseClick(MouseEvent event) {
        if (event.getClickCount() == 2) {
            this.setModalResult(0);
            this.parameters.put("product", this.table.getSelectionModel().getSelectedItem());
            Node source = (Node)event.getSource();
            Stage stage = (Stage)source.getScene().getWindow();
            stage.close();
        }
    }

    @FXML
    private void newProduct() {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("controller", this.controller);
        int mr = this.controller.showModalDialog("Izbor proizvoda", ScreensController.DIALOG_BACKOFFICE_ADD_PRODUCT, hm, this.rootPane.getScene().getWindow());
        if (mr == ScreensController.MODAL_RESULT_OK) {
            this.populateTable();
        }
    }

    @Override
    public int getModalResult() {
        return this.modalResult;
    }

    @Override
    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }
}

