/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import javafx.collections.ListChangeListener;
import javafx.fxml.FXML;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.util.Callback;
import javafx.util.StringConverter;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.WorkDay;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.document.DocumentDetails;

public class DocumentListController
implements ControlledScreen {
    ScreensController controller;
    StringConverter<LocalDate> converter = new StringConverter<LocalDate>(){
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("dd.MM.yyyy");

        public String toString(LocalDate date) {
            if (date != null) {
                return this.dateFormatter.format(date);
            }
            return "";
        }

        public LocalDate fromString(String string) {
            if (string != null && !string.isEmpty()) {
                return LocalDate.parse(string, this.dateFormatter);
            }
            return null;
        }
    };
    @FXML
    private BorderPane rootPane;
    @FXML
    private DatePicker dateFrom;
    @FXML
    private DatePicker dateTo;
    @FXML
    private BorderPane reportPane;
    @FXML
    TableView<Document> reciptTable;
    @FXML
    TableColumn<Document, Integer> colBroj;
    @FXML
    TableColumn<Document, Date> colDatum;
    @FXML
    TableColumn<Document, Double> colBillValue;
    @FXML
    Label lblValue;
    @FXML
    Label lblDiscount;
    @FXML
    Label lblValueWithDiscount;
    @FXML
    TableView<DocumentDetails> tableStavke;
    @FXML
    TableColumn<Document, String> tcNaziv;
    @FXML
    TableColumn<Document, Double> tcKol;
    @FXML
    TableColumn<Document, Double> tcCena;

    @Override
    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    @Override
    public void setParameter(Object parameter) {
    }

    @Override
    public Object getParameter() {
        return null;
    }

    @Override
    public void init() {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/tabpaneTrgovina.css");
        }
        this.dateFrom.setConverter(this.converter);
        this.dateFrom.setValue((Object)LocalDate.now());
        try {
            this.reciptTable.setItems(Document.getObeservableList(3, this.controller.getObject().getObjectID(), WorkDay.start((LocalDate)this.dateFrom.getValue(), this.controller.getSettings().getConnection()), WorkDay.end((LocalDate)this.dateFrom.getValue(), this.controller.getSettings().getConnection()), this.controller.getSettings().getConnection()));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.colDatum.setCellValueFactory((Callback)new PropertyValueFactory("Date"));
        this.colDatum.setCellFactory(column -> new TableCell<Document, Date>(){

            protected void updateItem(Date item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Settings.getDateTimeFromatter().format(item));
                }
            }
        });
        this.colBroj.setCellValueFactory((Callback)new PropertyValueFactory("Number"));
        this.colBillValue.setCellValueFactory((Callback)new PropertyValueFactory("SumWithDiscount"));
        this.colBillValue.setCellFactory(column -> new TableCell<Document, Double>(){

            protected void updateItem(Double item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Settings.getNumberFormat(2, true).format(item));
                }
            }
        });
        this.reciptTable.getSelectionModel().getSelectedItems().addListener((ListChangeListener)new ListChangeListener<Document>(){

            public void onChanged(ListChangeListener.Change<? extends Document> c) {
                Document d = (Document)DocumentListController.this.reciptTable.getSelectionModel().getSelectedItem();
                if (d != null) {
                    DocumentListController.this.lblValue.setText(Settings.getNumberFormat(2, true).format(d.getSum()));
                    DocumentListController.this.lblDiscount.setText(Settings.getNumberFormat(2, true).format(d.getDiscount()));
                    DocumentListController.this.lblValueWithDiscount.setText(Settings.getNumberFormat(2, true).format(d.getSumWithDiscount()));
                    DocumentListController.this.tableStavke.setItems(DocumentDetails.getObeservableList(d.getDocumentID(), DocumentListController.this.controller.getSettings().getConnection()));
                }
            }
        });
        this.tcNaziv.setCellValueFactory((Callback)new PropertyValueFactory("ProductName"));
        this.tcKol.setCellValueFactory((Callback)new PropertyValueFactory("Quantity"));
        this.tcKol.setCellFactory(column -> new TableCell<Document, Double>(){

            protected void updateItem(Double item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Settings.getNumberFormat(4, true).format(item));
                }
            }
        });
        this.tcCena.setCellValueFactory((Callback)new PropertyValueFactory("Value"));
        this.tcCena.setCellFactory(column -> new TableCell<Document, Double>(){

            protected void updateItem(Double item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Settings.getNumberFormat(2, true).format(item));
                }
            }
        });
    }

    @FXML
    private void dateFromChange() {
        this.reciptTable.setItems(Document.getObeservableList(3, this.controller.getObject().getObjectID(), WorkDay.start((LocalDate)this.dateFrom.getValue(), this.controller.getSettings().getConnection()), WorkDay.end((LocalDate)this.dateFrom.getValue(), this.controller.getSettings().getConnection()), this.controller.getSettings().getConnection()));
    }

    @FXML
    private void createCorrection() {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("document", this.reciptTable.getSelectionModel().getSelectedItem());
        hm.put("user", this.controller.getUser());
        hm.put("connection", this.controller.getSettings().getConnection());
        int result = this.controller.showModalDialog("Nalog za ispravku", ScreensController.SCREEN_BACKOFFICE_FISCAL_CORRECTION_DIALOG, hm, this.rootPane.getScene().getWindow());
        if (result == ScreensController.MODAL_RESULT_OK) {
            this.reciptTable.setItems(Document.getObeservableList(3, this.controller.getObject().getObjectID(), WorkDay.start((LocalDate)this.dateFrom.getValue(), this.controller.getSettings().getConnection()), WorkDay.end((LocalDate)this.dateFrom.getValue(), this.controller.getSettings().getConnection()), this.controller.getSettings().getConnection()));
        }
    }
}

