/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice;

import java.io.File;
import java.io.InputStream;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.util.Callback;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.document.DocumentDetails;
import rs.petcom.master.dal.person.Person;
import rs.petcom.print.JRPrintPreviewPaneOld;

public class DocumentDetailsStalniKupacController
implements DialogController {
    ScreensController controller;
    HashMap<String, Object> parameter;
    DocumentDetails documentDetails;
    Document document;
    Person person;
    int modalResult;
    @FXML
    BorderPane rootPane;
    @FXML
    TableView<DocumentDetails> table;
    @FXML
    TableColumn<DocumentDetails, String> tcName;
    @FXML
    TableColumn<DocumentDetails, Double> tcKolicina;
    @FXML
    TableColumn<DocumentDetails, Double> tcCena;
    @FXML
    TableColumn<DocumentDetails, Double> tcPopust;
    @FXML
    TableColumn<DocumentDetails, Double> tcCenaSaPopustom;
    @FXML
    TableColumn<DocumentDetails, String> tcVreme;

    @FXML
    private void cancel(ActionEvent actionEvent) {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        Node source = (Node)actionEvent.getSource();
        Stage stage = (Stage)source.getScene().getWindow();
        stage.close();
    }

    @FXML
    private void print(ActionEvent actionEvent) {
        this.printJasper();
    }

    @Override
    public void setParameter(HashMap<String, Object> parameter) {
        this.parameter = parameter;
        this.controller = (ScreensController)parameter.get("controller");
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/dialogTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/tabpaneTrgovina.css");
        }
        this.document = (Document)parameter.get("document");
        this.person = (Person)parameter.get("person");
        this.fillTable();
    }

    @Override
    public HashMap<String, Object> getParameter() {
        return null;
    }

    @Override
    public int getModalResult() {
        return 0;
    }

    @Override
    public void setModalResult(int modalResult) {
    }

    private void fillTable() {
        this.tcName.setCellValueFactory((Callback)new PropertyValueFactory("ProductName"));
        this.tcKolicina.setCellValueFactory((Callback)new PropertyValueFactory("Quantity"));
        this.tcCena.setCellValueFactory((Callback)new PropertyValueFactory("Price"));
        this.tcPopust.setCellValueFactory((Callback)new PropertyValueFactory("Discount"));
        this.tcCenaSaPopustom.setCellValueFactory((Callback)new PropertyValueFactory("PriceWithDiscount"));
        this.tcVreme.setCellValueFactory((Callback)new PropertyValueFactory("sysDTCreated"));
        this.tcVreme.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<DocumentDetails, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<DocumentDetails, String> param) {
                SimpleStringProperty property = new SimpleStringProperty();
                SimpleDateFormat localDateFormat = new SimpleDateFormat("HH:mm:ss");
                property.setValue(localDateFormat.format(((DocumentDetails)param.getValue()).getSysDTCreated().getTime()));
                return property;
            }
        });
        this.table.setItems(DocumentDetails.getObeservableListStalniKupac(this.document.getDocumentID(), this.controller.getSettings().getConnection()));
    }

    private void printJasper() {
        String reportFileName = "rs/petcom/backoffice/jasper/RacunStalniKupac.jasper";
        HashMap<String, Object> hm = new HashMap<String, Object>();
        File file = new File(this.controller.getSettings().getSetting("company.memorandum", this.controller.getPointOfSale()));
        if (file.exists() && file.isFile()) {
            hm.put("memorandum", this.controller.getSettings().getSetting("company.memorandum", this.controller.getPointOfSale()));
        } else {
            hm.put("memorandum", "");
        }
        hm.put("objekatIme", this.controller.getObject());
        hm.put("documentID", this.document.getDocumentID());
        hm.put("person", this.person);
        hm.put("date", this.document.getDate());
        hm.put("brojFR", this.document.getFullNumber());
        try {
            JasperReport report = (JasperReport)JRLoader.loadObject((InputStream)JRLoader.getResourceInputStream((String)reportFileName));
            JasperPrint jprint = JasperFillManager.fillReport((JasperReport)report, hm, (Connection)this.controller.getSettings().getConnection());
            JRPrintPreviewPaneOld printViewPane = new JRPrintPreviewPaneOld(jprint);
            HashMap<String, Object> hm2 = new HashMap<String, Object>();
            hm2.put("report", (Object)printViewPane);
            this.controller.showModalDialog("Racun stalnog kupca", ScreensController.DIALOG_PRINT_PREVIEW, hm2, this.rootPane.getScene().getWindow());
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }
}

