/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice;

import java.util.Date;
import java.util.HashMap;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.util.Callback;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Deferred;
import rs.petcom.master.dal.DeferredRecord;
import rs.petcom.master.dal.Settings;

public class DeferredsReciveController
implements ControlledScreen {
    private ScreensController controller;
    private ObservableList<Deferred> defferedsList = FXCollections.observableArrayList();
    private ObservableList<DeferredRecord> defferedsRecordList = FXCollections.observableArrayList();
    private Deferred selectedDeferred;
    @FXML
    private BorderPane rootPane;
    @FXML
    private Label title;
    @FXML
    private TextField tfFilter;
    @FXML
    private TableView<Deferred> tvDeferred;
    @FXML
    private TableView<DeferredRecord> tvDeferredRecord;
    @FXML
    private TableColumn<DeferredRecord, Double> tcAmountDr;
    @FXML
    private TableColumn<DeferredRecord, Date> tcDateDr;
    @FXML
    private TableColumn<Deferred, String> tcName;
    @FXML
    private TableColumn<Deferred, String> tcSurname;
    @FXML
    private TableColumn<Deferred, Double> tcCurrentAmount;
    @FXML
    private TableColumn<Deferred, Double> tcAmount;

    @Override
    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    @Override
    public void init() {
        this.tfFilter.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                DeferredsReciveController.this.loadDeferredsList();
            }
        });
        if (this.controller.getVrstaPrograma() == 4) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/tableTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
    }

    @Override
    public void setParameter(Object parameter) {
        this.loadDeferredsList();
    }

    @Override
    public Object getParameter() {
        return null;
    }

    public void initialize() {
        this.tcName.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        this.tcSurname.setCellValueFactory((Callback)new PropertyValueFactory("surname"));
        this.tcCurrentAmount.setCellValueFactory((Callback)new PropertyValueFactory("currentAmount"));
        this.tcAmount.setCellValueFactory((Callback)new PropertyValueFactory("amountRecord"));
        this.tvDeferred.getSelectionModel().selectedItemProperty().addListener((observableValue, oldValue, newValue) -> {
            this.selectedDeferred = newValue;
            if (this.tvDeferred.getSelectionModel().getSelectedItem() != null) {
                this.loadDeferredsRecordList();
            }
        });
        this.tcAmountDr.setCellValueFactory((Callback)new PropertyValueFactory("amount"));
        this.tcDateDr.setCellValueFactory((Callback)new PropertyValueFactory("dateRecive"));
        this.tcDateDr.setCellFactory(column -> new TableCell<DeferredRecord, Date>(){

            protected void updateItem(Date item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Settings.getDateTimeFromatter().format(item));
                }
            }
        });
    }

    @FXML
    public void newPaymentAction() {
        if (this.tvDeferred.getSelectionModel().getSelectedItem() != null) {
            HashMap<String, Object> hm = new HashMap<String, Object>();
            hm.put("controller", this.controller);
            hm.put("selectedDeferred", this.tvDeferred.getSelectionModel().getSelectedItem());
            this.controller.showModalDialog("Kreiranje kupca", ScreensController.DIALOG_ADD_DEFERRED_PAYMENT, hm, this.rootPane.getScene().getWindow());
            this.tvDeferred.getSelectionModel().clearSelection();
            this.loadDeferredsList();
        }
    }

    @FXML
    private void getExcel() {
        final Stage taskUpdateStage = this.controller.getSettings().getInfoStage("Kreiranje izve\u0161taja u toku.", this.rootPane.getScene().getWindow());
        Task<Void> creatingReport = new Task<Void>(){

            protected Void call() throws Exception {
                DeferredsReciveController.this.writeToExcel();
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        taskUpdateStage.hide();
                    }
                });
                return null;
            }
        };
        new Thread((Runnable)creatingReport).start();
        creatingReport.setOnSucceeded(eventValue -> {
            taskUpdateStage.hide();
            this.controller.alert("Obave\u0161tenje", "Uspe\u0161no ste kreirali izve\u0161taj.", this.rootPane.getScene().getWindow());
        });
        creatingReport.setOnFailed(eventValue -> {
            taskUpdateStage.hide();
            this.controller.alert("Gre\u0161ka!", "Do\u0161lo je do gre\u0161ke prilikom izdavanja izve\u0161taja.", this.rootPane.getScene().getWindow());
        });
    }

    private void writeToExcel() {
    }

    private void loadDeferredsList() {
        this.defferedsList = Deferred.getDeferredsReciveList(this.controller, this.tfFilter.getText().trim());
        this.tvDeferred.setItems(this.defferedsList);
    }

    private void loadDeferredsRecordList() {
        this.defferedsRecordList = DeferredRecord.getDeferredsRecordList(this.controller, this.selectedDeferred);
        this.tvDeferredRecord.setItems(this.defferedsRecordList);
    }
}

