/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice;

import java.util.HashMap;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Deferred;

public class DeferredsController
implements ControlledScreen {
    private ScreensController controller;
    private ObservableList<Deferred> defferedsList = FXCollections.observableArrayList();
    private Deferred selectedDeferred;
    @FXML
    private BorderPane rootPane;
    @FXML
    private Label title;
    @FXML
    private TextField tfFilter;
    @FXML
    private TableView<Deferred> tvDeferred;
    @FXML
    private TableColumn<Deferred, String> tcName;
    @FXML
    private TableColumn<Deferred, String> tcSurname;
    @FXML
    private TableColumn<Deferred, Double> tcCurrentAmount;

    @Override
    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    @Override
    public void init() {
        this.tfFilter.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                DeferredsController.this.loadDeferredsList();
            }
        });
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
    }

    @Override
    public void setParameter(Object parameter) {
        this.loadDeferredsList();
    }

    @Override
    public Object getParameter() {
        return null;
    }

    public void initialize() {
        this.tcName.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        this.tcSurname.setCellValueFactory((Callback)new PropertyValueFactory("surname"));
        this.tcCurrentAmount.setCellValueFactory((Callback)new PropertyValueFactory("currentAmount"));
        this.tvDeferred.getSelectionModel().selectedItemProperty().addListener((observableValue, oldValue, newValue) -> {
            this.selectedDeferred = newValue;
        });
    }

    @FXML
    public void personNew(ActionEvent event) {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("controller", this.controller);
        hm.put("selectedDeferred", null);
        int model = this.controller.showModalDialog("Kreiranje kupca", ScreensController.DIALOG_ADD_DEFERRED, hm, (Window)((Stage)((Node)event.getSource()).getScene().getWindow()));
        if (model == ScreensController.MODAL_RESULT_OK) {
            // empty if block
        }
        this.loadDeferredsList();
    }

    @FXML
    public void personDelete(ActionEvent event) {
        if (this.selectedDeferred == null) {
            this.controller.alert("Upozorenje", "Izaberite kupca koga \u017eelite da obrisete", this.rootPane.getScene().getWindow());
            return;
        }
        this.selectedDeferred.delete(this.selectedDeferred.getDeferredId(), this.controller);
        this.loadDeferredsList();
    }

    @FXML
    public void personUpdate(ActionEvent event) {
        if (this.selectedDeferred == null) {
            this.controller.alert("Upozorenje", "Izaberite kupca koga \u017eelite da izmenite", this.rootPane.getScene().getWindow());
            return;
        }
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("controller", this.controller);
        hm.put("selectedDeferred", this.selectedDeferred);
        this.controller.showModalDialog("Izmena podataka", ScreensController.DIALOG_ADD_DEFERRED, hm, (Window)((Stage)((Node)event.getSource()).getScene().getWindow()));
        this.loadDeferredsList();
    }

    @FXML
    private void getExcel() {
        final Stage taskUpdateStage = this.controller.getSettings().getInfoStage("Kreiranje izve\u0161taja u toku.", this.rootPane.getScene().getWindow());
        Task<Void> creatingReport = new Task<Void>(){

            protected Void call() throws Exception {
                DeferredsController.this.writeToExcel();
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        taskUpdateStage.hide();
                    }
                });
                return null;
            }
        };
        new Thread((Runnable)creatingReport).start();
        creatingReport.setOnSucceeded(eventValue -> {
            taskUpdateStage.hide();
            this.controller.alert("Obave\u0161tenje", "Uspe\u0161no ste kreirali izve\u0161taj.", this.rootPane.getScene().getWindow());
        });
        creatingReport.setOnFailed(eventValue -> {
            taskUpdateStage.hide();
            this.controller.alert("Gre\u0161ka!", "Do\u0161lo je do gre\u0161ke prilikom izdavanja izve\u0161taja.", this.rootPane.getScene().getWindow());
        });
    }

    private void writeToExcel() {
    }

    private void loadDeferredsList() {
        this.defferedsList = Deferred.getDeferredsList(this.controller, this.tfFilter.getText().trim());
        this.tvDeferred.setItems(this.defferedsList);
    }
}

