/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice;

import java.time.LocalDate;
import java.util.HashMap;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Deferred;
import rs.petcom.master.dal.DeferredRecord;
import rs.petcom.master.dal.Settings;

public class DeferredNewPaymentDialogController
implements DialogController {
    private ScreensController controller;
    private int modalResult;
    private Deferred selectedDeferred;
    @FXML
    private BorderPane rootPane;
    @FXML
    private TextField tfAmount;
    @FXML
    private DatePicker dpDataRecive;

    @Override
    public void setParameter(HashMap<String, Object> parameter) {
        this.tfAmount.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (!newValue.matches("|[-\\+]?|[-\\+]?\\d+\\.?|[-\\+]?\\d+\\.?\\d+")) {
                    DeferredNewPaymentDialogController.this.tfAmount.setText(oldValue);
                }
            }
        });
        this.controller = (ScreensController)parameter.get("controller");
        this.tfAmount.setText("0.00");
        this.dpDataRecive.setValue((Object)LocalDate.now());
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/dialogTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/tabpaneTrgovina.css");
        }
        this.selectedDeferred = (Deferred)parameter.get("selectedDeferred");
    }

    @Override
    public HashMap<String, Object> getParameter() {
        return null;
    }

    @Override
    public int getModalResult() {
        return this.modalResult;
    }

    @Override
    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }

    @FXML
    public void confirm(ActionEvent event) {
        if (this.selectedDeferred != null) {
            DeferredRecord deferredRecord = new DeferredRecord();
            deferredRecord.setAmount(Double.parseDouble(this.tfAmount.getText().trim()));
            deferredRecord.setDateRecive(Settings.fromLocalDate((LocalDate)this.dpDataRecive.getValue()));
            deferredRecord.setDeferredId(this.selectedDeferred.getDeferredId());
            deferredRecord.insert(this.controller);
        }
        ((Stage)((Node)event.getSource()).getScene().getWindow()).close();
    }

    @FXML
    public void cancel(ActionEvent event) {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        ((Stage)((Node)event.getSource()).getScene().getWindow()).close();
    }
}

