/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice;

import java.time.LocalDate;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.scene.control.DatePicker;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.PaymentRecord;
import rs.petcom.master.dal.WorkDay;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.document.DocumentDetails;
import rs.petcom.master.dal.document.DocumentPayment;
import rs.petcom.master.dal.document.DocumentRelationship;

public class DataDeleteController
implements ControlledScreen {
    private ScreensController controller;
    @FXML
    private BorderPane rootPane;
    @FXML
    private DatePicker dpTo;

    @Override
    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    @Override
    public void init() {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/tableTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.dpTo.setValue((Object)LocalDate.now());
    }

    @Override
    public void setParameter(Object parameter) {
    }

    @Override
    public Object getParameter() {
        return null;
    }

    @FXML
    private void actionDeleteAll() {
        Stage taskUpdateStage = this.controller.getSettings().getInfoStage("Brisanje detalja u toku.", this.rootPane.getScene().getWindow());
        Task<Void> loadingCsvTask = new Task<Void>(){

            protected Void call() throws Exception {
                WorkDay wDay = WorkDay.getFromDbByDate((LocalDate)DataDeleteController.this.dpTo.getValue(), DataDeleteController.this.controller.getSettings().getConnection());
                DocumentPayment.deleteAll(wDay, DataDeleteController.this.controller);
                DocumentDetails.deleteAll(wDay, DataDeleteController.this.controller);
                DocumentRelationship.deleteAll(wDay, DataDeleteController.this.controller);
                PaymentRecord.deleteAll(wDay, DataDeleteController.this.controller);
                Document.deleteAll(wDay, DataDeleteController.this.controller);
                return null;
            }
        };
        loadingCsvTask.setOnSucceeded(eventValue -> {
            taskUpdateStage.hide();
            this.controller.alert("Obave\u0161tenje", "Brisanje u bazi zavrseno", this.rootPane.getScene().getWindow());
        });
        loadingCsvTask.setOnFailed(eventValue -> {
            taskUpdateStage.hide();
            this.controller.alert("Obave\u0161tenje", "Neuspe\u0161no brisanje", this.rootPane.getScene().getWindow());
        });
        loadingCsvTask.exceptionProperty().addListener((obs, old, newValue) -> {
            if (newValue != null) {
                Exception ex = (Exception)newValue;
                ex.printStackTrace();
            }
        });
        new Thread((Runnable)loadingCsvTask).start();
    }

    @FXML
    private void actionDeleteBills() {
        Stage taskUpdateStage = this.controller.getSettings().getInfoStage("Brisanje detalja u toku.", this.rootPane.getScene().getWindow());
        Task<Void> loadingCsvTask = new Task<Void>(){

            protected Void call() throws Exception {
                WorkDay wDay = WorkDay.getFromDbByDate((LocalDate)DataDeleteController.this.dpTo.getValue(), DataDeleteController.this.controller.getSettings().getConnection());
                DocumentPayment.deleteAllBills(wDay, DataDeleteController.this.controller);
                DocumentDetails.deleteAllBills(wDay, DataDeleteController.this.controller);
                DocumentRelationship.deleteAllBills(wDay, DataDeleteController.this.controller);
                PaymentRecord.deleteAllBills(wDay, DataDeleteController.this.controller);
                Document.deleteAllBills(wDay, DataDeleteController.this.controller);
                return null;
            }
        };
        loadingCsvTask.setOnSucceeded(eventValue -> {
            taskUpdateStage.hide();
            this.controller.alert("Obave\u0161tenje", "Brisanje u bazi zavrseno", this.rootPane.getScene().getWindow());
        });
        loadingCsvTask.setOnFailed(eventValue -> {
            taskUpdateStage.hide();
            this.controller.alert("Obave\u0161tenje", "Neuspe\u0161no brisanje", this.rootPane.getScene().getWindow());
        });
        loadingCsvTask.exceptionProperty().addListener((obs, old, newValue) -> {
            if (newValue != null) {
                Exception ex = (Exception)newValue;
                ex.printStackTrace();
            }
        });
        new Thread((Runnable)loadingCsvTask).start();
    }
}

