/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice;

import java.util.HashMap;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.company.CompanyConfig;
import rs.petcom.master.dal.person.Address;
import rs.petcom.master.dal.person.AddressType;
import rs.petcom.master.dal.person.Contact;

public class CompanyNewDialogTrgovinaController
implements DialogController {
    ScreensController controller;
    int modalResult;
    HashMap<String, Object> parameter;
    CompanyConfig selectedCompany;
    ObservableList<Contact> contactList;
    Address address;
    @FXML
    private BorderPane rootPane;
    @FXML
    private TextField tfCompanyName;
    @FXML
    private TextField tfAddress;
    @FXML
    private TextField tfZip;
    @FXML
    private TextField tfState;
    @FXML
    private TextField tfCity;
    @FXML
    private TextField tfMunicipality;
    @FXML
    private ComboBox<AddressType> cbAddressType;

    @Override
    public void setParameter(HashMap<String, Object> parameter) {
        this.parameter = parameter;
        this.controller = (ScreensController)parameter.get("controller");
        this.selectedCompany = (CompanyConfig)parameter.get("selectedCompany");
        if (this.controller.getVrstaPrograma() == 4) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/dialogTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/tabpaneTrgovina.css");
        }
        this.cbAddressType.setDisable(true);
        this.fillDataObject(this.selectedCompany);
    }

    @Override
    public HashMap<String, Object> getParameter() {
        return null;
    }

    @Override
    public int getModalResult() {
        return 0;
    }

    @Override
    public void setModalResult(int modalResult) {
    }

    @FXML
    public void cancel() {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        this.parameter.put("selectedCompany", null);
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    @FXML
    public void post() {
        if (this.selectedCompany != null) {
            CompanyConfig config = new CompanyConfig();
            config.setName(this.tfCompanyName.getText());
            config.setAddressID(this.selectedCompany.getAddressID());
            config.update(this.controller);
            Address address = new Address();
            address.setAddressTypeID(((AddressType)this.cbAddressType.getSelectionModel().getSelectedItem()).getAddressTypeID());
            address.setAddress(this.tfAddress.getText());
            address.setCity(this.tfCity.getText());
            address.setState(this.tfState.getText());
            address.setZip(this.tfZip.getText());
            address.setIsPrimary(true);
            address.setActive(true);
            address.setMunicipality(this.tfMunicipality.getText());
            address.setAddressID(this.selectedCompany.getAddressID());
            address.update(this.controller);
        } else {
            Address address = new Address();
            address.setAddressTypeID(((AddressType)this.cbAddressType.getSelectionModel().getSelectedItem()).getAddressTypeID());
            address.setAddress(this.tfAddress.getText());
            address.setCity(this.tfCity.getText());
            address.setState(this.tfState.getText());
            address.setZip(this.tfZip.getText());
            address.setIsPrimary(true);
            address.setActive(true);
            address.setMunicipality(this.tfMunicipality.getText());
            long addressNumber = address.insert(this.controller);
            CompanyConfig config = new CompanyConfig();
            config.setName(this.tfCompanyName.getText());
            config.setAddressID(addressNumber);
            config.insert(this.controller);
        }
        this.modalResult = ScreensController.MODAL_RESULT_OK;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    private void fillDataObject(CompanyConfig selectedCompany) {
        if (selectedCompany != null) {
            this.address = Address.getByID(selectedCompany.getAddressID(), this.controller.getSettings().getConnection());
            this.tfCompanyName.setText(CompanyConfig.getByID(selectedCompany.getCompanyConfigID(), this.controller).getName());
            this.tfAddress.setText(this.address.getAddress());
            this.tfZip.setText(this.address.getZip());
            this.tfState.setText(this.address.getState());
            this.tfCity.setText(this.address.getCity());
            this.tfMunicipality.setText(this.address.getMunicipality());
            for (AddressType addressType : AddressType.getList(this.controller)) {
                this.cbAddressType.getItems().add((Object)addressType);
                if (addressType.getAddressTypeID() != this.address.getAddressTypeID()) continue;
                this.cbAddressType.getSelectionModel().select((Object)addressType);
            }
        } else {
            this.tfCompanyName.setText("");
            this.tfAddress.setText("");
            this.tfZip.setText("");
            this.tfState.setText("");
            this.tfCity.setText("");
            this.tfMunicipality.setText("");
            for (AddressType addressType : AddressType.getList(this.controller)) {
                this.cbAddressType.getItems().add((Object)addressType);
                this.cbAddressType.getSelectionModel().select(0);
            }
        }
    }
}

