/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice;

import java.util.HashMap;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.util.Callback;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.person.CashBuyer;

public class CashBuyerSelectDialogController
implements DialogController {
    private int modalResult = ScreensController.MODAL_RESULT_CANCEL;
    private HashMap<String, Object> parameters;
    private ScreensController controller;
    private ObservableList<CashBuyer> cashBuyersList = FXCollections.observableArrayList();
    private CashBuyer selectedCashBuyer = null;
    @FXML
    private BorderPane rootPane;
    @FXML
    private TableView<CashBuyer> table;
    @FXML
    private TableColumn<CashBuyer, String> tcName;
    @FXML
    private TableColumn<CashBuyer, String> tcPib;
    @FXML
    private TextField tfFilter;
    @FXML
    private Button btnNewPerson;

    @Override
    public void setParameter(HashMap<String, Object> parameter) {
        this.parameters = parameter;
        this.selectedCashBuyer = (CashBuyer)parameter.get("cashBuyers");
        this.controller = (ScreensController)parameter.get("controller");
        if (this.controller.getVrstaPrograma() == 4) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/dialogTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.populateTable();
        this.tfFilter.setText("");
        this.tfFilter.requestFocus();
        this.tfFilter.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                CashBuyerSelectDialogController.this.loadCashBuyersList();
            }
        });
    }

    @Override
    public HashMap<String, Object> getParameter() {
        return this.parameters;
    }

    @Override
    public int getModalResult() {
        return this.modalResult;
    }

    @Override
    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }

    @FXML
    public void newCashBuyer() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("controller", this.controller);
        int result = this.controller.showModalDialog("Dodavanje komitenta", ScreensController.DIALOG_ADD_CASH_BUYER, hashMap, this.rootPane.getScene().getWindow());
        if (result == ScreensController.MODAL_RESULT_OK) {
            this.table.getItems().add((Object)((CashBuyer)hashMap.get("cashBuyer")));
            this.table.getSelectionModel().select((Object)((CashBuyer)hashMap.get("cashBuyer")));
            this.loadCashBuyersList();
        }
    }

    @FXML
    public void cancel(ActionEvent evt) {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        Node source = (Node)evt.getSource();
        Stage stage = (Stage)source.getScene().getWindow();
        stage.close();
    }

    @FXML
    public void confirm() {
        if (this.table.getSelectionModel().getSelectedItem() != null) {
            this.selectedCashBuyer = (CashBuyer)this.table.getSelectionModel().getSelectedItem();
        }
        this.modalResult = ScreensController.MODAL_RESULT_OK;
        this.parameters.put("cashBuyer", this.selectedCashBuyer);
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    @FXML
    public void mouseClick(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            this.modalResult = ScreensController.MODAL_RESULT_OK;
            this.selectedCashBuyer = (CashBuyer)this.table.getSelectionModel().getSelectedItem();
            this.parameters.put("cashBuyer", this.selectedCashBuyer);
            ((Stage)((Node)evt.getSource()).getScene().getWindow()).close();
        }
    }

    private void populateTable() {
        for (CashBuyer cashBuyer : CashBuyer.getCashBuyerList(this.controller.getSettings().getConnection())) {
            this.table.getItems().add((Object)cashBuyer);
            try {
                if (cashBuyer.getCashBuyerID() != this.selectedCashBuyer.getCashBuyerID()) continue;
                this.table.getSelectionModel().select((Object)cashBuyer);
            }
            catch (NullPointerException nullPointerException) {}
        }
    }

    public void initialize() {
        this.tcName.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        this.tcPib.setCellValueFactory((Callback)new PropertyValueFactory("PIB"));
    }

    private void loadCashBuyersList() {
        this.cashBuyersList = CashBuyer.getCashBuyerList(this.tfFilter.getText(), this.controller.getSettings().getConnection());
        this.table.setItems(this.cashBuyersList);
    }
}

