/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice;

import java.sql.SQLException;
import java.util.HashMap;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.person.CashBuyer;

public class CashBuyerNewDialogController
implements DialogController {
    private ScreensController controller;
    private int modalResult;
    private HashMap<String, Object> parameter;
    private CashBuyer selectedBuyer;
    @FXML
    private TextField tfNaziv;
    @FXML
    private TextField tfMB;
    @FXML
    private TextField tfPIB;
    @FXML
    private TextField tfAddress;
    @FXML
    private TextField tfZip;
    @FXML
    private TextField tfCity;
    @FXML
    private BorderPane rootPane;
    @FXML
    private Label lblTitle;

    @Override
    public void setParameter(HashMap<String, Object> parameter) {
        this.parameter = parameter;
        this.controller = (ScreensController)parameter.get("controller");
        this.lblTitle.setText((String)this.parameter.get("title"));
        this.selectedBuyer = (CashBuyer)parameter.get("selectedBuyer");
        if (this.controller.getVrstaPrograma() == 4) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/dialogTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        if (this.selectedBuyer != null) {
            this.fillCashBuyerData(this.selectedBuyer);
        }
    }

    @Override
    public HashMap<String, Object> getParameter() {
        return null;
    }

    @Override
    public int getModalResult() {
        return this.modalResult;
    }

    @Override
    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }

    @FXML
    public void cancel(ActionEvent event) {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        ((Stage)((Node)event.getSource()).getScene().getWindow()).close();
    }

    @FXML
    public void post(ActionEvent evt) {
        CashBuyer buyer = new CashBuyer();
        buyer.setName(this.tfNaziv.getText());
        buyer.setPIB(this.tfPIB.getText());
        buyer.setMB(this.tfMB.getText().trim());
        buyer.setAddress(this.tfAddress.getText());
        buyer.setCity(this.tfCity.getText());
        buyer.setZIP(this.tfZip.getText());
        buyer.setSysUserAddID(this.controller.getUser().getSysUserAddID());
        if (this.selectedBuyer == null) {
            try {
                buyer.insert(this.controller.getSettings().getConnection());
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        } else {
            buyer.setCashBuyerID(this.selectedBuyer.getCashBuyerID());
            try {
                buyer.update(this.controller.getSettings().getConnection());
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        this.parameter.put("buyer", buyer);
        this.modalResult = ScreensController.MODAL_RESULT_OK;
        ((Stage)((Node)evt.getSource()).getScene().getWindow()).close();
    }

    private void fillCashBuyerData(CashBuyer cashBuyer) {
        this.tfNaziv.setText(cashBuyer.getName());
        this.tfPIB.setText(cashBuyer.getPIB());
        this.tfMB.setText(cashBuyer.getMB());
        this.tfAddress.setText(cashBuyer.getAddress());
        this.tfZip.setText(cashBuyer.getZIP());
        this.tfCity.setText(cashBuyer.getCity());
    }
}

