/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice;

import java.io.File;
import java.util.Date;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.stage.FileChooser;
import javafx.util.Callback;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.PriceList;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.product.Product;

public class BoPriceListController
implements ControlledScreen {
    private ScreensController controller;
    private rs.petcom.master.dal.Object sviObjekti = new rs.petcom.master.dal.Object(-1, "Svi objekti");
    ObservableList<Product> productList;
    @FXML
    private TableView<PriceList> priceListTable;
    @FXML
    private TableColumn<PriceList, String> titleCol;
    @FXML
    private TableColumn<PriceList, Boolean> activeCol;
    @FXML
    private TableColumn<PriceList, Date> dateFromCol;
    @FXML
    private TableColumn<PriceList, Date> dateToCol;
    @FXML
    private TableColumn<PriceList, Integer> priorityCol;
    @FXML
    private BorderPane rootPane;
    @FXML
    private CheckBox cbActivePriceList;
    @FXML
    private ComboBox<rs.petcom.master.dal.Object> cbObject;

    @Override
    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    @Override
    public void setParameter(Object parameter) {
    }

    @Override
    public Object getParameter() {
        return null;
    }

    public void initialize() {
        this.cbActivePriceList.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (oldValue.booleanValue()) {
                    BoPriceListController.this.priceListTable.getItems().clear();
                    BoPriceListController.this.priceListTable.setItems(PriceList.getObeservableList(newValue, (rs.petcom.master.dal.Object)BoPriceListController.this.cbObject.getSelectionModel().getSelectedItem(), BoPriceListController.this.controller.getSettings().getConnection()));
                } else {
                    BoPriceListController.this.priceListTable.getItems().clear();
                    BoPriceListController.this.priceListTable.setItems(PriceList.getObeservableListPregled(newValue, (rs.petcom.master.dal.Object)BoPriceListController.this.cbObject.getSelectionModel().getSelectedItem(), BoPriceListController.this.controller.getSettings().getConnection()));
                }
            }
        });
    }

    @Override
    public void init() {
        if (this.controller.getVrstaPrograma() == 4) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/master/css/trgovina/tableTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/master/css/trgovina/backofficeTrgovina.css");
        }
        this.loadObject();
        this.priceListTable.setItems(PriceList.getObeservableListPregled(this.cbActivePriceList.isSelected(), (rs.petcom.master.dal.Object)this.cbObject.getSelectionModel().getSelectedItem(), this.controller.getSettings().getConnection()));
        this.titleCol.setCellValueFactory((Callback)new PropertyValueFactory("Title"));
        this.activeCol.setCellValueFactory((Callback)new PropertyValueFactory("Active"));
        this.activeCol.setCellFactory(column -> new TableCell<PriceList, Boolean>(){

            protected void updateItem(Boolean item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (!empty) {
                    if (!item.booleanValue()) {
                        this.setText("Ne");
                    } else {
                        this.setText("Da");
                    }
                } else {
                    this.setText("");
                }
            }
        });
        this.dateFromCol.setCellValueFactory((Callback)new PropertyValueFactory("DateFrom"));
        this.dateFromCol.setCellFactory(column -> new TableCell<PriceList, Date>(){

            protected void updateItem(Date item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Settings.getDateFromatter().format(item));
                }
            }
        });
        this.dateToCol.setCellValueFactory((Callback)new PropertyValueFactory("DateTo"));
        this.dateToCol.setCellFactory(column -> new TableCell<PriceList, Date>(){

            protected void updateItem(Date item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Settings.getDateFromatter().format(item));
                }
            }
        });
        this.priorityCol.setCellValueFactory((Callback)new PropertyValueFactory("Priority"));
        this.priceListTable.setPlaceholder((Node)new Label(""));
    }

    @FXML
    private void showPriceListAction() {
        this.onBtnSave();
    }

    private void onBtnSave() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Sa\u010duvaj kao...");
        fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("EXCEL files (*.xlsx)", new String[]{"*.XLSX"}), new FileChooser.ExtensionFilter("CSV files (*.csv)", new String[]{"*.CSV"})});
        File file = fileChooser.showSaveDialog(this.rootPane.getScene().getWindow());
        if (fileChooser.getSelectedExtensionFilter() != null && fileChooser.getSelectedExtensionFilter().getExtensions() != null) {
            int pitanje;
            List selectedExtension = fileChooser.getSelectedExtensionFilter().getExtensions();
            int extensionLength = 0;
            if (selectedExtension.contains("*.CSV")) {
                extensionLength = 4;
            }
            if (selectedExtension.contains("*.XLSX")) {
                extensionLength = 5;
            }
            String nameWithoutExt = file.getName().substring(0, file.getName().length() - extensionLength);
            String pathWithoutExt = file.getAbsolutePath().substring(0, file.getAbsolutePath().length() - extensionLength);
            String pathWithoutName = pathWithoutExt.substring(0, pathWithoutExt.lastIndexOf(nameWithoutExt) - 1);
            this.productList = Product.getProductByPriceList(this.controller, ((PriceList)this.priceListTable.getSelectionModel().getSelectedItem()).getPriceListID());
            if (selectedExtension.contains("*.CSV")) {
                Product.getProductToExcelByPriceList(this.controller, this.productList, nameWithoutExt, pathWithoutName);
            }
            if (selectedExtension.contains("*.XLSX")) {
                Product.getProductToExcelByPriceList(this.controller, this.productList, nameWithoutExt, pathWithoutName);
            }
            if ((pitanje = this.controller.yesNoDialog("Pitanje", "Da li zelite da prikazete izvestaj? (Do you wanna show report?)", this.rootPane.getScene().getWindow())) == 1) {
                FileChooser fileOpenChooser = new FileChooser();
                fileOpenChooser.setTitle("Open");
                FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("XML files (*.xlsx)", new String[]{"*.xlsx", "*.xls"});
                fileOpenChooser.getExtensionFilters().add((Object)extFilter);
                File userDirectory = new File(pathWithoutName);
                if (!userDirectory.canRead()) {
                    userDirectory = new File("c:/");
                }
                fileOpenChooser.setInitialDirectory(userDirectory);
                File chosenFile = fileOpenChooser.showOpenDialog(null);
                this.controller.printFileFromPDF(chosenFile);
            }
        }
        Task<Boolean> task = new Task<Boolean>(){

            protected Boolean call() throws Exception {
                return false;
            }
        };
        task.run();
    }

    private void loadObject() {
        this.cbObject.getItems().add((Object)this.sviObjekti);
        for (rs.petcom.master.dal.Object o : rs.petcom.master.dal.Object.getList(this.controller.getSettings().getConnection())) {
            this.cbObject.getItems().add((Object)o);
        }
        if (this.cbObject.getItems().size() == 2) {
            this.cbObject.getSelectionModel().select(1);
        } else {
            this.cbObject.getSelectionModel().select((Object)this.sviObjekti);
        }
    }
}

