/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller;

import java.util.HashMap;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;

public class YesNoDialogController
implements DialogController {
    @FXML
    private BorderPane rootPane;
    @FXML
    private Button dialogNo;
    @FXML
    private Button dialogYes;
    @FXML
    private Label dialogText;
    @FXML
    private Label dialogTitle;
    EventHandler<KeyEvent> handler = new EventHandler<KeyEvent>(){

        public void handle(KeyEvent event) {
            switch (event.getCode()) {
                case RIGHT: {
                    event.consume();
                    YesNoDialogController.this.dialogYes.requestFocus();
                    break;
                }
                case LEFT: {
                    event.consume();
                    YesNoDialogController.this.dialogNo.requestFocus();
                    break;
                }
                case ENTER: {
                    event.consume();
                    YesNoDialogController.this.confirm();
                    break;
                }
            }
        }
    };
    HashMap<String, Object> parameter;
    int modalResult = ScreensController.MODAL_RESULT_CANCEL;

    @FXML
    public void closeAction(ActionEvent event) {
        this.modalResult = event.getSource() == this.dialogNo ? ScreensController.MODAL_RESULT_NO : ScreensController.MODAL_RESULT_YES;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    public void confirm() {
        if (this.dialogNo.isFocused()) {
            this.modalResult = ScreensController.MODAL_RESULT_NO;
        } else {
            this.modalResult = ScreensController.MODAL_RESULT_YES;
            ((Stage)this.rootPane.getScene().getWindow()).close();
        }
    }

    @Override
    public void setParameter(HashMap<String, Object> parameter) {
        this.parameter = parameter;
        this.rootPane.getStylesheets().clear();
        this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        this.rootPane.setOnKeyPressed(this.handler);
        this.dialogTitle.setText(parameter.get("title").toString());
        this.dialogText.setText(parameter.get("text").toString());
    }

    @Override
    public HashMap<String, Object> getParameter() {
        return this.parameter;
    }

    @Override
    public int getModalResult() {
        return this.modalResult;
    }

    @Override
    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }
}

