/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller;

import java.io.IOException;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.logging.Logger;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ToggleButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import javafx.util.Duration;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Bill;
import rs.petcom.master.dal.Log;
import rs.petcom.master.dal.PaymentMethod;
import rs.petcom.master.dal.WorkDay;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.document.DocumentCorrection;
import rs.petcom.master.dal.document.DocumentPayment;
import rs.petcom.master.dal.document.Faktura;
import rs.petcom.master.dal.document.Order;
import rs.petcom.master.dal.document.OrderDetaile;
import rs.petcom.master.dal.person.Person;
import rs.petcom.master.fical.FiscalPrinter;
import rs.petcom.print.PosPrinter;

public class PaymentController
implements ControlledScreen {
    private static final Logger LOGGER = Logger.getLogger("global");
    private ScreensController controller;
    private String stringValue = "";
    private Timeline timerSat;
    private DecimalFormat numberFormat = (DecimalFormat)DecimalFormat.getNumberInstance();
    private final SimpleDateFormat formatClock = new SimpleDateFormat("HH:mm:ss");
    private double ukupno = 0.0;
    private double uplaceno = 0.0;
    private double discount = 0.0;
    private double gotovina = 0.0;
    private double kartica = 0.0;
    private double cek = 0.0;
    private double virman = 0.0;
    private double ostatak = 0.0;
    private int selectedPaymentMethod = -1;
    @FXML
    BorderPane rootPane;
    @FXML
    Label userLabel;
    @FXML
    Label lokacijaLabel;
    @FXML
    Label clockLabel;
    @FXML
    Button cancelButton;
    @FXML
    Button postButton;
    @FXML
    ToggleButton paymentButton0;
    @FXML
    ToggleButton paymentButton1;
    @FXML
    ToggleButton paymentButton2;
    @FXML
    ToggleButton paymentButton3;
    @FXML
    ToggleButton paymentButton4;
    @FXML
    ToggleButton paymentButton5;
    @FXML
    ToggleButton paymentButton6;
    @FXML
    ToggleButton paymentButton7;
    @FXML
    ToggleButton cPaymentButton0;
    @FXML
    ToggleButton cPaymentButton1;
    @FXML
    ToggleButton cPaymentButton2;
    @FXML
    ToggleButton cPaymentButton3;
    @FXML
    ToggleButton cPaymentButton4;
    @FXML
    ToggleButton cPaymentButton5;
    @FXML
    ToggleButton cPaymentButton6;
    @FXML
    ToggleButton cPaymentButton7;
    @FXML
    Button numpad0;
    @FXML
    Button numpad1;
    @FXML
    Button numpad2;
    @FXML
    Button numpad3;
    @FXML
    Button numpad4;
    @FXML
    Button numpad5;
    @FXML
    Button numpad6;
    @FXML
    Button numpad7;
    @FXML
    Button numpad8;
    @FXML
    Button numpad9;
    @FXML
    Button numpad00;
    @FXML
    Button numpadDel;
    @FXML
    Label labelUplaceno;
    @FXML
    Label labelKusur;
    @FXML
    Label labelUkupno;
    @FXML
    Label labelPerson;
    @FXML
    Label labelDiscount;
    @FXML
    VBox combinedPane;
    @FXML
    ToggleButton combinedButton;
    @FXML
    Label labelGotovina;
    @FXML
    Label labelGotovinaValue;
    @FXML
    Label Value;
    @FXML
    Label labelKarticaValue;
    @FXML
    Label labelCek;
    @FXML
    Label labelCekValue;
    @FXML
    Label labelVirman;
    @FXML
    Label labelVirmanValue;
    @FXML
    Label labelOstatak;
    @FXML
    Label labelOstatakValue;
    @FXML
    ToggleButton stampaGotovinskog;
    @FXML
    ToggleButton uskaStampaGotovinskog;

    @Override
    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    @Override
    public void setParameter(Object parameter) {
    }

    @Override
    public Object getParameter() {
        return null;
    }

    @Override
    public void init() {
        this.timerSat = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)1.0), (EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                PaymentController.this.clockLabel.setText(PaymentController.this.formatClock.format(new Date()));
            }
        }, new KeyValue[0])});
        this.timerSat.setCycleCount(-1);
        this.timerSat.play();
        this.numberFormat.setMaximumFractionDigits(2);
        this.numberFormat.setMinimumFractionDigits(2);
        this.numberFormat.setGroupingUsed(true);
        this.fillPaymentMethodButtons();
        this.fillCPaymentMethodButtons();
        this.ukupno = 0.0;
        this.uplaceno = 0.0;
        this.discount = 0.0;
        this.gotovina = 0.0;
        this.kartica = 0.0;
        this.cek = 0.0;
        this.virman = 0.0;
        this.ostatak = 0.0;
        this.stringValue = "";
        try {
            this.discount = this.controller.getBillList().get(this.controller.getActiveBill()).getPerson().getDiscount() / 100.0;
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.ukupno = this.controller.getBillList().get(this.controller.getActiveBill()).getSumWithDiscout() * (1.0 - this.discount);
        this.labelUkupno.setText(this.numberFormat.format(this.ukupno));
        this.labelUplaceno.setText(this.numberFormat.format(this.uplaceno));
        this.labelKusur.setText(this.numberFormat.format(this.ukupno));
        if (this.controller.getBillList().get(this.controller.getActiveBill()).getPerson() != null) {
            try {
                if (!this.controller.getBillList().get(this.controller.getActiveBill()).getPerson().getName().equals("")) {
                    this.labelPerson.setText(this.controller.getBillList().get(this.controller.getActiveBill()).getPerson().getName());
                } else {
                    this.labelPerson.setText(this.controller.getBillList().get(this.controller.getActiveBill()).getPerson().getFirstLastName());
                }
                this.labelDiscount.setText(this.numberFormat.format(this.discount * 100.0) + " %");
            }
            catch (NullPointerException e) {
                if (!this.controller.getBillList().get(this.controller.getActiveBill()).getPerson().getFirstLastName().equals("")) {
                    this.labelPerson.setText(this.controller.getBillList().get(this.controller.getActiveBill()).getPerson().getFirstLastName());
                }
                this.labelPerson.setText(this.controller.getBillList().get(this.controller.getActiveBill()).getPerson().getFirstLastName());
            }
        }
        this.userLabel.setText(this.controller.getUser().getUserName());
        this.lokacijaLabel.setText(this.controller.getPointOfSale().getName());
        this.clockLabel.setText(this.formatClock.format(new Date()));
        this.controller.getCurrentBill().setPaymentMethod(PaymentMethod.getByCode("CASH", this.controller.getSettings().getConnection()));
        this.paymentButton0.setSelected(true);
        this.combinedButton.setSelected(false);
        this.combinedPane.setVisible(false);
    }

    @FXML
    private void numButtonClick(ActionEvent event) {
        String decSep = "" + this.numberFormat.getDecimalFormatSymbols().getDecimalSeparator();
        String[] red = this.stringValue.split(decSep);
        if (red.length == 1 || red.length > 1 && red[1].length() < 2) {
            if (this.stringValue.equals("0" + decSep + "00")) {
                this.stringValue = "";
            }
            if ((Button)event.getSource() == this.numpad0) {
                this.stringValue = this.stringValue + "0";
            }
            if ((Button)event.getSource() == this.numpad1) {
                this.stringValue = this.stringValue + "1";
            }
            if ((Button)event.getSource() == this.numpad2) {
                this.stringValue = this.stringValue + "2";
            }
            if ((Button)event.getSource() == this.numpad3) {
                this.stringValue = this.stringValue + "3";
            }
            if ((Button)event.getSource() == this.numpad4) {
                this.stringValue = this.stringValue + "4";
            }
            if ((Button)event.getSource() == this.numpad5) {
                this.stringValue = this.stringValue + "5";
            }
            if ((Button)event.getSource() == this.numpad6) {
                this.stringValue = this.stringValue + "6";
            }
            if ((Button)event.getSource() == this.numpad7) {
                this.stringValue = this.stringValue + "7";
            }
            if ((Button)event.getSource() == this.numpad8) {
                this.stringValue = this.stringValue + "8";
            }
            if ((Button)event.getSource() == this.numpad9) {
                this.stringValue = this.stringValue + "9";
            }
            if ((Button)event.getSource() == this.numpad00) {
                this.stringValue = this.stringValue + "00";
            }
        }
        if ((Button)event.getSource() == this.numpadDel && this.stringValue.length() > 0) {
            this.stringValue = this.stringValue.substring(0, this.stringValue.length() - 1);
            if (this.stringValue.endsWith(decSep)) {
                this.stringValue = this.stringValue.substring(0, this.stringValue.length() - 1);
            }
        }
        if (this.stringValue.equals("")) {
            this.stringValue = "0";
        }
        if (!this.combinedButton.isSelected()) {
            try {
                this.uplaceno = this.numberFormat.parse(this.stringValue).doubleValue();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            this.labelUplaceno.setText(this.numberFormat.format(this.uplaceno));
            this.labelKusur.setText(this.numberFormat.format(this.uplaceno - this.ukupno));
        }
        if (this.selectedPaymentMethod == 0) {
            try {
                this.gotovina = this.numberFormat.parse(this.stringValue).doubleValue();
                this.ostatak = this.ukupno - this.gotovina - this.kartica - this.cek - this.virman;
            }
            catch (ParseException e) {
                Log.writeLog(this.controller.getUser(), "Error: " + e.getMessage(), this.controller.getSettings().getConnection());
                LOGGER.severe(e.getMessage());
            }
            this.labelGotovinaValue.setText(this.numberFormat.format(this.gotovina));
        }
        if (this.selectedPaymentMethod == 1) {
            try {
                this.kartica = this.numberFormat.parse(this.stringValue).doubleValue();
                this.ostatak = this.ukupno - this.gotovina - this.kartica - this.cek - this.virman;
            }
            catch (ParseException e) {
                Log.writeLog(this.controller.getUser(), "Error: " + e.getMessage(), this.controller.getSettings().getConnection());
                LOGGER.severe(e.getMessage());
            }
            this.labelKarticaValue.setText(this.numberFormat.format(this.kartica));
        }
        if (this.selectedPaymentMethod == 2) {
            try {
                this.cek = this.numberFormat.parse(this.stringValue).doubleValue();
                this.ostatak = this.ukupno - this.gotovina - this.kartica - this.cek - this.virman;
            }
            catch (ParseException e) {
                Log.writeLog(this.controller.getUser(), "Error: " + e.getMessage(), this.controller.getSettings().getConnection());
                LOGGER.severe(e.getMessage());
            }
            this.labelCekValue.setText(this.numberFormat.format(this.cek));
        }
        if (this.selectedPaymentMethod == 3) {
            try {
                this.virman = this.numberFormat.parse(this.stringValue).doubleValue();
                this.ostatak = this.ukupno - this.gotovina - this.kartica - this.cek - this.virman;
            }
            catch (ParseException e) {
                Log.writeLog(this.controller.getUser(), "Error: " + e.getMessage(), this.controller.getSettings().getConnection());
                LOGGER.severe(e.getMessage());
            }
            this.labelVirmanValue.setText(this.numberFormat.format(this.virman));
        }
        if (this.selectedPaymentMethod > 0) {
            this.labelOstatakValue.setText(this.numberFormat.format(this.ostatak));
        }
    }

    @FXML
    private void gotovinaClicked() {
        if (this.ostatak != 0.0) {
            this.gotovina = this.ostatak;
        }
        this.ostatak = 0.0;
        this.labelOstatakValue.setText(this.numberFormat.format(this.ostatak));
        this.labelGotovinaValue.setText(this.numberFormat.format(this.gotovina));
        this.selectedPaymentMethod = 0;
        this.stringValue = this.numberFormat.format(this.gotovina);
        this.unselectCombined();
        this.labelGotovinaValue.getStyleClass().add((Object)"backGroundOrange");
        this.labelGotovinaValue.getStyleClass().remove((Object)"backGroundTransparent");
    }

    @FXML
    private void karticaClicked() {
        if (this.ostatak != 0.0) {
            this.kartica = this.ostatak;
        }
        this.ostatak = 0.0;
        this.labelOstatakValue.setText(this.numberFormat.format(this.ostatak));
        this.labelKarticaValue.setText(this.numberFormat.format(this.kartica));
        this.selectedPaymentMethod = 1;
        this.stringValue = this.numberFormat.format(this.kartica);
        this.unselectCombined();
        this.labelKarticaValue.getStyleClass().add((Object)"backGroundOrange");
        this.labelKarticaValue.getStyleClass().remove((Object)"backGroundTransparent");
    }

    @FXML
    private void cekClicked() {
        if (this.ostatak != 0.0) {
            this.cek = this.ostatak;
        }
        this.ostatak = 0.0;
        this.labelOstatakValue.setText(this.numberFormat.format(this.ostatak));
        this.labelCekValue.setText(this.numberFormat.format(this.cek));
        this.selectedPaymentMethod = 2;
        this.stringValue = this.labelCekValue.getText();
        this.unselectCombined();
        this.labelCekValue.getStyleClass().add((Object)"backGroundOrange");
        this.labelCekValue.getStyleClass().remove((Object)"backGroundTransparent");
    }

    @FXML
    private void virmanClicked() {
        if (this.ostatak != 0.0) {
            this.virman = this.ostatak;
        }
        this.ostatak = 0.0;
        this.labelOstatakValue.setText(this.numberFormat.format(this.ostatak));
        this.labelVirmanValue.setText(this.numberFormat.format(this.virman));
        this.selectedPaymentMethod = 3;
        this.stringValue = this.labelVirmanValue.getText();
        this.unselectCombined();
        this.labelVirmanValue.getStyleClass().add((Object)"backGroundOrange");
        this.labelVirmanValue.getStyleClass().remove((Object)"backGroundTransparent");
    }

    private void unselectCombined() {
        this.labelGotovinaValue.getStyleClass().remove((Object)"backGroundOrange");
        this.labelKarticaValue.getStyleClass().remove((Object)"backGroundOrange");
        this.labelCekValue.getStyleClass().remove((Object)"backGroundOrange");
        this.labelVirmanValue.getStyleClass().remove((Object)"backGroundOrange");
        this.labelGotovinaValue.getStyleClass().add((Object)"backGroundTransparent");
        this.labelKarticaValue.getStyleClass().add((Object)"backGroundTransparent");
        this.labelCekValue.getStyleClass().add((Object)"backGroundTransparent");
        this.labelVirmanValue.getStyleClass().add((Object)"backGroundTransparent");
    }

    @FXML
    public void logout() {
        Log.logOut(this.controller.getUser().getUserID(), this.controller.getPointOfSale().getPointOfSaleID(), this.controller.getSettings().getConnection());
        this.controller.setUser(null);
        this.controller.setBillList(new ArrayList<Bill>());
        this.controller.getScreen(ScreensController.SCREEN_LOGIN, this.controller.getRoot(), ScreensController.SCREEN_PAYMENT);
    }

    @FXML
    public void toggleButtonClick(ActionEvent event) {
        ToggleButton button = (ToggleButton)event.getSource();
        button.setSelected(true);
        try {
            if (!button.getText().equals("")) {
                PaymentMethod pm = PaymentMethod.getByName(button.getText(), this.controller.getSettings().getConnection());
                this.controller.getCurrentBill().setPaymentMethod(pm);
                if (pm.isComplex()) {
                    HashMap<String, Object> hm = new HashMap<String, Object>();
                    hm.put("controller", this.controller);
                    this.controller.showModalDialog("Izbor na\ufffdina pla\ufffdanja", ScreensController.SCREEN_PAYMENT_METHOD_SELECTION, hm, this.rootPane.getScene().getWindow());
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @FXML
    public void combinedButtonClick() {
        if (this.combinedButton.isSelected()) {
            this.labelGotovinaValue.setText(this.numberFormat.format(0.0));
            this.labelKarticaValue.setText(this.numberFormat.format(0.0));
            this.labelCekValue.setText(this.numberFormat.format(0.0));
            this.labelVirmanValue.setText(this.numberFormat.format(0.0));
            this.labelOstatakValue.setText(this.numberFormat.format(0.0));
            this.combinedPane.setVisible(this.combinedButton.isSelected());
            NumberFormat form = NumberFormat.getInstance();
            double GotovinaValue = 0.0;
            double KarticaValue = 0.0;
            double CekValue = 0.0;
            double VirmanValue = 0.0;
            try {
                GotovinaValue = form.parse(this.labelGotovinaValue.getText()).doubleValue();
            }
            catch (ParseException e) {
                GotovinaValue = 0.0;
            }
            try {
                KarticaValue = form.parse(this.labelKarticaValue.getText()).doubleValue();
            }
            catch (ParseException e) {
                KarticaValue = 0.0;
            }
            try {
                CekValue = form.parse(this.labelCekValue.getText()).doubleValue();
            }
            catch (ParseException e) {
                CekValue = 0.0;
            }
            try {
                VirmanValue = form.parse(this.labelVirmanValue.getText()).doubleValue();
            }
            catch (ParseException e) {
                VirmanValue = 0.0;
            }
            double zbir = GotovinaValue + KarticaValue + CekValue + VirmanValue;
            if (this.ostatak == 0.0) {
                this.ostatak = this.ukupno;
                this.labelOstatakValue.setText(this.numberFormat.format(this.ostatak));
            } else if (this.ukupno > zbir && zbir > 0.0 && this.ostatak > 0.0) {
                this.labelOstatakValue.setText(this.numberFormat.format(this.ukupno - zbir));
            } else {
                this.controller.alert("Obavestenje", "Cena za naplatu je manja od iskombinovane cene", this.rootPane.getScene().getWindow());
            }
            this.controller.getCurrentBill().setPaymentMethod(PaymentMethod.getByCode("COMBINED", this.controller.getSettings().getConnection()));
        } else {
            this.combinedPane.setVisible(false);
            this.ostatak = 0.0;
        }
    }

    @FXML
    public void cancelButton() {
        this.controller.getScreen(ScreensController.SCREEN_FASTFOOD, this.controller.getRoot(), ScreensController.SCREEN_PAYMENT);
    }

    @FXML
    public void postButtonClick() {
        int mr;
        System.out.println("eve me");
        long personID = -1L;
        double personDiscount = 0.0;
        if (!this.cPaymentButton0.isSelected() && !this.cPaymentButton1.isSelected() && !this.combinedButton.isSelected() && this.ukupno > this.uplaceno) {
            this.controller.alert("Neispravan uneti napla\ufffdeni iznos.", "Ukupan napla\ufffdeni iznos NE MO\ufffdE biti manji od ukupnog iznosa ra\ufffduna", this.rootPane.getScene().getWindow());
            return;
        }
        if (this.controller.getCurrentBill().getPaymentMethod().getPaymentMethodID() == 5) {
            HashMap<String, Object> hm = new HashMap<String, Object>();
            hm.put("controller", this.controller);
            int result = this.controller.showModalDialog("Izbor komitenta", ScreensController.DIALOG_SELECT_PERSON, hm, this.rootPane.getScene().getWindow());
            if (result == ScreensController.MODAL_RESULT_OK) {
                personID = ((Person)hm.get("person")).getPersonID();
                personDiscount = ((Person)hm.get("person")).getDiscount();
                this.labelUkupno.setText(this.numberFormat.format(this.ukupno - this.ukupno * personDiscount / 100.0));
                this.labelUplaceno.setText(this.numberFormat.format(this.uplaceno - this.uplaceno * personDiscount / 100.0));
            } else {
                this.controller.alert("Obavestenje", "Morate uneti komitenta ako zelite fakturu ili promenite nacin placanja", this.rootPane.getScene().getWindow());
                return;
            }
        }
        if (this.controller.getCurrentBill().getLastRound().getItemList().size() == 0) {
            FiscalPrinter.openCassBox(this.controller);
            this.postButton.setDisable(false);
            return;
        }
        if (this.controller.getCurrentBill().getPaymentMethod().getPaymentMethodID() == 3 && this.paymentButton1.isSelected()) {
            this.controller.setAuthorizationRequest(8);
            HashMap<String, Object> hm2 = new HashMap<String, Object>();
            hm2.put("controller", this.controller);
            mr = this.controller.showModalDialog("Autorizacija", ScreensController.SCREEN_AUTHORISATION, hm2, this.rootPane.getScene().getWindow());
            if (mr != ScreensController.MODAL_RESULT_OK) {
                this.postButton.setDisable(false);
                return;
            }
        }
        if (this.controller.getCurrentBill().getPaymentMethod().getParentPaymentMethodID() == 0 && (!this.combinedButton.isSelected() || this.combinedButton.isSelected() && this.ostatak == 0.0 || !this.combinedButton.isSelected() && this.ostatak == 0.0)) {
            if (this.combinedButton.isSelected() && this.ostatak != 0.0) {
                this.controller.alert("Neispravan usnos kombinovanog pla\ufffdanja.", "Izabrano je kombinovano pla\ufffdanje, a suma na\ufffdina pla\ufffdanja nije jednaka sumi ra\ufffduna.", this.rootPane.getScene().getWindow());
            }
            try {
                boolean posResult;
                long orderId;
                long documentId = Bill.writeBill(this.controller.getBillList().get(this.controller.getActiveBill()), this.controller.getPointOfSale(), this.cPaymentButton7.isSelected(), "", personDiscount, this.controller);
                if (this.cPaymentButton6.isSelected()) {
                    DocumentCorrection dc = new DocumentCorrection();
                    dc.setCorrectionTypeID(1);
                    dc.setFiscalPrinterID(FiscalPrinter.getIBFM(this.controller.getSettings().getFiscalFolder()));
                    dc.setDate(new Date());
                    dc.setDoucmentID(documentId);
                    dc.setWorkDayID(WorkDay.getFromDb(this.controller.getPointOfSale(), this.controller.getSettings().getConnection()).getWorkDayID());
                    dc.setUserCreated(this.controller.getUser().getUserID());
                    dc.insert(this.controller.getUser(), this.controller.getSettings().getConnection());
                }
                if (this.stampaGotovinskog.isSelected()) {
                    Document.getByID(documentId, this.controller.getSettings().getConnection()).printInvoice(new Person(), this.controller.getBillList().get(this.controller.getActiveBill()).getCashBuyer(), this.controller, this.rootPane.getScene().getWindow());
                }
                this.stampaGotovinskog.setSelected(false);
                if (this.controller.getCurrentBill().getPaymentMethod().getParentPaymentMethodID() < 1) {
                    switch (this.controller.getCurrentBill().getPaymentMethod().getPaymentMethodID()) {
                        case -1: 
                        case 1: {
                            DocumentPayment.insert(documentId, 1, this.ukupno, this.controller.getSettings().getConnection());
                            break;
                        }
                        case 2: {
                            DocumentPayment.insert(documentId, 2, this.ukupno, this.controller.getSettings().getConnection());
                            break;
                        }
                        case 3: {
                            DocumentPayment.insert(documentId, 3, this.ukupno, this.controller.getSettings().getConnection());
                            break;
                        }
                        case 4: {
                            DocumentPayment.insert(documentId, 4, this.ukupno, this.controller.getSettings().getConnection());
                            break;
                        }
                        case 5: {
                            DocumentPayment.insert(documentId, 5, this.ukupno, this.controller.getSettings().getConnection());
                            break;
                        }
                        case 6: {
                            if (this.gotovina > 0.0) {
                                DocumentPayment.insert(documentId, 1, this.gotovina, this.controller.getSettings().getConnection());
                            }
                            if (this.kartica > 0.0) {
                                DocumentPayment.insert(documentId, 2, this.kartica, this.controller.getSettings().getConnection());
                            }
                            if (this.cek > 0.0) {
                                DocumentPayment.insert(documentId, 3, this.cek, this.controller.getSettings().getConnection());
                            }
                            if (!(this.virman > 0.0)) break;
                            DocumentPayment.insert(documentId, 4, this.virman, this.controller.getSettings().getConnection());
                        }
                    }
                }
                if (this.controller.getCurrentBill().getLastRound().createOrder() && this.controller.getCurrentBill().getPaymentMethod().getParentPaymentMethodID() < 1 && !this.cPaymentButton7.isSelected() && !this.cPaymentButton6.isSelected() && (orderId = Order.insertOrder(this.controller.getCurrentBill().getLastRound(), documentId, this.controller)) > 0L) {
                    ObservableList<OrderDetaile> orderDetails = OrderDetaile.getListFP(orderId, this.controller);
                    String[] orderKitchen = new String[orderDetails.size()];
                    for (int i = 0; i < orderDetails.size(); ++i) {
                        orderKitchen[i] = ((OrderDetaile)orderDetails.get(i)).getName().length() > 15 ? String.format("%2.0f x%-24s", ((OrderDetaile)orderDetails.get(i)).getQuantity(), ((OrderDetaile)orderDetails.get(i)).getName().substring(0, 15).trim()) : String.format("%2.0f x%-24s", ((OrderDetaile)orderDetails.get(i)).getQuantity(), ((OrderDetaile)orderDetails.get(i)).getName().trim());
                    }
                    FiscalPrinter.printNonFiscal(this.controller.getSettings().getFiscalFolder(), orderKitchen);
                }
                if (!(posResult = PosPrinter.printRound(this.controller.getSettings().getPosFolder(), this.controller.getSettings().getPosPrinter(), this.controller.getBillList().get(this.controller.getActiveBill()).getRoundList().get(0), this.controller.getObject().getName(), this.controller.getPointOfSale().getName(), "", "", this.controller.getUser().getUserName(), this.controller.getSettings().getConnection()))) {
                    Log.writeLog(this.controller.getUser(), "Error: gre\ufffdka pri POS \ufffdtampi PointOfSaleID =" + this.controller.getPointOfSale().getPointOfSaleID(), this.controller.getSettings().getConnection());
                    LOGGER.severe("Error: gre\ufffdka pri POS \ufffdtampi PointOfSaleID =" + this.controller.getPointOfSale().getPointOfSaleID());
                    this.controller.alert("Gre\ufffdka pri POS \ufffdtampi", "Gre\ufffdkla prilikom slanja na POS \ufffdtampa\ufffd!", this.rootPane.getScene().getWindow());
                }
                String BI = "";
                if (this.controller.getCurrentBill().getPaymentMethod().getParentPaymentMethodID() == 0 && !this.cPaymentButton7.isSelected() && !this.cPaymentButton6.isSelected()) {
                    double g = 0.0;
                    if (!this.combinedPane.isVisible()) {
                        switch (this.controller.getCurrentBill().getPaymentMethod().getCode()) {
                            case "CASH": {
                                g = this.uplaceno;
                                this.kartica = 0.0;
                                this.cek = 0.0;
                                this.virman = 0.0;
                                break;
                            }
                            case "CARD": {
                                g = 0.0;
                                this.kartica = this.ukupno;
                                this.cek = 0.0;
                                this.virman = 0.0;
                                break;
                            }
                            case "CHECK": 
                            case "F": {
                                g = 0.0;
                                this.kartica = 0.0;
                                this.cek = this.ukupno;
                                this.virman = 0.0;
                                break;
                            }
                            case "TRANSFER": {
                                g = 0.0;
                                this.kartica = 0.0;
                                this.cek = 0.0;
                                this.virman = this.ukupno;
                            }
                        }
                    }
                    BI = FiscalPrinter.printBill(this.controller.getSettings().getFiscalFolder(), this.controller.getBillList().get(this.controller.getActiveBill()), g, this.kartica, this.cek, this.virman, this.controller.getUser().getUserName(), this.controller.getSettings().getConnection(), this.controller.getPointOfSale());
                    Document d = Document.getByID(documentId, this.controller.getSettings().getConnection());
                    d.setFullNumber(BI);
                    d.setAlternativeFullNumber(FiscalPrinter.getIBFM(this.controller.getSettings().getFiscalFolder()));
                    d.update(this.controller);
                }
                if (this.controller.getCurrentBill().getPaymetnMethodID() == 5) {
                    Document doc = new Document();
                    Document docParent = Document.getByID(documentId, this.controller.getSettings().getConnection());
                    doc.setPersonID(personID);
                    docParent.setPersonID(personID);
                    docParent.update(this.controller);
                    doc.setDocumentTypeID(4);
                    doc.setPaymentMethodID(5);
                    doc.setNumber(Document.getNextNumberForDocumentType(4, this.controller.getObject(), this.controller));
                    doc.setYear(docParent.getYear());
                    doc.setSum(this.controller.getCurrentBill().getSumWithDiscout());
                    doc.setDiscount(0.0);
                    doc.setSumWithDiscount(this.controller.getCurrentBill().getSumWithDiscout());
                    doc.setDocumentStatusID(1);
                    doc.setPointOfSaleID(this.controller.getPointOfSale().getPointOfSaleID());
                    doc.setSysUserAddID(this.controller.getUser().getUserID());
                    doc.insert(this.controller);
                    doc.insertParent(1, documentId, this.controller.getSettings().getConnection());
                    Faktura f = new Faktura();
                    f.setDocument(doc);
                    f.setParentDocumentID(documentId);
                    f.print(this.controller, this.rootPane.getScene().getWindow());
                }
                this.controller.getBillList().remove(this.controller.getActiveBill());
                this.controller.setActiveBill(-1);
            }
            catch (IOException | SQLException e) {
                LOGGER.severe(e.getMessage());
                this.controller.alert("Gre\ufffdka prilikom snimanja ra\ufffduna!", "Do\ufffdlo je do gre\ufffdke prilikom snimanja ra\ufffduna. \nPoruka gre\ufffdke: \n" + e.getMessage(), this.rootPane.getScene().getWindow());
                Log.writeLog(this.controller.getUser(), "PointOfSale: " + this.controller.getPointOfSale().getName() + " " + e.getLocalizedMessage(), this.controller.getSettings().getConnection());
            }
        }
        try {
            if (this.controller.getCurrentBill().getLastRound().getItemList().size() > 0 && this.controller.getCurrentBill().getPaymentMethod().getParentPaymentMethodID() != 0 && (!this.combinedButton.isSelected() || this.combinedButton.isSelected() && this.ostatak == 0.0)) {
                this.controller.setAuthorizationRequest(2);
                HashMap<String, Object> hm = new HashMap<String, Object>();
                hm.put("controller", this.controller);
                mr = this.controller.showModalDialog("Autorizacija", ScreensController.SCREEN_AUTHORISATION, hm, this.rootPane.getScene().getWindow());
                if (mr == ScreensController.MODAL_RESULT_OK) {
                    this.controller.getScreen(ScreensController.SCREEN_FASTFOOD, this.controller.getRoot(), ScreensController.SCREEN_PAYMENT);
                }
            }
            if (this.combinedButton.isSelected() && this.combinedButton.isSelected() && this.ostatak != 0.0) {
                this.controller.alert("Pogre\ufffdan izbor kombinovanog pla\ufffdanja", "Izabrano je kombinovano pla\ufffdanje, ali je ostatak ve\ufffdi ili manji od 0", this.rootPane.getScene().getWindow());
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        this.postButton.setDisable(false);
        this.controller.getScreen(ScreensController.SCREEN_FASTFOOD, this.controller.getRoot(), ScreensController.SCREEN_PAYMENT);
    }

    @FXML
    private void gotovinskiClick() {
    }

    @FXML
    private void toggleButtonPayCardClick() {
    }

    private void fillPaymentMethodButtons() {
        ArrayList<PaymentMethod> list = PaymentMethod.getList(this.controller.getSettings().getConnection());
        for (int i = 0; i < 8; ++i) {
            try {
                this.fillPaymentButton(i, list.get(i).getName(), list.get(i).isIsDefault());
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    private void fillPaymentButton(int index, String name, boolean isDefault) {
        switch (index) {
            case 0: {
                this.paymentButton0.setText(name);
                this.paymentButton0.setSelected(isDefault);
                break;
            }
            case 1: {
                this.paymentButton1.setText(name);
                this.paymentButton1.setSelected(isDefault);
                break;
            }
            case 2: {
                this.paymentButton2.setText(name);
                this.paymentButton2.setSelected(isDefault);
                break;
            }
            case 3: {
                this.paymentButton3.setText(name);
                this.paymentButton3.setSelected(isDefault);
                break;
            }
            case 4: {
                this.paymentButton4.setText(name);
                this.paymentButton4.setSelected(isDefault);
                break;
            }
            case 5: {
                this.paymentButton5.setText(name);
                this.paymentButton5.setSelected(isDefault);
                break;
            }
            case 6: {
                this.paymentButton6.setText(name);
                this.paymentButton6.setSelected(isDefault);
                break;
            }
            case 7: {
                this.paymentButton7.setText(name);
                this.paymentButton7.setSelected(isDefault);
            }
        }
    }

    private void fillCPaymentMethodButtons() {
        ArrayList<PaymentMethod> list = PaymentMethod.getComplexList(this.controller.getSettings().getConnection());
        for (int i = 0; i < 6; ++i) {
            try {
                this.fillCPaymentButton(i, list.get(i).getName(), list.get(i).isIsDefault());
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        if (this.controller.getUser().hasRole("manager")) {
            this.fillCPaymentButton(6, "Bez fiskalne \ufffdtampe", false);
            this.cPaymentButton6.setDisable(false);
            this.fillCPaymentButton(7, "Ru\ufffdno pisani fiskalni ra\ufffdun", false);
            this.cPaymentButton7.setDisable(false);
        } else {
            this.fillCPaymentButton(6, "", false);
            this.cPaymentButton6.setDisable(true);
            this.fillCPaymentButton(7, "", false);
            this.cPaymentButton7.setDisable(true);
        }
    }

    private void fillCPaymentButton(int index, String name, boolean isDefault) {
        switch (index) {
            case 0: {
                this.cPaymentButton0.setText(name);
                this.cPaymentButton0.setSelected(isDefault);
                break;
            }
            case 1: {
                this.cPaymentButton1.setText(name);
                this.cPaymentButton1.setSelected(isDefault);
                break;
            }
            case 2: {
                this.cPaymentButton2.setText(name);
                this.cPaymentButton2.setSelected(isDefault);
                break;
            }
            case 3: {
                this.cPaymentButton3.setText(name);
                this.cPaymentButton3.setSelected(isDefault);
                break;
            }
            case 4: {
                this.cPaymentButton4.setText(name);
                this.cPaymentButton4.setSelected(isDefault);
                break;
            }
            case 5: {
                this.cPaymentButton5.setText(name);
                this.cPaymentButton5.setSelected(isDefault);
                break;
            }
            case 6: {
                this.cPaymentButton6.setText(name);
                this.cPaymentButton6.setSelected(isDefault);
                break;
            }
            case 7: {
                this.cPaymentButton7.setText(name);
                this.cPaymentButton7.setSelected(isDefault);
            }
        }
    }

    public void prenosClicked(MouseEvent mouseEvent) {
    }
}

