/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller;

import java.util.HashMap;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;

public class LoyalityPointsPickDialogController
implements DialogController {
    @FXML
    private BorderPane rootPane;
    @FXML
    private Button dialogNo;
    @FXML
    private Button dialogYes;
    @FXML
    private Label dialogTitle;
    @FXML
    private TextField tfPoints;
    ScreensController controller;
    private double numberPoints;
    EventHandler<KeyEvent> handler = new EventHandler<KeyEvent>(){

        public void handle(KeyEvent event) {
            switch (event.getCode()) {
                case RIGHT: {
                    event.consume();
                    LoyalityPointsPickDialogController.this.dialogYes.requestFocus();
                    break;
                }
                case LEFT: {
                    event.consume();
                    LoyalityPointsPickDialogController.this.dialogNo.requestFocus();
                    break;
                }
                case ENTER: {
                    event.consume();
                    LoyalityPointsPickDialogController.this.confirm();
                    break;
                }
            }
        }
    };
    HashMap<String, Object> parameter;
    int modalResult = ScreensController.MODAL_RESULT_CANCEL;

    @FXML
    public void closeAction(ActionEvent event) {
        if (event.getSource() == this.dialogNo) {
            this.modalResult = ScreensController.MODAL_RESULT_NO;
            ((Stage)this.rootPane.getScene().getWindow()).close();
        } else if (Double.parseDouble(this.tfPoints.getText()) > this.numberPoints) {
            this.controller.alert("Obavestenje", "Ne mozete izabrati vise bodova od onog sto imate na stanju", this.rootPane.getScene().getWindow());
        } else {
            this.parameter.put("vrednostBodova", Double.parseDouble(this.tfPoints.getText()));
            this.modalResult = ScreensController.MODAL_RESULT_YES;
            ((Stage)this.rootPane.getScene().getWindow()).close();
        }
    }

    public void confirm() {
        if (this.dialogNo.isFocused()) {
            this.modalResult = ScreensController.MODAL_RESULT_NO;
            ((Stage)this.rootPane.getScene().getWindow()).close();
        } else if (Double.parseDouble(this.tfPoints.getText()) > this.numberPoints) {
            this.controller.alert("Obavestenje", "Ne mozete izabratyi vise bodova od ono sto imate na stanju", this.rootPane.getScene().getWindow());
        } else {
            this.parameter.put("vrednostBodova", Double.parseDouble(this.tfPoints.getText()));
            this.modalResult = ScreensController.MODAL_RESULT_YES;
            ((Stage)this.rootPane.getScene().getWindow()).close();
        }
    }

    @Override
    public void setParameter(HashMap<String, Object> parameter) {
        this.parameter = parameter;
        this.controller = (ScreensController)parameter.get("controller");
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/tableTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.rootPane.setOnKeyPressed(this.handler);
        this.numberPoints = (Double)parameter.get("LoyalityPoints");
        this.tfPoints.setText("" + this.numberPoints);
    }

    @Override
    public HashMap<String, Object> getParameter() {
        return this.parameter;
    }

    @Override
    public int getModalResult() {
        return this.modalResult;
    }

    @Override
    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }
}

