/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller;

import java.util.HashMap;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Settings;

public class LoyalityPointsDialogController
implements DialogController {
    @FXML
    private BorderPane rootPane;
    @FXML
    private Button dialogNo;
    @FXML
    private Button dialogYes;
    @FXML
    private Label dialogTitle;
    @FXML
    private Label lblPoints;
    @FXML
    private Label lblPointsValue;
    ScreensController controller;
    EventHandler<KeyEvent> handler = new EventHandler<KeyEvent>(){

        public void handle(KeyEvent event) {
            switch (event.getCode()) {
                case RIGHT: {
                    event.consume();
                    LoyalityPointsDialogController.this.dialogYes.requestFocus();
                    break;
                }
                case LEFT: {
                    event.consume();
                    LoyalityPointsDialogController.this.dialogNo.requestFocus();
                    break;
                }
                case ENTER: {
                    event.consume();
                    LoyalityPointsDialogController.this.confirm();
                    break;
                }
            }
        }
    };
    HashMap<String, Object> parameter;
    int modalResult = ScreensController.MODAL_RESULT_CANCEL;

    @FXML
    public void closeAction(ActionEvent event) {
        this.modalResult = event.getSource() == this.dialogNo ? ScreensController.MODAL_RESULT_NO : ScreensController.MODAL_RESULT_YES;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    public void confirm() {
        this.modalResult = this.dialogNo.isFocused() ? ScreensController.MODAL_RESULT_NO : ScreensController.MODAL_RESULT_YES;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    @Override
    public void setParameter(HashMap<String, Object> parameter) {
        this.parameter = parameter;
        this.controller = (ScreensController)parameter.get("controller");
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/tableTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.rootPane.setOnKeyPressed(this.handler);
        this.dialogTitle.setText(parameter.get("LoyalitiName").toString());
        this.lblPoints.setText(String.valueOf(Settings.round((Double)parameter.get("LoyalityPoints"), 2)));
        this.lblPoints.setStyle("-fx-font-size: 30px;");
        this.lblPointsValue.setText(String.valueOf(Settings.round((Double)parameter.get("LoyalityPointsValue"), 2)));
        this.lblPointsValue.setStyle("-fx-font-size: 30px;");
    }

    @Override
    public HashMap<String, Object> getParameter() {
        return this.parameter;
    }

    @Override
    public int getModalResult() {
        return this.modalResult;
    }

    @Override
    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }
}

