/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller;

import java.util.HashMap;
import java.util.Map;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextField;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.licence.LicLogic;
import rs.petcom.master.licence.exception.MacAddressReadException;

public class LicenceScreenController
implements DialogController {
    ScreensController controller;
    int modalResult;
    HashMap<String, Object> parameter;
    @FXML
    private BorderPane rootPane;
    @FXML
    private TextField tfLicence;
    @FXML
    private TextField tfCtrlCode;
    @FXML
    private ContextMenu cmCtrlCode;
    @FXML
    private MenuItem miCopy;
    private String licence;

    @Override
    public void setParameter(HashMap<String, Object> parameter) {
        this.controller = (ScreensController)parameter.get("controller");
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/tableTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.licence = null;
        try {
            this.licence = LicLogic.getControlCode(this.controller.getObject().getPIB(), (byte)0);
        }
        catch (MacAddressReadException e) {
            e.printStackTrace();
        }
        this.tfCtrlCode.setStyle("-fx-background-color: #21252e; -fx-font-size: 30; -fx-text-fill: white;");
        this.tfCtrlCode.setText(this.licence);
        this.parameter = parameter;
        this.miCopy.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                Clipboard clipboard = Clipboard.getSystemClipboard();
                ClipboardContent content = new ClipboardContent();
                content.putString(LicenceScreenController.this.tfCtrlCode.getText());
                clipboard.setContent((Map)content);
            }
        });
        this.tfCtrlCode.setContextMenu(this.cmCtrlCode);
        this.tfCtrlCode.setEditable(false);
        this.tfLicence.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (newValue.toUpperCase().trim().equals(LicenceScreenController.this.licence)) {
                    LicenceScreenController.this.tfLicence.setText("");
                }
            }
        });
    }

    @Override
    public HashMap<String, Object> getParameter() {
        return null;
    }

    @Override
    public int getModalResult() {
        return this.modalResult;
    }

    @Override
    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }

    @FXML
    private void confirm() {
        if (!this.tfLicence.getText().equals("")) {
            this.parameter.put("licence", this.tfLicence.getText().toUpperCase());
            this.modalResult = ScreensController.MODAL_RESULT_OK;
            ((Stage)this.rootPane.getScene().getWindow()).close();
        }
    }

    @FXML
    private void cancel() {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }
}

